/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.junit.ui.ITestRunListener2;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.junit.ITestRunListener;

public class RemoteTestRunnerClient {
    private ITestRunListener[] fListeners;
    private ServerSocket fServerSocket;
    private Socket fSocket;
    private int fPort = -1;
    private PrintWriter fWriter;
    private BufferedReader fBufferedReader;
    private String fVersion;
    private boolean fInReadTrace = false;
    private boolean fInReadRerunTrace = false;
    private String fFailedTest;
    private String fFailedTestId;
    private String fFailedTrace;
    private String fFailedRerunTrace;
    private int fFailureKind;
    private boolean fDebug = false;

    public synchronized void startListening(ITestRunListener[] listeners, int port) {
        this.fListeners = listeners;
        this.fPort = port;
        ServerConnection connection = new ServerConnection(port);
        connection.start();
    }

    public synchronized void stopTest() {
        if (this.isRunning()) {
            this.fWriter.println(">STOP   ");
            this.fWriter.flush();
        }
    }

    private synchronized void shutDown() {
        if (this.fDebug) {
            System.out.println("shutdown " + this.fPort);
        }
        if (this.fWriter != null) {
            this.fWriter.close();
            this.fWriter = null;
        }
        try {
            if (this.fBufferedReader != null) {
                this.fBufferedReader.close();
                this.fBufferedReader = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.fSocket != null) {
                this.fSocket.close();
                this.fSocket = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.fServerSocket != null) {
                this.fServerSocket.close();
                this.fServerSocket = null;
            }
        }
        catch (IOException iOException) {}
    }

    public boolean isRunning() {
        return this.fSocket != null;
    }

    private String readMessage(BufferedReader in) throws IOException {
        return in.readLine();
    }

    private void receiveMessage(String message) {
        if (message.startsWith("%TRACES ")) {
            this.fInReadTrace = true;
            this.fFailedTrace = "";
            return;
        }
        if (message.startsWith("%TRACEE ")) {
            this.fInReadTrace = false;
            this.notifyTestFailed();
            this.fFailedTrace = "";
            return;
        }
        if (this.fInReadTrace) {
            this.fFailedTrace = String.valueOf(this.fFailedTrace) + message + '\n';
            return;
        }
        if (message.startsWith("%RTRACES")) {
            this.fInReadRerunTrace = true;
            this.fFailedRerunTrace = "";
            return;
        }
        if (message.startsWith("%RTRACEE")) {
            this.fInReadRerunTrace = false;
            return;
        }
        if (this.fInReadRerunTrace) {
            this.fFailedRerunTrace = String.valueOf(this.fFailedRerunTrace) + message + '\n';
            return;
        }
        String arg = message.substring(8);
        if (message.startsWith("%TESTC  ")) {
            int count = 0;
            int v = arg.indexOf(32);
            if (v == -1) {
                this.fVersion = "v1";
                count = Integer.parseInt(arg);
            } else {
                this.fVersion = arg.substring(v + 1);
                String sc = arg.substring(0, v);
                count = Integer.parseInt(sc);
            }
            this.notifyTestRunStarted(count);
            return;
        }
        if (message.startsWith("%TESTS  ")) {
            this.notifyTestStarted(arg);
            return;
        }
        if (message.startsWith("%TESTE  ")) {
            this.notifyTestEnded(arg);
            return;
        }
        if (message.startsWith("%ERROR  ")) {
            this.extractFailure(arg, 1);
            return;
        }
        if (message.startsWith("%FAILED ")) {
            this.extractFailure(arg, 2);
            return;
        }
        if (message.startsWith("%RUNTIME")) {
            long elapsedTime = Long.parseLong(arg);
            this.testRunEnded(elapsedTime);
            return;
        }
        if (message.startsWith("%TSTSTP ")) {
            long elapsedTime = Long.parseLong(arg);
            this.notifyTestRunStopped(elapsedTime);
            this.shutDown();
            return;
        }
        if (message.startsWith("%TSTTREE")) {
            this.notifyTestTreeEntry(arg);
            return;
        }
        if (message.startsWith("%TSTRERN")) {
            if (this.hasTestId()) {
                this.scanReranMessage(arg);
            } else {
                this.scanOldReranMessage(arg);
            }
        }
    }

    private void scanOldReranMessage(String arg) {
        int c = arg.indexOf(" ");
        int t = arg.indexOf(" ", c + 1);
        String className = arg.substring(0, c);
        String testName = arg.substring(c + 1, t);
        String status = arg.substring(t + 1);
        int statusCode = 0;
        if (status.equals("FAILURE")) {
            statusCode = 2;
        } else if (status.equals("ERROR")) {
            statusCode = 1;
        }
        String trace = "";
        if (statusCode != 0) {
            trace = this.fFailedRerunTrace;
        }
        this.notifyTestReran(String.valueOf(className) + testName, className, testName, statusCode, trace);
    }

    private void scanReranMessage(String arg) {
        int i = arg.indexOf(32);
        int c = arg.indexOf(32, i + 1);
        int t = arg.indexOf(32, c + 1);
        String testId = arg.substring(0, i);
        String className = arg.substring(i + 1, c);
        String testName = arg.substring(c + 1, t);
        String status = arg.substring(t + 1);
        int statusCode = 0;
        if (status.equals("FAILURE")) {
            statusCode = 2;
        } else if (status.equals("ERROR")) {
            statusCode = 1;
        }
        String trace = "";
        if (statusCode != 0) {
            trace = this.fFailedRerunTrace;
        }
        this.notifyTestReran(testId, className, testName, statusCode, trace);
    }

    private void extractFailure(String arg, int status) {
        String[] s = this.extractTestId(arg);
        this.fFailedTestId = s[0];
        this.fFailedTest = s[1];
        this.fFailureKind = status;
    }

    String[] extractTestId(String arg) {
        String[] result = new String[2];
        if (!this.hasTestId()) {
            result[0] = arg;
            result[1] = arg;
            return result;
        }
        int i = arg.indexOf(44);
        result[0] = arg.substring(0, i);
        result[1] = arg.substring(i + 1, arg.length());
        return result;
    }

    private boolean hasTestId() {
        return this.fVersion.equals("v2");
    }

    private void notifyTestReran(final String testId, final String className, final String testName, final int statusCode, final String trace) {
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener listener = this.fListeners[i];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.testReran(testId, className, testName, statusCode, trace);
                }
            });
            ++i;
        }
    }

    private void notifyTestTreeEntry(String treeEntry) {
        int i = 0;
        while (i < this.fListeners.length) {
            if (this.fListeners[i] instanceof ITestRunListener2) {
                ITestRunListener2 listener = (ITestRunListener2)this.fListeners[i];
                if (!this.hasTestId()) {
                    listener.testTreeEntry(this.fakeTestId(treeEntry));
                } else {
                    listener.testTreeEntry(treeEntry);
                }
            }
            ++i;
        }
    }

    private String fakeTestId(String treeEntry) {
        int index0 = treeEntry.indexOf(44);
        String testName = treeEntry.substring(0, index0).trim();
        return String.valueOf(testName) + "," + treeEntry;
    }

    private void notifyTestRunStopped(final long elapsedTime) {
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener listener = this.fListeners[i];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.testRunStopped(elapsedTime);
                }
            });
            ++i;
        }
    }

    private void testRunEnded(final long elapsedTime) {
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener listener = this.fListeners[i];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.testRunEnded(elapsedTime);
                }
            });
            ++i;
        }
    }

    private void notifyTestEnded(final String test) {
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener listener = this.fListeners[i];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    String[] s = RemoteTestRunnerClient.this.extractTestId(test);
                    listener.testEnded(s[0], s[1]);
                }
            });
            ++i;
        }
    }

    private void notifyTestStarted(final String test) {
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener listener = this.fListeners[i];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    String[] s = RemoteTestRunnerClient.this.extractTestId(test);
                    listener.testStarted(s[0], s[1]);
                }
            });
            ++i;
        }
    }

    private void notifyTestRunStarted(final int count) {
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener listener = this.fListeners[i];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.testRunStarted(count);
                }
            });
            ++i;
        }
    }

    private void notifyTestFailed() {
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener listener = this.fListeners[i];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.testFailed(RemoteTestRunnerClient.this.fFailureKind, RemoteTestRunnerClient.this.fFailedTestId, RemoteTestRunnerClient.this.fFailedTest, RemoteTestRunnerClient.this.fFailedTrace);
                }
            });
            ++i;
        }
    }

    private void notifyTestRunTerminated() {
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener listener = this.fListeners[i];
            Platform.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.testRunTerminated();
                }
            });
            ++i;
        }
    }

    public void rerunTest(String testId, String className, String testName) {
        if (this.isRunning()) {
            this.fWriter.println(">RERUN  " + testId + " " + className + " " + testName);
            this.fWriter.flush();
        }
    }

    public abstract class ListenerSafeRunnable
    implements ISafeRunnable {
        public void handleException(Throwable exception) {
            JUnitPlugin.log(exception);
        }
    }

    private class ServerConnection
    extends Thread {
        int fPort;

        public ServerConnection(int port) {
            super("ServerConnection");
            this.fPort = port;
        }

        public void run() {
            try {
                String message;
                if (RemoteTestRunnerClient.this.fDebug) {
                    System.out.println("Creating server socket " + this.fPort);
                }
                RemoteTestRunnerClient.this.fServerSocket = new ServerSocket(this.fPort);
                RemoteTestRunnerClient.this.fSocket = RemoteTestRunnerClient.this.fServerSocket.accept();
                RemoteTestRunnerClient.this.fBufferedReader = new BufferedReader(new InputStreamReader(RemoteTestRunnerClient.this.fSocket.getInputStream()));
                RemoteTestRunnerClient.this.fWriter = new PrintWriter(RemoteTestRunnerClient.this.fSocket.getOutputStream(), true);
                while (RemoteTestRunnerClient.this.fBufferedReader != null && (message = RemoteTestRunnerClient.this.readMessage(RemoteTestRunnerClient.this.fBufferedReader)) != null) {
                    RemoteTestRunnerClient.this.receiveMessage(message);
                }
            }
            catch (SocketException socketException) {
                RemoteTestRunnerClient.this.notifyTestRunTerminated();
            }
            catch (IOException e) {
                System.out.println(e);
            }
            RemoteTestRunnerClient.this.shutDown();
        }
    }
}

