/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.ExceptionHandler;
import org.eclipse.jdt.internal.junit.util.SWTUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class JUnitPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DEFAULT_NEW_FILTER_TEXT = "";
    private static final Image IMG_CUNIT = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    private static final Image IMG_PKG = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
    private static String[] fgDefaultFilterPatterns = new String[]{"org.eclipse.jdt.internal.junit.runner.*", "org.eclipse.jdt.internal.junit.ui.*", "junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert", "java.lang.reflect.Method.invoke"};
    private CheckboxTableViewer fFilterViewer;
    private Table fFilterTable;
    private Button fShowOnErrorCheck;
    private Button fAddPackageButton;
    private Button fAddTypeButton;
    private Button fRemoveFilterButton;
    private Button fAddFilterButton;
    private Button fEnableAllButton;
    private Button fDisableAllButton;
    private Text fEditorText;
    private String fInvalidEditorText = null;
    private TableEditor fTableEditor;
    private TableItem fNewTableItem;
    private Filter fNewStackFilter;
    private Label fTableLabel;
    private StackFilterContentProvider fStackFilterContentProvider;

    public JUnitPreferencePage() {
        this.setDescription(JUnitMessages.getString("JUnitPreferencePage.description"));
        this.setPreferenceStore(JUnitPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.jdt.junit.junit_preference_page_context");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createStackFilterPreferences(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createStackFilterPreferences(Composite composite) {
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createShowCheck(container);
        this.createFilterTable(container);
        this.createStepFilterButtons(container);
    }

    private void createShowCheck(Composite composite) {
        this.fShowOnErrorCheck = new Button(composite, 32);
        this.fShowOnErrorCheck.setText(JUnitMessages.getString("JUnitPreferencePage.showcheck.label"));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.fShowOnErrorCheck.setLayoutData((Object)data);
        this.fShowOnErrorCheck.setSelection(JUnitPreferencePage.getShowOnErrorOnly());
    }

    private void createFilterTable(Composite container) {
        this.fTableLabel = new Label(container, 0);
        this.fTableLabel.setText(JUnitMessages.getString("JUnitPreferencePage.filter.label"));
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fTableLabel.setLayoutData((Object)gd);
        this.fFilterTable = new Table(container, 67618);
        gd = new GridData(768);
        this.fFilterTable.setLayoutData((Object)gd);
        TableLayout tableLayout = new TableLayout();
        ColumnLayoutData[] columnLayoutData = new ColumnLayoutData[]{new ColumnWeightData(100)};
        tableLayout.addColumnData(columnLayoutData[0]);
        this.fFilterTable.setLayout((Layout)tableLayout);
        new TableColumn(this.fFilterTable, 0);
        this.fFilterViewer = new CheckboxTableViewer(this.fFilterTable);
        this.fTableEditor = new TableEditor(this.fFilterTable);
        this.fFilterViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.fFilterViewer.setSorter((ViewerSorter)new FilterViewerSorter());
        this.fStackFilterContentProvider = new StackFilterContentProvider();
        this.fFilterViewer.setContentProvider((IContentProvider)this.fStackFilterContentProvider);
        this.fFilterViewer.setInput((Object)this);
        gd = new GridData(1808);
        this.fFilterViewer.getTable().setLayoutData((Object)gd);
        this.fFilterViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Filter filter = (Filter)event.getElement();
                JUnitPreferencePage.this.fStackFilterContentProvider.toggleFilter(filter);
            }
        });
        this.fFilterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                JUnitPreferencePage.this.fRemoveFilterButton.setEnabled(!selection.isEmpty());
            }
        });
    }

    private void createStepFilterButtons(Composite container) {
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddFilterButton = new Button(buttonContainer, 8);
        this.fAddFilterButton.setText(JUnitMessages.getString("JUnitPreferencePage.addfilterbutton.label"));
        this.fAddFilterButton.setToolTipText(JUnitMessages.getString("JUnitPreferencePage.addfilterbutton.tooltip"));
        gd = new GridData(770);
        this.fAddFilterButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.fAddFilterButton);
        this.fAddFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JUnitPreferencePage.this.editFilter();
            }
        });
        this.fAddTypeButton = new Button(buttonContainer, 8);
        this.fAddTypeButton.setText(JUnitMessages.getString("JUnitPreferencePage.addtypebutton.label"));
        this.fAddTypeButton.setToolTipText(JUnitMessages.getString("JUnitPreferencePage.addtypebutton.tooltip"));
        gd = this.getButtonGridData(this.fAddTypeButton);
        this.fAddTypeButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.fAddTypeButton);
        this.fAddTypeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JUnitPreferencePage.this.addType();
            }
        });
        this.fAddPackageButton = new Button(buttonContainer, 8);
        this.fAddPackageButton.setText(JUnitMessages.getString("JUnitPreferencePage.addpackagebutton.label"));
        this.fAddPackageButton.setToolTipText(JUnitMessages.getString("JUnitPreferencePage.addpackagebutton.tooltip"));
        gd = this.getButtonGridData(this.fAddPackageButton);
        this.fAddPackageButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.fAddPackageButton);
        this.fAddPackageButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JUnitPreferencePage.this.addPackage();
            }
        });
        this.fRemoveFilterButton = new Button(buttonContainer, 8);
        this.fRemoveFilterButton.setText(JUnitMessages.getString("JUnitPreferencePage.removefilterbutton.label"));
        this.fRemoveFilterButton.setToolTipText(JUnitMessages.getString("JUnitPreferencePage.removefilterbutton.tooltip"));
        gd = this.getButtonGridData(this.fRemoveFilterButton);
        this.fRemoveFilterButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.fRemoveFilterButton);
        this.fRemoveFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JUnitPreferencePage.this.removeFilters();
            }
        });
        this.fRemoveFilterButton.setEnabled(false);
        this.fEnableAllButton = new Button(buttonContainer, 8);
        this.fEnableAllButton.setText(JUnitMessages.getString("JUnitPreferencePage.enableallbutton.label"));
        this.fEnableAllButton.setToolTipText(JUnitMessages.getString("JUnitPreferencePage.enableallbutton.tooltip"));
        gd = this.getButtonGridData(this.fEnableAllButton);
        this.fEnableAllButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.fEnableAllButton);
        this.fEnableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JUnitPreferencePage.this.checkAllFilters(true);
            }
        });
        this.fDisableAllButton = new Button(buttonContainer, 8);
        this.fDisableAllButton.setText(JUnitMessages.getString("JUnitPreferencePage.disableallbutton.label"));
        this.fDisableAllButton.setToolTipText(JUnitMessages.getString("JUnitPreferencePage.disableallbutton.tooltip"));
        gd = this.getButtonGridData(this.fDisableAllButton);
        this.fDisableAllButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.fDisableAllButton);
        this.fDisableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JUnitPreferencePage.this.checkAllFilters(false);
            }
        });
    }

    private GridData getButtonGridData(Button button) {
        GridData gd = new GridData(770);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        gd.heightHint = this.convertVerticalDLUsToPixels(14);
        return gd;
    }

    public void init(IWorkbench workbench) {
    }

    private void editFilter() {
        if (this.fEditorText != null) {
            this.validateChangeAndCleanup();
        }
        this.fNewStackFilter = this.fStackFilterContentProvider.addFilter(DEFAULT_NEW_FILTER_TEXT, true);
        this.fNewTableItem = this.fFilterTable.getItem(0);
        int textStyles = 16388;
        if (!SWT.getPlatform().equals("motif")) {
            textStyles |= 0x800;
        }
        this.fEditorText = new Text((Composite)this.fFilterTable, textStyles);
        GridData gd = new GridData(1808);
        this.fEditorText.setLayoutData((Object)gd);
        this.fTableEditor.horizontalAlignment = 16384;
        this.fTableEditor.grabHorizontal = true;
        this.fTableEditor.setEditor((Control)this.fEditorText, this.fNewTableItem, 0);
        this.fEditorText.setText(this.fNewStackFilter.getName());
        this.fEditorText.selectAll();
        this.setEditorListeners(this.fEditorText);
        this.fEditorText.setFocus();
    }

    private void setEditorListeners(Text text) {
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\r') {
                    if (JUnitPreferencePage.this.fInvalidEditorText != null) {
                        JUnitPreferencePage.this.fEditorText.setText(JUnitPreferencePage.this.fInvalidEditorText);
                        JUnitPreferencePage.this.fInvalidEditorText = null;
                    } else {
                        JUnitPreferencePage.this.validateChangeAndCleanup();
                    }
                } else if (event.character == '\u001b') {
                    JUnitPreferencePage.this.removeNewFilter();
                    JUnitPreferencePage.this.cleanupEditor();
                }
            }
        });
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                if (JUnitPreferencePage.this.fInvalidEditorText != null) {
                    JUnitPreferencePage.this.fEditorText.setText(JUnitPreferencePage.this.fInvalidEditorText);
                    JUnitPreferencePage.this.fInvalidEditorText = null;
                } else {
                    JUnitPreferencePage.this.validateChangeAndCleanup();
                }
            }
        });
        text.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
    }

    private void validateChangeAndCleanup() {
        String trimmedValue = this.fEditorText.getText().trim();
        if (trimmedValue.length() < 1) {
            this.removeNewFilter();
        } else {
            if (!this.validateEditorInput(trimmedValue)) {
                this.fInvalidEditorText = trimmedValue;
                this.fEditorText.setText(JUnitMessages.getString("JUnitPreferencePage.invalidstepfilterreturnescape"));
                this.getShell().getDisplay().beep();
                return;
            }
            Object[] filters = this.fStackFilterContentProvider.getElements(null);
            int i = 0;
            while (i < filters.length) {
                Filter filter = (Filter)filters[i];
                if (filter.getName().equals(trimmedValue)) {
                    this.removeNewFilter();
                    this.cleanupEditor();
                    return;
                }
                ++i;
            }
            this.fNewTableItem.setText(trimmedValue);
            this.fNewStackFilter.setName(trimmedValue);
            this.fFilterViewer.refresh();
        }
        this.cleanupEditor();
    }

    private void cleanupEditor() {
        if (this.fEditorText == null) {
            return;
        }
        this.fNewStackFilter = null;
        this.fNewTableItem = null;
        this.fTableEditor.setEditor(null, null, 0);
        this.fEditorText.dispose();
        this.fEditorText = null;
    }

    private void removeNewFilter() {
        this.fStackFilterContentProvider.removeFilters(new Object[]{this.fNewStackFilter});
    }

    private boolean validateEditorInput(String trimmedValue) {
        char firstChar = trimmedValue.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar) || firstChar == '*') {
            return false;
        }
        int length = trimmedValue.length();
        int i = 1;
        while (i < length) {
            char c = trimmedValue.charAt(i);
            if (!(Character.isJavaIdentifierPart(c) || c == '.' && i != length - 1 || c == '*' && i == length - 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addType() {
        Shell shell = this.getShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false);
        }
        catch (JavaModelException jme) {
            String title = JUnitMessages.getString("JUnitPreferencePage.addtypedialog.title");
            String message = JUnitMessages.getString("JUnitPreferencePage.addtypedialog.error.message");
            ExceptionHandler.handle((CoreException)((Object)jme), shell, title, message);
            return;
        }
        dialog.setTitle(JUnitMessages.getString("JUnitPreferencePage.addtypedialog.title"));
        dialog.setMessage(JUnitMessages.getString("JUnitPreferencePage.addtypedialog.message"));
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = (IType)types[0];
            this.fStackFilterContentProvider.addFilter(type.getFullyQualifiedName(), true);
        }
    }

    private void addPackage() {
        Shell shell = this.getShell();
        ElementListSelectionDialog dialog = null;
        try {
            dialog = JUnitPlugin.createAllPackagesDialog(shell, null, true);
        }
        catch (JavaModelException jme) {
            String title = JUnitMessages.getString("JUnitPreferencePage.addpackagedialog.title");
            String message = JUnitMessages.getString("JUnitPreferencePage.addpackagedialog.error.message");
            ExceptionHandler.handle((CoreException)((Object)jme), shell, title, message);
            return;
        }
        dialog.setTitle(JUnitMessages.getString("JUnitPreferencePage.addpackagedialog.title"));
        dialog.setMessage(JUnitMessages.getString("JUnitPreferencePage.addpackagedialog.message"));
        dialog.setMultipleSelection(true);
        if (dialog.open() == 1) {
            return;
        }
        Object[] packages = dialog.getResult();
        if (packages == null) {
            return;
        }
        int i = 0;
        while (i < packages.length) {
            IJavaElement pkg = (IJavaElement)packages[i];
            String filter = pkg.getElementName();
            filter = filter.length() < 1 ? JUnitMessages.getString("JUnitMainTab.label.defaultpackage") : String.valueOf(filter) + ".*";
            this.fStackFilterContentProvider.addFilter(filter, true);
            ++i;
        }
    }

    private void removeFilters() {
        IStructuredSelection selection = (IStructuredSelection)this.fFilterViewer.getSelection();
        this.fStackFilterContentProvider.removeFilters(selection.toArray());
    }

    private void checkAllFilters(boolean check) {
        Object[] filters = this.fStackFilterContentProvider.getElements(null);
        int i = filters.length - 1;
        while (i >= 0) {
            ((Filter)filters[i]).setChecked(check);
            --i;
        }
        this.fFilterViewer.setAllChecked(check);
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("org.eclipse.jdt.junit.show_on_error", this.fShowOnErrorCheck.getSelection());
        this.fStackFilterContentProvider.saveFilters();
        return true;
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        this.fStackFilterContentProvider.setDefaults();
    }

    protected List createDefaultStackFiltersList() {
        return Arrays.asList(fgDefaultFilterPatterns);
    }

    protected List createActiveStackFiltersList() {
        return Arrays.asList(JUnitPreferencePage.getFilterPatterns());
    }

    protected List createInactiveStackFiltersList() {
        String[] strings = JUnitPreferencePage.parseList(this.getPreferenceStore().getString("org.eclipse.jdt.junit.inactive_filters"));
        return Arrays.asList(strings);
    }

    protected void updateActions() {
        if (this.fEnableAllButton == null) {
            return;
        }
        boolean enabled = this.fFilterViewer.getTable().getItemCount() > 0;
        this.fEnableAllButton.setEnabled(enabled);
        this.fDisableAllButton.setEnabled(enabled);
    }

    public static String[] getFilterPatterns() {
        IPreferenceStore store = JUnitPlugin.getDefault().getPreferenceStore();
        return JUnitPreferencePage.parseList(store.getString("org.eclipse.jdt.junit.active_filters"));
    }

    public static boolean getFilterStack() {
        IPreferenceStore store = JUnitPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.jdt.junit.do_filter_stack");
    }

    public static void setFilterStack(boolean filter) {
        IPreferenceStore store = JUnitPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.jdt.junit.do_filter_stack", filter);
    }

    public static void initializeDefaults(IPreferenceStore store) {
        store.setDefault("org.eclipse.jdt.junit.do_filter_stack", true);
        store.setDefault("org.eclipse.jdt.junit.show_on_error", true);
        String list = store.getString("org.eclipse.jdt.junit.active_filters");
        if (DEFAULT_NEW_FILTER_TEXT.equals(list)) {
            String pref = JUnitPreferencePage.serializeList(fgDefaultFilterPatterns);
            store.setValue("org.eclipse.jdt.junit.active_filters", pref);
        }
        store.setValue("org.eclipse.jdt.junit.inactive_filters", DEFAULT_NEW_FILTER_TEXT);
    }

    public static boolean getShowOnErrorOnly() {
        IPreferenceStore store = JUnitPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.jdt.junit.show_on_error");
    }

    private static String[] parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    private static String serializeList(String[] list) {
        if (list == null) {
            return DEFAULT_NEW_FILTER_TEXT;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.length) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(list[i]);
            ++i;
        }
        return buffer.toString();
    }

    private class Filter {
        private String fName;
        private boolean fChecked;

        public Filter(String name, boolean checked) {
            this.setName(name);
            this.setChecked(checked);
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
        }

        public boolean isChecked() {
            return this.fChecked;
        }

        public void setChecked(boolean checked) {
            this.fChecked = checked;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Filter)) {
                return false;
            }
            Filter other = (Filter)o;
            return this.getName().equals(other.getName());
        }

        public int hashCode() {
            return this.fName.hashCode();
        }
    }

    private class FilterViewerSorter
    extends WorkbenchViewerSorter {
        FilterViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ILabelProvider lprov = (ILabelProvider)((ContentViewer)viewer).getLabelProvider();
            String name1 = lprov.getText(e1);
            String name2 = lprov.getText(e2);
            if (name1 == null) {
                name1 = JUnitPreferencePage.DEFAULT_NEW_FILTER_TEXT;
            }
            if (name2 == null) {
                name2 = JUnitPreferencePage.DEFAULT_NEW_FILTER_TEXT;
            }
            if (name1.length() > 0 && name2.length() > 0) {
                char char1 = name1.charAt(name1.length() - 1);
                char char2 = name2.charAt(name2.length() - 1);
                if (char1 == '*' && char1 != char2) {
                    return -1;
                }
                if (char2 == '*' && char2 != char1) {
                    return 1;
                }
            }
            return name1.compareTo(name2);
        }
    }

    private class FilterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        FilterLabelProvider() {
        }

        public String getColumnText(Object object, int column) {
            return column == 0 ? ((Filter)object).getName() : JUnitPreferencePage.DEFAULT_NEW_FILTER_TEXT;
        }

        public String getText(Object element) {
            return ((Filter)element).getName();
        }

        public Image getColumnImage(Object object, int column) {
            String name = ((Filter)object).getName();
            if (name.endsWith(".*") || name.equals(JUnitMessages.getString("JUnitMainTab.label.defaultpackage"))) {
                return IMG_PKG;
            }
            if (JUnitPreferencePage.DEFAULT_NEW_FILTER_TEXT.equals(name)) {
                return null;
            }
            if (Character.isUpperCase(name.charAt(0)) && name.indexOf(46) < 0) {
                return IMG_CUNIT;
            }
            int lastDotIndex = name.lastIndexOf(46);
            if (-1 != lastDotIndex && name.length() - 1 != lastDotIndex && Character.isUpperCase(name.charAt(lastDotIndex + 1))) {
                return IMG_CUNIT;
            }
            return null;
        }
    }

    private class StackFilterContentProvider
    implements IStructuredContentProvider {
        private List fFilters;

        public StackFilterContentProvider() {
            List active = JUnitPreferencePage.this.createActiveStackFiltersList();
            List inactive = JUnitPreferencePage.this.createInactiveStackFiltersList();
            this.populateFilters(active, inactive);
        }

        public void setDefaults() {
            JUnitPreferencePage.this.fFilterViewer.remove(this.fFilters.toArray());
            List active = JUnitPreferencePage.this.createDefaultStackFiltersList();
            ArrayList inactive = new ArrayList();
            this.populateFilters(active, inactive);
        }

        protected void populateFilters(List activeList, List inactiveList) {
            this.fFilters = new ArrayList(activeList.size() + inactiveList.size());
            this.populateList(activeList, true);
            if (inactiveList.size() != 0) {
                this.populateList(inactiveList, false);
            }
        }

        protected void populateList(List list, boolean checked) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                this.addFilter(name, checked);
            }
        }

        public Filter addFilter(String name, boolean checked) {
            Filter filter = new Filter(name, checked);
            if (!this.fFilters.contains(filter)) {
                this.fFilters.add(filter);
                JUnitPreferencePage.this.fFilterViewer.add((Object)filter);
                JUnitPreferencePage.this.fFilterViewer.setChecked((Object)filter, checked);
            }
            JUnitPreferencePage.this.updateActions();
            return filter;
        }

        public void saveFilters() {
            ArrayList<String> active = new ArrayList<String>(this.fFilters.size());
            ArrayList<String> inactive = new ArrayList<String>(this.fFilters.size());
            Iterator iterator = this.fFilters.iterator();
            while (iterator.hasNext()) {
                Filter filter = (Filter)iterator.next();
                String name = filter.getName();
                if (filter.isChecked()) {
                    active.add(name);
                    continue;
                }
                inactive.add(name);
            }
            String pref = JUnitPreferencePage.serializeList(active.toArray(new String[active.size()]));
            JUnitPreferencePage.this.getPreferenceStore().setValue("org.eclipse.jdt.junit.active_filters", pref);
            pref = JUnitPreferencePage.serializeList(inactive.toArray(new String[inactive.size()]));
            JUnitPreferencePage.this.getPreferenceStore().setValue("org.eclipse.jdt.junit.inactive_filters", pref);
        }

        public void removeFilters(Object[] filters) {
            int i = filters.length - 1;
            while (i >= 0) {
                Filter filter = (Filter)filters[i];
                this.fFilters.remove(filter);
                --i;
            }
            JUnitPreferencePage.this.fFilterViewer.remove(filters);
            JUnitPreferencePage.this.updateActions();
        }

        public void toggleFilter(Filter filter) {
            boolean newState = !filter.isChecked();
            filter.setChecked(newState);
            JUnitPreferencePage.this.fFilterViewer.setChecked((Object)filter, newState);
        }

        public Object[] getElements(Object inputElement) {
            return this.fFilters.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

