/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPreferencePage;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.junit.ITestRunListener;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class JUnitPlugin
extends AbstractUIPlugin
implements ILaunchListener {
    private static JUnitPlugin fgPlugin = null;
    public static final String PLUGIN_ID = "org.eclipse.jdt.junit";
    public static final String ID_EXTENSION_POINT_TESTRUN_LISTENERS = "org.eclipse.jdt.junit.testRunListeners";
    public static final String TEST_SUPERCLASS_NAME = "junit.framework.TestCase";
    public static final String TEST_INTERFACE_NAME = "junit.framework.Test";
    public static final String JUNIT_HOME = "JUNIT_HOME";
    private static URL fgIconBaseURL;
    private AbstractSet fTrackedLaunches = new HashSet(20);
    private List fTestRunListeners;

    public JUnitPlugin(IPluginDescriptor desc) {
        super(desc);
        fgPlugin = this;
        String pathSuffix = "icons/full/";
        try {
            fgIconBaseURL = new URL(this.getDescriptor().getInstallURL(), pathSuffix);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public static JUnitPlugin getDefault() {
        return fgPlugin;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workBenchWindow = JUnitPlugin.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (fgPlugin == null) {
            return null;
        }
        IWorkbench workBench = fgPlugin.getWorkbench();
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = JUnitPlugin.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public static String getPluginId() {
        return JUnitPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        JUnitPreferencePage.initializeDefaults(store);
    }

    public static void log(Throwable e) {
        JUnitPlugin.log((IStatus)new Status(4, JUnitPlugin.getPluginId(), 4, "Error", e));
    }

    public static void log(IStatus status) {
        JUnitPlugin.getDefault().getLog().log(status);
    }

    public static URL makeIconFileURL(String name) throws MalformedURLException {
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        return new URL(fgIconBaseURL, name);
    }

    static ImageDescriptor getImageDescriptor(String relativePath) {
        try {
            return ImageDescriptor.createFromURL((URL)JUnitPlugin.makeIconFileURL(relativePath));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void launchRemoved(ILaunch launch) {
        this.fTrackedLaunches.remove(launch);
        TestRunnerViewPart testRunnerViewPart = this.findTestRunnerViewPartInActivePage();
        if (testRunnerViewPart != null && testRunnerViewPart.isCreated() && launch.equals(testRunnerViewPart.getLastLaunch())) {
            testRunnerViewPart.reset();
        }
    }

    public void launchAdded(ILaunch launch) {
        this.fTrackedLaunches.add(launch);
    }

    public void connectTestRunner(ILaunch launch, IType launchedType, int port) {
        TestRunnerViewPart testRunnerViewPart = this.showTestRunnerViewPartInActivePage(this.findTestRunnerViewPartInActivePage());
        if (testRunnerViewPart != null) {
            testRunnerViewPart.startTestRunListening((IJavaElement)launchedType, port, launch);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TestRunnerViewPart showTestRunnerViewPartInActivePage(TestRunnerViewPart testRunner) {
        TestRunnerViewPart testRunnerViewPart;
        IWorkbenchPage page;
        IWorkbenchPart activePart;
        block8: {
            TestRunnerViewPart testRunnerViewPart2;
            block7: {
                TestRunnerViewPart testRunnerViewPart3;
                block6: {
                    activePart = null;
                    page = null;
                    try {
                        try {
                            if (testRunner != null && testRunner.isCreated()) {
                                testRunnerViewPart3 = testRunner;
                                Object var5_8 = null;
                                if (page == null) return testRunnerViewPart3;
                                if (activePart == null) return testRunnerViewPart3;
                                break block6;
                            }
                            page = JUnitPlugin.getActivePage();
                            if (page == null) {
                                testRunnerViewPart2 = null;
                                break block7;
                            }
                            activePart = page.getActivePart();
                            testRunnerViewPart = (TestRunnerViewPart)page.showView("org.eclipse.jdt.junit.ResultView");
                            break block8;
                        }
                        catch (PartInitException pie) {
                            JUnitPlugin.log(pie);
                            TestRunnerViewPart testRunnerViewPart4 = null;
                            Object var5_11 = null;
                            if (page == null) return testRunnerViewPart4;
                            if (activePart == null) return testRunnerViewPart4;
                            page.activate(activePart);
                            return testRunnerViewPart4;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_12 = null;
                        if (page == null) throw throwable;
                        if (activePart == null) throw throwable;
                        page.activate(activePart);
                        throw throwable;
                    }
                }
                page.activate(activePart);
                return testRunnerViewPart3;
            }
            Object var5_9 = null;
            if (page == null) return testRunnerViewPart2;
            if (activePart == null) return testRunnerViewPart2;
            page.activate(activePart);
            return testRunnerViewPart2;
        }
        Object var5_10 = null;
        if (page == null) return testRunnerViewPart;
        if (activePart == null) return testRunnerViewPart;
        page.activate(activePart);
        return testRunnerViewPart;
    }

    private TestRunnerViewPart findTestRunnerViewPartInActivePage() {
        IWorkbenchPage page = JUnitPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        return (TestRunnerViewPart)page.findView("org.eclipse.jdt.junit.ResultView");
    }

    public void launchChanged(final ILaunch launch) {
        if (!this.fTrackedLaunches.contains(launch)) {
            return;
        }
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        IType launchedType = null;
        int port = -1;
        if (config != null) {
            String portStr = launch.getAttribute("org.eclipse.jdt.junit.PORT");
            String typeStr = launch.getAttribute("org.eclipse.jdt.junit.TESTTYPE");
            if (portStr != null && typeStr != null) {
                port = Integer.parseInt(portStr);
                IJavaElement element = JavaCore.create((String)typeStr);
                if (element instanceof IType) {
                    launchedType = (IType)element;
                }
            }
        }
        if (launchedType != null) {
            this.fTrackedLaunches.remove(launch);
            final int finalPort = port;
            final IType finalType = launchedType;
            JUnitPlugin.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    JUnitPlugin.this.connectTestRunner(launch, finalType, finalPort);
                }
            });
        }
    }

    public void startup() throws CoreException {
        super.startup();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this);
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.removeLaunchListener((ILaunchListener)this);
    }

    public static Display getDisplay() {
        Shell shell = JUnitPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static ElementListSelectionDialog createAllPackagesDialog(Shell shell, IJavaProject[] originals, final boolean includeDefaultPackage) throws JavaModelException {
        final ArrayList packageList = new ArrayList();
        if (originals == null) {
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            IJavaModel model = JavaCore.create((IWorkspaceRoot)wsroot);
            originals = model.getJavaProjects();
        }
        final IJavaProject[] projects = originals;
        final JavaModelException[] exception = new JavaModelException[1];
        ProgressMonitorDialog monitor = new ProgressMonitorDialog(shell);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                try {
                    HashSet<String> packageNameSet = new HashSet<String>();
                    pm.beginTask(JUnitMessages.getString("JUnitPlugin.searching"), projects.length);
                    int i = 0;
                    while (i < projects.length) {
                        IPackageFragment[] pkgs = projects[i].getPackageFragments();
                        int j = 0;
                        while (j < pkgs.length) {
                            IPackageFragment pkg = pkgs[j];
                            if (pkg.hasChildren() || pkg.getNonJavaResources().length <= 0) {
                                String pkgName = pkg.getElementName();
                                if ((includeDefaultPackage || pkgName.length() != 0) && packageNameSet.add(pkgName)) {
                                    packageList.add(pkg);
                                }
                            }
                            ++j;
                        }
                        pm.worked(1);
                        ++i;
                    }
                    pm.done();
                }
                catch (JavaModelException jme) {
                    exception[0] = jme;
                }
            }
        };
        try {
            monitor.run(false, false, r);
        }
        catch (InvocationTargetException e) {
            JUnitPlugin.log(e);
        }
        catch (InterruptedException e) {
            JUnitPlugin.log(e);
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        int flags = JavaElementLabelProvider.SHOW_DEFAULT;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(flags));
        dialog.setIgnoreCase(false);
        dialog.setElements(packageList.toArray());
        return dialog;
    }

    private void loadTestRunListeners() {
        this.fTestRunListeners = new ArrayList();
        IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint(ID_EXTENSION_POINT_TESTRUN_LISTENERS);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        MultiStatus status = new MultiStatus(PLUGIN_ID, 0, "Could not load some testRunner extension points", null);
        int i = 0;
        while (i < configs.length) {
            try {
                ITestRunListener testRunListener = (ITestRunListener)configs[i].createExecutableExtension("class");
                this.fTestRunListeners.add(testRunListener);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++i;
        }
        if (!status.isOK()) {
            JUnitPlugin.log((IStatus)status);
        }
    }

    public List getTestRunListeners() {
        if (this.fTestRunListeners == null) {
            this.loadTestRunListeners();
        }
        return this.fTestRunListeners;
    }

    public void addTestRunListener(ITestRunListener newListener) {
        if (this.fTestRunListeners == null) {
            this.loadTestRunListeners();
        }
        Iterator iter = this.fTestRunListeners.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o != newListener) continue;
            return;
        }
        this.fTestRunListeners.add(newListener);
    }

    public void removeTestRunListener(ITestRunListener newListener) {
        if (this.fTestRunListeners != null) {
            this.fTestRunListeners.remove(newListener);
        }
    }
}

