/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationTab;
import org.eclipse.jdt.internal.junit.launcher.TestSelectionDialog;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class JUnitMainTab
extends JUnitLaunchConfigurationTab {
    private Label fProjLabel;
    private Text fProjText;
    private Button fProjButton;
    private Button fKeepRunning;
    private Text fTestText;
    private Button fSearchButton;
    private final Image fTestIcon = JUnitMainTab.createImage("obj16/test.gif");
    private Label fTestMethodLabel;
    private Text fContainerText;
    private IJavaElement fContainerElement;
    private final ILabelProvider fJavaElementLabelProvider = new JavaElementLabelProvider();
    private Button fContainerSearchButton;
    private Button fTestContainerRadioButton;
    private Button fTestRadioButton;
    private Label fTestLabel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        comp.setLayout((Layout)topLayout);
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.createSingleTestSection(comp);
        this.createTestContainerSelectionGroup(comp);
        label = new Label(comp, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.createKeepAliveGroup(comp);
        Dialog.applyDialogFont((Control)comp);
        this.validatePage();
    }

    protected void createSingleTestSection(Composite comp) {
        this.fTestRadioButton = new Button(comp, 16);
        this.fTestRadioButton.setText(JUnitMessages.getString("JUnitMainTab.label.oneTest"));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fTestRadioButton.setLayoutData((Object)gd);
        this.fTestRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JUnitMainTab.this.fTestRadioButton.getSelection()) {
                    JUnitMainTab.this.testModeChanged();
                }
            }
        });
        this.fProjLabel = new Label(comp, 0);
        this.fProjLabel.setText(JUnitMessages.getString("JUnitMainTab.label.project"));
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjText = new Text(comp, 2052);
        this.fProjText.setLayoutData((Object)new GridData(768));
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JUnitMainTab.this.validatePage();
                JUnitMainTab.this.updateLaunchConfigurationDialog();
                JUnitMainTab.this.fSearchButton.setEnabled(JUnitMainTab.this.fTestRadioButton.getSelection() && JUnitMainTab.this.fProjText.getText().length() > 0);
            }
        });
        this.fProjButton = new Button(comp, 8);
        this.fProjButton.setText(JUnitMessages.getString("JUnitMainTab.label.browse"));
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JUnitMainTab.this.handleProjectButtonSelected();
            }
        });
        this.setButtonGridData(this.fProjButton);
        this.fTestLabel = new Label(comp, 0);
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.fTestLabel.setLayoutData((Object)gd);
        this.fTestLabel.setText(JUnitMessages.getString("JUnitMainTab.label.test"));
        this.fTestText = new Text(comp, 2052);
        this.fTestText.setLayoutData((Object)new GridData(768));
        this.fTestText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JUnitMainTab.this.validatePage();
                JUnitMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = new Button(comp, 8);
        this.fSearchButton.setEnabled(this.fProjText.getText().length() > 0);
        this.fSearchButton.setText(JUnitMessages.getString("JUnitMainTab.label.search"));
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JUnitMainTab.this.handleSearchButtonSelected();
            }
        });
        this.setButtonGridData(this.fSearchButton);
        new Label(comp, 0);
        this.fTestMethodLabel = new Label(comp, 0);
        this.fTestMethodLabel.setText("");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fTestMethodLabel.setLayoutData((Object)gd);
    }

    protected void createTestContainerSelectionGroup(Composite comp) {
        this.fTestContainerRadioButton = new Button(comp, 16);
        this.fTestContainerRadioButton.setText(JUnitMessages.getString("JUnitMainTab.label.containerTest"));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fTestContainerRadioButton.setLayoutData((Object)gd);
        this.fTestContainerRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (JUnitMainTab.this.fTestContainerRadioButton.getSelection()) {
                    JUnitMainTab.this.testModeChanged();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fContainerText = new Text(comp, 2060);
        gd = new GridData(768);
        gd.horizontalIndent = 25;
        gd.horizontalSpan = 2;
        this.fContainerText.setLayoutData((Object)gd);
        this.fContainerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JUnitMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fContainerSearchButton = new Button(comp, 8);
        this.fContainerSearchButton.setText(JUnitMessages.getString("JUnitMainTab.label.search"));
        this.fContainerSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JUnitMainTab.this.handleContainerSearchButtonSelected();
            }
        });
        this.setButtonGridData(this.fContainerSearchButton);
    }

    private void handleContainerSearchButtonSelected() {
        IJavaElement javaElement = this.chooseContainer(this.fContainerElement);
        if (javaElement != null) {
            this.fContainerElement = javaElement;
            this.fContainerText.setText(this.getPresentationName(javaElement));
            this.validatePage();
            this.updateLaunchConfigurationDialog();
        }
    }

    public void createKeepAliveGroup(Composite comp) {
        this.fKeepRunning = new Button(comp, 32);
        this.fKeepRunning.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JUnitMainTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fKeepRunning.setText(JUnitMessages.getString("JUnitMainTab.label.keeprunning"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.fKeepRunning.setLayoutData((Object)gd);
    }

    protected static Image createImage(String path) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)JUnitPlugin.makeIconFileURL(path));
            return id.createImage();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        String containerHandle = "";
        try {
            containerHandle = config.getAttribute("org.eclipse.jdt.junit.CONTAINER", "");
        }
        catch (CoreException coreException) {}
        if (containerHandle.length() > 0) {
            this.updateTestContainerFromConfig(config);
        } else {
            this.updateTestTypeFromConfig(config);
        }
        this.updateKeepRunning(config);
    }

    private void updateKeepRunning(ILaunchConfiguration config) {
        boolean running = false;
        try {
            running = config.getAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
        }
        catch (CoreException coreException) {}
        this.fKeepRunning.setSelection(running);
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = "";
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException coreException) {}
        this.fProjText.setText(projectName);
    }

    protected void updateTestTypeFromConfig(ILaunchConfiguration config) {
        String testTypeName = "";
        String testMethodName = "";
        try {
            testTypeName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
            testMethodName = config.getAttribute("org.eclipse.jdt.junit.TESTNAME", "");
        }
        catch (CoreException coreException) {}
        this.fTestRadioButton.setSelection(true);
        this.setEnableSingleTestGroup(true);
        this.setEnableContainerTestGroup(false);
        this.fTestContainerRadioButton.setSelection(false);
        this.fTestText.setText(testTypeName);
        this.fContainerText.setText("");
        if (!"".equals(testMethodName)) {
            this.fTestMethodLabel.setText(String.valueOf(JUnitMessages.getString("JUnitMainTab.label.method")) + testMethodName);
        } else {
            this.fTestMethodLabel.setText("");
        }
    }

    protected void updateTestContainerFromConfig(ILaunchConfiguration config) {
        String containerHandle = "";
        try {
            containerHandle = config.getAttribute("org.eclipse.jdt.junit.CONTAINER", "");
            if (containerHandle.length() > 0) {
                this.fContainerElement = JavaCore.create((String)containerHandle);
            }
        }
        catch (CoreException coreException) {}
        this.fTestContainerRadioButton.setSelection(true);
        this.setEnableSingleTestGroup(false);
        this.setEnableContainerTestGroup(true);
        this.fTestRadioButton.setSelection(false);
        if (this.fContainerElement != null) {
            this.fContainerText.setText(this.getPresentationName(this.fContainerElement));
        }
        this.fTestText.setText("");
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText());
        if (this.fTestContainerRadioButton.getSelection() && this.fContainerElement != null) {
            config.setAttribute("org.eclipse.jdt.junit.CONTAINER", this.fContainerElement.getHandleIdentifier());
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fTestText.getText());
            config.setAttribute("org.eclipse.jdt.junit.CONTAINER", "");
        }
        config.setAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", this.fKeepRunning.getSelection());
    }

    public void dispose() {
        super.dispose();
        this.fTestIcon.dispose();
        this.fJavaElementLabelProvider.dispose();
    }

    public Image getImage() {
        return this.fTestIcon;
    }

    protected void handleSearchButtonSelected() {
        Shell shell = this.getShell();
        IJavaProject javaProject = this.getJavaProject();
        TestSelectionDialog dialog = new TestSelectionDialog(shell, (IRunnableContext)new ProgressMonitorDialog(shell), javaProject);
        dialog.setTitle(JUnitMessages.getString("JUnitMainTab.testdialog.title"));
        dialog.setMessage(JUnitMessages.getString("JUnitMainTab.testdialog.message"));
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IType type = (IType)results[0];
        if (type != null) {
            this.fTestText.setText(type.getFullyQualifiedName());
            javaProject = type.getJavaProject();
            this.fProjText.setText(javaProject.getElementName());
        }
    }

    protected void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    protected IJavaProject chooseJavaProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException e) {
            JUnitPlugin.log(e.getStatus());
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(JUnitMessages.getString("JUnitMainTab.projectdialog.title"));
        dialog.setMessage(JUnitMessages.getString("JUnitMainTab.projectdialog.message"));
        dialog.setElements(projects);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    protected IJavaProject getJavaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.getErrorMessage() == null;
    }

    private void testModeChanged() {
        boolean isSingleTestMode = this.fTestRadioButton.getSelection();
        this.setEnableSingleTestGroup(isSingleTestMode);
        this.setEnableContainerTestGroup(!isSingleTestMode);
        this.validatePage();
        this.updateLaunchConfigurationDialog();
    }

    private void validatePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fTestContainerRadioButton.getSelection()) {
            if (this.fContainerElement == null) {
                this.setErrorMessage(JUnitMessages.getString("JUnitMainTab.error.noContainer"));
            }
            return;
        }
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() == 0) {
            this.setErrorMessage(JUnitMessages.getString("JUnitMainTab.error.projectnotdefined"));
            return;
        }
        IProject project = this.getWorkspaceRoot().getProject(projectName);
        if (!project.exists()) {
            this.setErrorMessage(JUnitMessages.getString("JUnitMainTab.error.projectnotexists"));
            return;
        }
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                this.setErrorMessage(JUnitMessages.getString("JUnitMainTab.error.notJavaProject"));
                return;
            }
            IJavaProject jProject = this.getJavaProject();
            String className = this.fTestText.getText().trim();
            if (className.length() == 0) {
                this.setErrorMessage(JUnitMessages.getString("JUnitMainTab.error.testnotdefined"));
                return;
            }
            IType type = jProject.findType(className);
            if (type == null) {
                this.setErrorMessage(JUnitMessages.getString("JUnitMainTab.error.testnotexists"));
            } else if (!TestSearchEngine.isTestOrTestSuite(type)) {
                this.setErrorMessage(JUnitMessages.getString("JUnitMainTab.error.invalidTest"));
            }
        }
        catch (Exception exception) {}
    }

    private void setEnableContainerTestGroup(boolean enabled) {
        this.fContainerSearchButton.setEnabled(enabled);
        this.fContainerText.setEnabled(enabled);
    }

    private void setEnableSingleTestGroup(boolean enabled) {
        this.fProjLabel.setEnabled(enabled);
        this.fProjText.setEnabled(enabled);
        this.fProjButton.setEnabled(enabled);
        this.fTestLabel.setEnabled(enabled);
        this.fTestText.setEnabled(enabled);
        this.fSearchButton.setEnabled(enabled && this.fProjText.getText().length() > 0);
        this.fTestMethodLabel.setEnabled(enabled);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            config.setAttribute("org.eclipse.jdt.junit.CONTAINER", "");
        }
        this.initializeTestAttributes(javaElement, config);
    }

    private void initializeTestAttributes(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        if (javaElement != null && javaElement.getElementType() < 5) {
            this.initializeTestContainer(javaElement, config);
        } else {
            this.initializeTestType(javaElement, config);
        }
    }

    private void initializeTestContainer(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.jdt.junit.CONTAINER", javaElement.getHandleIdentifier());
        this.initializeName(config, javaElement.getElementName());
    }

    private void initializeName(ILaunchConfigurationWorkingCopy config, String name) {
        if (name == null) {
            name = "";
        }
        if (name.length() > 0) {
            int index = name.lastIndexOf(46);
            if (index > 0) {
                name = name.substring(index + 1);
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
        }
    }

    protected void initializeTestType(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = "";
        try {
            if (javaElement instanceof ICompilationUnit || javaElement instanceof ISourceReference || javaElement instanceof IClassFile) {
                IType[] types = TestSearchEngine.findTests((IRunnableContext)new BusyIndicatorRunnableContext(), new Object[]{javaElement});
                if (types == null || types.length < 1) {
                    return;
                }
                name = types[0].getFullyQualifiedName();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        if (name == null) {
            name = "";
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, name);
        this.initializeName(config, name);
    }

    public String getName() {
        return JUnitMessages.getString("JUnitMainTab.tab.label");
    }

    private IJavaElement chooseContainer(IJavaElement initElement) {
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.IPackageFragmentRoot;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.jdt.core.IJavaProject;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Lorg.eclipse.jdt.core.IPackageFragment;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                return true;
            }
        };
        Class[] classArray2 = new Class[4];
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("[Lorg.eclipse.jdt.core.IJavaModel;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz4;
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("[Lorg.eclipse.jdt.core.IPackageFragmentRoot;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz5;
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("[Lorg.eclipse.jdt.core.IJavaProject;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[2] = clazz6;
        Class<?> clazz7 = class$2;
        if (clazz7 == null) {
            try {
                clazz7 = class$2 = Class.forName("[Lorg.eclipse.jdt.core.IPackageFragment;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[3] = clazz7;
        acceptedClasses = classArray2;
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setTitle(JUnitMessages.getString("JUnitMainTab.folderdialog.title"));
        dialog.setMessage(JUnitMessages.getString("JUnitMainTab.folderdialog.message"));
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()));
        dialog.setInitialSelection((Object)initElement);
        dialog.setAllowMultiple(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            return (IJavaElement)element;
        }
        return null;
    }

    private String getPresentationName(IJavaElement element) {
        return this.fJavaElementLabelProvider.getText((Object)element);
    }
}

