/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.window;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.custom.CTabFolder2;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;

public class ColorSchemeService {
    static void setSchemeColors(Control control) {
        if (control instanceof Composite) {
            ColorSchemeService.setCompositeColors((Composite)control);
            return;
        }
        if (control instanceof List) {
            return;
        }
        if (control instanceof Tree) {
            return;
        }
        if (control instanceof StyledText) {
            return;
        }
        if (control instanceof Table) {
            return;
        }
        if (control instanceof CTabFolder2) {
            ColorSchemeService.setTabColors((CTabFolder2)control);
            return;
        }
        if (control instanceof Sash) {
            return;
        }
    }

    public static void setTabColors(CTabFolder2 control) {
        Display d = control.getDisplay();
        control.setBackground(JFaceColors.getTabFolderBackground(d));
        control.setForeground(JFaceColors.getTabFolderForeground(d));
        control.setSelectionBackground(JFaceColors.getTabFolderSelectionBackground(d));
        control.setSelectionForeground(JFaceColors.getTabFolderSelectionForeground(d));
    }

    static void setCompositeColors(Composite control) {
        Control[] children = control.getChildren();
        int i = 0;
        while (i < children.length) {
            ColorSchemeService.setSchemeColors(children[i]);
            ++i;
        }
    }

    public static void setCoolBarColors(Control control) {
        ColorSchemeService.setBasicColors(control);
    }

    private static void setBasicColors(Control control) {
        control.setBackground(JFaceColors.getSchemeBackground(control.getDisplay()));
        control.setForeground(JFaceColors.getSchemeForeground(control.getDisplay()));
    }

    public static void setPerspectiveToolBarColors(ToolBar control) {
        ColorSchemeService.setBasicColors((Control)control);
    }
}

