/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class JFaceResources {
    public static final String BANNER_FONT = "org.eclipse.jface.bannerfont";
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.jface.messages");
    private static ColorRegistry colorRegistry;
    public static final String DEFAULT_FONT = "org.eclipse.jface.defaultfont";
    public static final String DIALOG_FONT = "org.eclipse.jface.dialogfont";
    private static FontRegistry fontRegistry;
    public static final String HEADER_FONT = "org.eclipse.jface.headerfont";
    private static ImageRegistry imageRegistry;
    public static final String TEXT_FONT = "org.eclipse.jface.textfont";
    public static final String VIEWER_FONT = "org.eclipse.jface.viewerfont";
    public static final String WINDOW_FONT = "org.eclipse.jface.windowfont";

    static {
        fontRegistry = null;
        imageRegistry = null;
    }

    public static String format(String key, Object[] args) {
        return MessageFormat.format(JFaceResources.getString(key), args);
    }

    public static Font getBannerFont() {
        return JFaceResources.getFontRegistry().get(BANNER_FONT);
    }

    public static ResourceBundle getBundle() {
        return bundle;
    }

    public static ColorRegistry getColorRegistry() {
        if (colorRegistry == null) {
            colorRegistry = new ColorRegistry();
        }
        return colorRegistry;
    }

    public static Font getDefaultFont() {
        return JFaceResources.getFontRegistry().defaultFont();
    }

    public static Font getDialogFont() {
        return JFaceResources.getFontRegistry().get(DIALOG_FONT);
    }

    public static Font getFont(String symbolicName) {
        return JFaceResources.getFontRegistry().get(symbolicName);
    }

    public static FontRegistry getFontRegistry() {
        if (fontRegistry == null) {
            fontRegistry = new FontRegistry("org.eclipse.jface.resource.jfacefonts");
        }
        return fontRegistry;
    }

    public static Font getHeaderFont() {
        return JFaceResources.getFontRegistry().get(HEADER_FONT);
    }

    public static Image getImage(String key) {
        return JFaceResources.getImageRegistry().get(key);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public static String getString(String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String[] getStrings(String[] keys) {
        Assert.isNotNull(keys);
        int length = keys.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = JFaceResources.getString(keys[i]);
            ++i;
        }
        return result;
    }

    public static Font getTextFont() {
        return JFaceResources.getFontRegistry().get(TEXT_FONT);
    }

    public static Font getViewerFont() {
        return JFaceResources.getFontRegistry().get(VIEWER_FONT);
    }

    public static void setFontRegistry(FontRegistry registry) {
        Assert.isTrue(fontRegistry == null, "Font registry can only be set once.");
        fontRegistry = registry;
    }

    private JFaceResources() {
    }
}

