/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class JFaceColors {
    private static Hashtable colorTable = new Hashtable();
    private static ArrayList allocatedColors = new ArrayList();
    public static int STATUS_PERCENT = 100;
    public static String SCHEME_BACKGROUND = "SCHEME_BACKGROUND";
    public static String SCHEME_FOREGROUND = "SCHEME_FOREGROUND";
    public static String SCHEME_TAB_BACKGROUND = "SCHEME_TAB_BACKGROUND";
    public static String SCHEME_TAB_FOREGROUND = "SCHEME_TAB_FOREGROUND";
    public static String SCHEME_TAB_SELECTION_FOREGROUND = "SCHEME_TAB_SELECTION_FOREGROUND";
    public static String SCHEME_TAB_SELECTION_BACKGROUND = "SCHEME_TAB_SELECTION_BACKGROUND";
    private static Hashtable JFaceDefaultColorMap;
    private static Hashtable UserColorMap;

    private static void initColors(Display d) {
        int origSize = 6;
        JFaceDefaultColorMap = new Hashtable(origSize);
        JFaceDefaultColorMap.put(SCHEME_BACKGROUND, d.getSystemColor(22));
        JFaceDefaultColorMap.put(SCHEME_FOREGROUND, d.getSystemColor(21));
        JFaceDefaultColorMap.put(SCHEME_TAB_BACKGROUND, d.getSystemColor(22));
        JFaceDefaultColorMap.put(SCHEME_TAB_FOREGROUND, d.getSystemColor(21));
        JFaceDefaultColorMap.put(SCHEME_TAB_SELECTION_BACKGROUND, d.getSystemColor(35));
        JFaceDefaultColorMap.put(SCHEME_TAB_SELECTION_FOREGROUND, d.getSystemColor(21));
        UserColorMap = new Hashtable();
        if (!JFaceColors.getUseDefaultTheme()) {
            Color temp = JFaceColors.getUserColor(d, SCHEME_TAB_BACKGROUND);
            if (temp != null) {
                UserColorMap.put(SCHEME_TAB_BACKGROUND, temp);
            }
            if ((temp = JFaceColors.getUserColor(d, SCHEME_TAB_FOREGROUND)) != null) {
                UserColorMap.put(SCHEME_TAB_FOREGROUND, temp);
            }
            if ((temp = JFaceColors.getUserColor(d, SCHEME_TAB_SELECTION_BACKGROUND)) != null) {
                UserColorMap.put(SCHEME_TAB_SELECTION_BACKGROUND, temp);
            }
            if ((temp = JFaceColors.getUserColor(d, SCHEME_TAB_SELECTION_FOREGROUND)) != null) {
                UserColorMap.put(SCHEME_TAB_SELECTION_FOREGROUND, temp);
            }
        }
    }

    private static Color getUserColor(Display display, String preferenceName) {
        IPreferenceStore store = JFacePreferences.getPreferenceStore();
        if (store == null) {
            return null;
        }
        RGB rgb = PreferenceConverter.getColor(store, preferenceName);
        if (rgb != PreferenceConverter.getDefaultColor(store, preferenceName)) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public static Color getBannerBackground(Display display) {
        return display.getSystemColor(25);
    }

    public static Color getBannerForeground(Display display) {
        return display.getSystemColor(24);
    }

    public static Color getErrorBackground(Display display) {
        return display.getSystemColor(22);
    }

    public static Color getErrorBorder(Display display) {
        return display.getSystemColor(17);
    }

    public static Color getErrorText(Display display) {
        return JFaceColors.getColorSetting(display, "ERROR_COLOR");
    }

    public static Color getHyperlinkText(Display display) {
        return JFaceColors.getColorSetting(display, "HYPERLINK_COLOR");
    }

    public static Color getActiveHyperlinkText(Display display) {
        return JFaceColors.getColorSetting(display, "ACTIVE_HYPERLINK_COLOR");
    }

    private static Hashtable getColorMap() {
        if (JFaceColors.getUseDefaultTheme()) {
            return JFaceDefaultColorMap;
        }
        return UserColorMap;
    }

    public static Color getSchemeBackground(Display display) {
        return JFaceColors.getColor(display, SCHEME_BACKGROUND);
    }

    private static Color getColor(Display display, String colorKey) {
        Color color;
        if (JFaceDefaultColorMap == null) {
            JFaceColors.initColors(display);
        }
        if ((color = (Color)JFaceColors.getColorMap().get(colorKey)) != null) {
            return color;
        }
        return JFaceColors.getDefaultColor(colorKey);
    }

    public static Color getDefaultColor(String colorKey) {
        return (Color)JFaceDefaultColorMap.get(colorKey);
    }

    public static Color getTabFolderBackground(Display display) {
        return JFaceColors.getColor(display, SCHEME_TAB_BACKGROUND);
    }

    public static Color getTabFolderSelectionBackground(Display display) {
        return JFaceColors.getColor(display, SCHEME_TAB_SELECTION_BACKGROUND);
    }

    public static Color getTabFolderSelectionForeground(Display display) {
        return JFaceColors.getColor(display, SCHEME_TAB_SELECTION_FOREGROUND);
    }

    public static Color getTabFolderForeground(Display display) {
        return JFaceColors.getColor(display, SCHEME_TAB_FOREGROUND);
    }

    public static Color getSchemeForeground(Display display) {
        return JFaceColors.getColorSetting(display, JFacePreferences.SCHEME_FOREGROUND_COLOR);
    }

    public static void clearColor(String colorName) {
        colorTable.remove(colorName);
    }

    private static Color getColorSetting(Display display, String preferenceName) {
        if (colorTable.containsKey(preferenceName)) {
            return (Color)colorTable.get(preferenceName);
        }
        IPreferenceStore store = JFacePreferences.getPreferenceStore();
        if (store == null) {
            Color color = JFaceColors.getDefaultColor(display, preferenceName);
            colorTable.put(preferenceName, color);
            return color;
        }
        Color color = new Color((Device)display, PreferenceConverter.getColor(store, preferenceName));
        allocatedColors.add(color);
        colorTable.put(preferenceName, color);
        return color;
    }

    public static boolean getUseDefaultTheme() {
        IPreferenceStore store = JFacePreferences.getPreferenceStore();
        if (store == null) {
            return true;
        }
        return store.getBoolean("USE_DEFAULT_THEME");
    }

    private static Color getDefaultColor(Display display, String preferenceName) {
        if (preferenceName.equals("ERROR_COLOR")) {
            return display.getSystemColor(3);
        }
        if (preferenceName.equals("HYPERLINK_COLOR")) {
            Color color = new Color((Device)display, 0, 0, 153);
            allocatedColors.add(color);
            return color;
        }
        if (preferenceName.equals("ACTIVE_HYPERLINK_COLOR")) {
            return display.getSystemColor(9);
        }
        return display.getSystemColor(2);
    }

    public static void disposeColors() {
        Iterator colors = allocatedColors.iterator();
        while (colors.hasNext()) {
            ((Color)colors.next()).dispose();
        }
    }

    public static void setColors(Control control, Color foreground, Color background) {
        if (foreground != null) {
            control.setForeground(foreground);
        }
        if (background != null) {
            control.setBackground(background);
        }
    }
}

