/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.action.SubContributionManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;

public class SubMenuManager
extends SubContributionManager
implements IMenuManager {
    private Map mapMenuToWrapper;

    public SubMenuManager(IMenuManager mgr) {
        super(mgr);
    }

    public void dispose() {
    }

    public void addMenuListener(IMenuListener listener) {
        this.getParentMenuManager().addMenuListener(listener);
    }

    public void fill(Composite parent) {
        if (this.isVisible()) {
            this.getParentMenuManager().fill(parent);
        }
    }

    public void fill(Menu parent, int index) {
        if (this.isVisible()) {
            this.getParentMenuManager().fill(parent, index);
        }
    }

    public void fill(ToolBar parent, int index) {
        if (this.isVisible()) {
            this.getParentMenuManager().fill(parent, index);
        }
    }

    public IMenuManager findMenuUsingPath(String path) {
        IContributionItem item = this.findUsingPath(path);
        if (item instanceof IMenuManager) {
            return (IMenuManager)item;
        }
        return null;
    }

    public IContributionItem findUsingPath(String path) {
        String id = path;
        String rest = null;
        int separator = path.indexOf(47);
        if (separator != -1) {
            id = path.substring(0, separator);
            rest = path.substring(separator + 1);
        }
        IContributionItem item = this.find(id);
        if (rest != null && item instanceof IMenuManager) {
            IMenuManager menu = (IMenuManager)item;
            item = menu.findUsingPath(rest);
        }
        return item;
    }

    public IContributionItem find(String id) {
        IContributionItem item = this.getParentMenuManager().find(id);
        if (item instanceof SubContributionItem) {
            item = this.unwrap(item);
        }
        if (item instanceof IMenuManager) {
            IMenuManager menu = (IMenuManager)item;
            item = this.getWrapper(menu);
        }
        return item;
    }

    protected final IMenuManager getParentMenuManager() {
        return (IMenuManager)this.getParent();
    }

    public String getId() {
        return this.getParentMenuManager().getId();
    }

    public boolean getRemoveAllWhenShown() {
        return false;
    }

    protected IMenuManager getWrapper(IMenuManager mgr) {
        SubMenuManager wrapper;
        if (this.mapMenuToWrapper == null) {
            this.mapMenuToWrapper = new HashMap(4);
        }
        if ((wrapper = (SubMenuManager)this.mapMenuToWrapper.get(mgr)) == null) {
            wrapper = this.wrapMenu(mgr);
            this.mapMenuToWrapper.put(mgr, wrapper);
        }
        return wrapper;
    }

    public boolean isDynamic() {
        return this.getParentMenuManager().isDynamic();
    }

    public boolean isEnabled() {
        return this.isVisible() && this.getParentMenuManager().isEnabled();
    }

    public boolean isGroupMarker() {
        return this.getParentMenuManager().isGroupMarker();
    }

    public boolean isSeparator() {
        return this.getParentMenuManager().isSeparator();
    }

    public void removeAll() {
        super.removeAll();
        if (this.mapMenuToWrapper != null) {
            Iterator iter = this.mapMenuToWrapper.values().iterator();
            while (iter.hasNext()) {
                SubMenuManager wrapper = (SubMenuManager)iter.next();
                wrapper.removeAll();
            }
            this.mapMenuToWrapper.clear();
            this.mapMenuToWrapper = null;
        }
    }

    public void removeMenuListener(IMenuListener listener) {
        this.getParentMenuManager().removeMenuListener(listener);
    }

    public void setParent(IContributionManager parent) {
    }

    public void setRemoveAllWhenShown(boolean removeAll) {
        Assert.isTrue(false, "Should not be called on submenu manager");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.mapMenuToWrapper != null) {
            Iterator iter = this.mapMenuToWrapper.values().iterator();
            while (iter.hasNext()) {
                SubMenuManager wrapper = (SubMenuManager)iter.next();
                wrapper.setVisible(visible);
            }
        }
    }

    public void update() {
        this.getParentMenuManager().update();
    }

    public void update(boolean force) {
        this.getParentMenuManager().update(force);
    }

    public void updateAll(boolean force) {
        this.getParentMenuManager().updateAll(force);
    }

    public void update(String id) {
        this.getParentMenuManager().update(id);
    }

    protected SubMenuManager wrapMenu(IMenuManager menu) {
        SubMenuManager mgr = new SubMenuManager(menu);
        mgr.setVisible(this.isVisible());
        return mgr;
    }

    public void fill(CoolBar parent, int index) {
    }

    public void saveWidgetState() {
    }
}

