/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views.actions;

import java.util.Iterator;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchShortcut;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.ant.internal.ui.views.actions.AntViewActionMessages;
import org.eclipse.ant.internal.ui.views.elements.AntNode;
import org.eclipse.ant.internal.ui.views.elements.ProjectNode;
import org.eclipse.ant.internal.ui.views.elements.TargetNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IUpdate;

public class RunTargetAction
extends Action
implements IUpdate {
    private AntView view;

    public RunTargetAction(AntView view) {
        super(AntViewActionMessages.getString("RunTargetAction.Run_1"), AntUIImages.getImageDescriptor("org.eclipse.ant.ui.run"));
        this.setToolTipText(AntViewActionMessages.getString("RunTargetAction.Run_Default"));
        this.view = view;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ant.ui.run_target_action_context");
    }

    public void run() {
        UIJob job = new UIJob(AntViewActionMessages.getString("RunTargetAction.2")){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                TargetNode target = RunTargetAction.this.getSelectedTarget();
                if (target == null) {
                    return new Status(4, AntUIPlugin.getUniqueIdentifier(), 4, AntViewActionMessages.getString("RunTargetAction.3"), null);
                }
                RunTargetAction.this.runTarget(target);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void runTarget(TargetNode target) {
        IFile file = AntUtil.getFile(target.getProject().getBuildFileName());
        if (file == null) {
            AntUIPlugin.getStandardDisplay().beep();
            return;
        }
        AntLaunchShortcut shortcut = new AntLaunchShortcut();
        shortcut.launch(file, "run", target.getName());
    }

    public void update() {
        AntNode selection = this.getSelectedElement();
        boolean enabled = false;
        if (selection instanceof TargetNode) {
            if (!((TargetNode)selection).isErrorNode()) {
                enabled = true;
            }
        } else if (selection instanceof ProjectNode && !((ProjectNode)selection).isErrorNode()) {
            enabled = true;
        }
        this.setEnabled(enabled);
    }

    private AntNode getSelectedElement() {
        IStructuredSelection selection = (IStructuredSelection)this.view.getProjectViewer().getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        Iterator iter = selection.iterator();
        Object data = iter.next();
        if (iter.hasNext() || !(data instanceof TargetNode) && !(data instanceof ProjectNode)) {
            return null;
        }
        return (AntNode)data;
    }

    private TargetNode getSelectedTarget() {
        AntNode selectedNode = this.getSelectedElement();
        if (selectedNode instanceof TargetNode) {
            return (TargetNode)selectedNode;
        }
        if (selectedNode instanceof ProjectNode) {
            return ((ProjectNode)selectedNode).getDefaultTarget();
        }
        return null;
    }
}

