/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.ant.internal.ui.views.actions.AntViewActionMessages;
import org.eclipse.ant.internal.ui.views.elements.ProjectNode;
import org.eclipse.ant.internal.ui.views.elements.TargetNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.IUpdate;

public class RefreshBuildFilesAction
extends Action
implements IUpdate {
    private AntView view;

    public RefreshBuildFilesAction(AntView view) {
        super(AntViewActionMessages.getString("RefreshBuildFilesAction.Refresh_Buildfiles_1"), AntUIImages.getImageDescriptor("org.eclipse.ant.ui.IMG_ACTION_REFRESH"));
        this.setToolTipText(AntViewActionMessages.getString("RefreshBuildFilesAction.Refresh_Buildfiles_1"));
        this.view = view;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ant.ui.refresh_buildfile_action_context");
    }

    public void run() {
        Iterator iter;
        final Set projects = this.getSelectedProjects();
        if (projects.isEmpty()) {
            ProjectNode[] allProjects = this.view.getProjects();
            int i = 0;
            while (i < allProjects.length) {
                projects.add(allProjects[i]);
                ++i;
            }
        }
        if (!(iter = projects.iterator()).hasNext()) {
            return;
        }
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        try {
            progressDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(AntViewActionMessages.getString("RefreshBuildFilesAction.Refreshing_buildfiles_3"), projects.size());
                    while (iter.hasNext()) {
                        ProjectNode project = (ProjectNode)iter.next();
                        monitor.subTask(MessageFormat.format(AntViewActionMessages.getString("RefreshBuildFilesAction.Refreshing_{0}_4"), project.getBuildFileName()));
                        project.parseBuildFile();
                        monitor.worked(1);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        this.view.getProjectViewer().refresh();
    }

    private Set getSelectedProjects() {
        IStructuredSelection selection = (IStructuredSelection)this.view.getProjectViewer().getSelection();
        HashSet set = new HashSet();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object data = iter.next();
            if (data instanceof ProjectNode) {
                set.add(data);
                continue;
            }
            if (!(data instanceof TargetNode)) continue;
            set.add(((TargetNode)data).getProject());
        }
        return set;
    }

    public void update() {
        this.setEnabled(this.view.getProjects().length > 0);
    }
}

