/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views;

import java.util.ArrayList;
import org.eclipse.ant.internal.ui.views.elements.AntNode;
import org.eclipse.ant.internal.ui.views.elements.ProjectNode;
import org.eclipse.ant.internal.ui.views.elements.RootNode;
import org.eclipse.ant.internal.ui.views.elements.TargetNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class AntProjectContentProvider
implements ITreeContentProvider {
    private RootNode rootNode;
    private boolean fIsFilteringInternalTargets = false;

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof RootNode) {
            this.rootNode = (RootNode)newInput;
        }
    }

    public void addProject(ProjectNode project) {
        ProjectNode[] projects = this.getRootNode().getProjects();
        int i = 0;
        while (i < projects.length) {
            ProjectNode node = projects[i];
            if (node.getBuildFileName().equals(project.getBuildFileName())) {
                return;
            }
            ++i;
        }
        this.getRootNode().addProject(project);
    }

    public RootNode getRootNode() {
        return this.rootNode;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof RootNode) {
            return ((RootNode)element).getProjects();
        }
        if (element instanceof ProjectNode) {
            if (!this.fIsFilteringInternalTargets) {
                return ((ProjectNode)element).getTargets();
            }
            TargetNode[] targets = ((ProjectNode)element).getTargets();
            ArrayList<TargetNode> filteredTargets = new ArrayList<TargetNode>();
            int i = 0;
            while (i < targets.length) {
                TargetNode node = targets[i];
                if (!this.isInternal(node)) {
                    filteredTargets.add(node);
                }
                ++i;
            }
            return filteredTargets.toArray();
        }
        return null;
    }

    private boolean isInternal(TargetNode target) {
        return target != target.getProject().getDefaultTarget() && target.getDescription() == null;
    }

    public Object getParent(Object element) {
        if (element instanceof AntNode) {
            return ((AntNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return !(element instanceof TargetNode);
    }

    public boolean isFilterInternalTargets() {
        return this.fIsFilteringInternalTargets;
    }

    public void setFilterInternalTargets(boolean filter) {
        this.fIsFilteringInternalTargets = filter;
    }
}

