/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.ColorEditor;
import org.eclipse.ant.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.ant.internal.ui.preferences.StatusInfo;
import org.eclipse.ant.internal.ui.preferences.TabFolderLayout;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class AntEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final String[][] fAppearanceColorListModel;
    private String[][] fAnnotationColorListModel;
    private final String[][] fContentAssistColorListModel;
    private OverlayPreferenceStore fOverlayStore;
    private Map fCheckBoxes;
    private SelectionListener fCheckBoxListener;
    private Map fTextFields;
    private ModifyListener fTextFieldListener;
    private Map fNumberFields;
    private ModifyListener fNumberFieldListener;
    private List fAppearanceColorList;
    private List fAnnotationList;
    private List fContentAssistColorList;
    private ColorEditor fAppearanceColorEditor;
    private ColorEditor fAnnotationForegroundColorEditor;
    private ColorEditor fContentAssistColorEditor;
    private Button fShowInTextCheckBox;
    private Button fShowInOverviewRulerCheckBox;
    private Control fAutoInsertDelayText;
    private Control fAutoInsertTriggerText;
    private Label fAutoInsertDelayLabel;
    private Label fAutoInsertTriggerLabel;

    public AntEditorPreferencePage() {
        String[][] stringArrayArray = new String[8][];
        stringArrayArray[0] = new String[]{AntPreferencesMessages.getString("AntEditorPreferencePage.lineNumberForegroundColor"), "lineNumberColor"};
        stringArrayArray[1] = new String[]{AntPreferencesMessages.getString("AntEditorPreferencePage.currentLineHighlighColor"), "currentLineColor"};
        stringArrayArray[2] = new String[]{AntPreferencesMessages.getString("AntEditorPreferencePage.printMarginColor"), "printMarginColor"};
        String[] stringArray = new String[3];
        stringArray[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_text_1");
        stringArray[1] = "antEditor.color.default";
        stringArrayArray[3] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_processing_instuctions_2");
        stringArray2[1] = "antEditor.color.instr";
        stringArrayArray[4] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_constant_strings_3");
        stringArray3[1] = "antEditor.color.string";
        stringArrayArray[5] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_tags_4");
        stringArray4[1] = "antEditor.color.tag";
        stringArrayArray[6] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = AntPreferencesMessages.getString("AntEditorPreferencePage.Ant_editor_comments_5");
        stringArray5[1] = "antEditor.color.xml_comment";
        stringArrayArray[7] = stringArray5;
        this.fAppearanceColorListModel = stringArrayArray;
        this.fContentAssistColorListModel = new String[][]{{AntPreferencesMessages.getString("AntEditorPreferencePage.backgroundForCompletionProposals"), "content_assist_proposals_background"}, {AntPreferencesMessages.getString("AntEditorPreferencePage.foregroundForCompletionProposals"), "content_assist_proposals_foreground"}};
        this.fCheckBoxes = new HashMap();
        this.fCheckBoxListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                AntEditorPreferencePage.this.fOverlayStore.setValue((String)AntEditorPreferencePage.this.fCheckBoxes.get(button), button.getSelection());
            }
        };
        this.fTextFields = new HashMap();
        this.fTextFieldListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                AntEditorPreferencePage.this.fOverlayStore.setValue((String)AntEditorPreferencePage.this.fTextFields.get(text), text.getText());
            }
        };
        this.fNumberFields = new HashMap();
        this.fNumberFieldListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AntEditorPreferencePage.this.numberFieldChanged((Text)e.widget);
            }
        };
        this.setDescription(AntPreferencesMessages.getString("AntEditorPreferencePage.description"));
        this.setPreferenceStore(AntUIPlugin.getDefault().getPreferenceStore());
        MarkerAnnotationPreferences preferences = new MarkerAnnotationPreferences();
        this.fOverlayStore = this.createOverlayStore(preferences);
        this.fAnnotationColorListModel = this.createAnnotationTypeListModel(preferences);
    }

    private OverlayPreferenceStore createOverlayStore(MarkerAnnotationPreferences preferences) {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getColorPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getTextPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getOverviewRulerPreferenceKey()));
        }
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "currentLineColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "printMarginColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "overviewRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "lineNumberColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "lineNumberRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoactivation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "content_assist_autoactivation_delay"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoinsert"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_autoactivation_triggers_java"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "antEditor.color.default"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "antEditor.color.instr"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "antEditor.color.string"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "antEditor.color.tag"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "antEditor.color.xml_comment"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    private String[][] createAnnotationTypeListModel(MarkerAnnotationPreferences preferences) {
        ArrayList<String[]> listModelItems = new ArrayList<String[]>();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            listModelItems.add(new String[]{info.getPreferenceLabel(), info.getColorPreferenceKey(), info.getTextPreferenceKey(), info.getOverviewRulerPreferenceKey()});
        }
        String[][] items = new String[listModelItems.size()][];
        listModelItems.toArray((T[])items);
        return items;
    }

    public void init(IWorkbench workbench) {
    }

    private Label getLabelControl(Control[] labelledTextField) {
        return (Label)labelledTextField[0];
    }

    private Text getTextControl(Control[] labelledTextField) {
        return (Text)labelledTextField[1];
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
    }

    private void handleAnnotationListSelection() {
        int i = this.fAnnotationList.getSelectionIndex();
        String key = this.fAnnotationColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAnnotationForegroundColorEditor.setColorValue(rgb);
        key = this.fAnnotationColorListModel[i][2];
        this.fShowInTextCheckBox.setSelection(this.fOverlayStore.getBoolean(key));
        key = this.fAnnotationColorListModel[i][3];
        this.fShowInOverviewRulerCheckBox.setSelection(this.fOverlayStore.getBoolean(key));
    }

    private Control createAppearancePage(Composite parent) {
        Font font = parent.getFont();
        Composite appearanceComposite = new Composite(parent, 0);
        appearanceComposite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        String labelText = AntPreferencesMessages.getString("AntEditorPreferencePage.printMarginColumn");
        String[] errorMessages = new String[]{AntPreferencesMessages.getString("AntEditorPreferencePage.empty_input_print_margin"), AntPreferencesMessages.getString("AntEditorPreferencePage.invalid_input_print_margin")};
        this.addTextField(appearanceComposite, labelText, "printMarginColumn", 3, 0, errorMessages);
        labelText = AntPreferencesMessages.getString("AntEditorPreferencePage.showOverviewRuler");
        this.addCheckBox(appearanceComposite, labelText, "overviewRuler", 0);
        labelText = AntPreferencesMessages.getString("AntEditorPreferencePage.showLineNumbers");
        this.addCheckBox(appearanceComposite, labelText, "lineNumberRuler", 0);
        labelText = AntPreferencesMessages.getString("AntEditorPreferencePage.highlightCurrentLine");
        this.addCheckBox(appearanceComposite, labelText, "currentLine", 0);
        labelText = AntPreferencesMessages.getString("AntEditorPreferencePage.showPrintMargin");
        this.addCheckBox(appearanceComposite, labelText, "printMargin", 0);
        Label label = new Label(appearanceComposite, 16384);
        label.setFont(font);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        label.setLayoutData((Object)gd);
        label = new Label(appearanceComposite, 16384);
        label.setFont(font);
        label.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.appearanceOptions"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        editorComposite.setFont(font);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new List(editorComposite, 2564);
        this.fAppearanceColorList.setFont(font);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        stylesComposite.setFont(font);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setFont(font);
        label.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        foregroundColorButton.setFont(font);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AntEditorPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AntEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = AntEditorPreferencePage.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)AntEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)AntEditorPreferencePage.this.fAppearanceColorEditor.getColorValue());
            }
        });
        return appearanceComposite;
    }

    private Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, String[] errorMessages) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        labelControl.setFont(composite.getFont());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        textControl.setFont(composite.getFont());
        this.fTextFields.put(textControl, key);
        if (errorMessages != null) {
            this.fNumberFields.put(textControl, errorMessages);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return new Control[]{labelControl, textControl};
    }

    private Control createContentAssistPage(Composite parent) {
        Font font = parent.getFont();
        Composite contentAssistComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        contentAssistComposite.setLayout((Layout)layout);
        contentAssistComposite.setFont(font);
        String text = AntPreferencesMessages.getString("AntEditorPreferencePage.Insert");
        this.addCheckBox(contentAssistComposite, text, "content_assist_autoinsert", 0);
        text = AntPreferencesMessages.getString("AntEditorPreferencePage.&Enable_auto_activation_2");
        Button autoactivation = this.addCheckBox(contentAssistComposite, text, "content_assist_autoactivation", 0);
        autoactivation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntEditorPreferencePage.this.updateAutoactivationControls();
            }
        });
        text = AntPreferencesMessages.getString("AntEditorPreferencePage.Auto_activation_&delay__3");
        String[] errorMessages = new String[]{AntPreferencesMessages.getString("AntEditorPreferencePage.empty_input_auto_activation"), AntPreferencesMessages.getString("AntEditorPreferencePage.invalid_input_auto_activation")};
        Control[] labelledTextField = this.addLabelledTextField(contentAssistComposite, text, "content_assist_autoactivation_delay", 4, 0, errorMessages);
        this.fAutoInsertDelayLabel = this.getLabelControl(labelledTextField);
        this.fAutoInsertDelayText = this.getTextControl(labelledTextField);
        text = AntPreferencesMessages.getString("AntEditorPreferencePage.Auto_activation_tri&ggers__4");
        labelledTextField = this.addLabelledTextField(contentAssistComposite, text, "content_assist_autoactivation_triggers_java", 4, 0, null);
        this.fAutoInsertTriggerLabel = this.getLabelControl(labelledTextField);
        this.fAutoInsertTriggerText = this.getTextControl(labelledTextField);
        Label label = new Label(contentAssistComposite, 16384);
        label.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.Code_assist_colo&r_options__5"));
        label.setFont(font);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(contentAssistComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        editorComposite.setFont(font);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fContentAssistColorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fContentAssistColorList.setLayoutData((Object)gd);
        this.fContentAssistColorList.setFont(font);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        stylesComposite.setFont(font);
        label = new Label(stylesComposite, 16384);
        label.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.Col&or__6"));
        label.setFont(font);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fContentAssistColorEditor = new ColorEditor(stylesComposite);
        Button colorButton = this.fContentAssistColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        colorButton.setLayoutData((Object)gd);
        this.fContentAssistColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AntEditorPreferencePage.this.handleContentAssistColorListSelection();
            }
        });
        colorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AntEditorPreferencePage.this.fContentAssistColorList.getSelectionIndex();
                String key = AntEditorPreferencePage.this.fContentAssistColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)AntEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)AntEditorPreferencePage.this.fContentAssistColorEditor.getColorValue());
            }
        });
        return contentAssistComposite;
    }

    private void handleContentAssistColorListSelection() {
        int i = this.fContentAssistColorList.getSelectionIndex();
        String key = this.fContentAssistColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fContentAssistColorEditor.setColorValue(rgb);
    }

    private void updateAutoactivationControls() {
        boolean autoactivation = this.fOverlayStore.getBoolean("content_assist_autoactivation");
        this.fAutoInsertDelayText.setEnabled(autoactivation);
        this.fAutoInsertDelayLabel.setEnabled(autoactivation);
        this.fAutoInsertTriggerText.setEnabled(autoactivation);
        this.fAutoInsertTriggerLabel.setEnabled(autoactivation);
    }

    private Control createAnnotationsPage(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 16384);
        label.setFont(font);
        label.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.annotationPresentationOptions"));
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(composite, 0);
        editorComposite.setFont(font);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAnnotationList = new List(editorComposite, 2564);
        this.fAnnotationList.setFont(font);
        gd = new GridData(770);
        int heightHint = this.fAnnotationColorListModel.length;
        heightHint = Math.min(15, heightHint);
        gd.heightHint = this.convertHeightInCharsToPixels(heightHint);
        this.fAnnotationList.setLayoutData((Object)gd);
        Composite optionsComposite = new Composite(editorComposite, 0);
        optionsComposite.setFont(font);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        optionsComposite.setLayout((Layout)layout);
        optionsComposite.setLayoutData((Object)new GridData(1808));
        this.fShowInTextCheckBox = new Button(optionsComposite, 32);
        this.fShowInTextCheckBox.setFont(font);
        this.fShowInTextCheckBox.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.annotations.showInText"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fShowInTextCheckBox.setLayoutData((Object)gd);
        this.fShowInOverviewRulerCheckBox = new Button(optionsComposite, 32);
        this.fShowInOverviewRulerCheckBox.setFont(font);
        this.fShowInOverviewRulerCheckBox.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.annotations.showInOverviewRuler"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fShowInOverviewRulerCheckBox.setLayoutData((Object)gd);
        label = new Label(optionsComposite, 16384);
        label.setFont(font);
        label.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.annotations.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAnnotationForegroundColorEditor = new ColorEditor(optionsComposite);
        Button foregroundColorButton = this.fAnnotationForegroundColorEditor.getButton();
        foregroundColorButton.setFont(font);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAnnotationList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AntEditorPreferencePage.this.handleAnnotationListSelection();
            }
        });
        this.fShowInTextCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AntEditorPreferencePage.this.fAnnotationList.getSelectionIndex();
                String key = AntEditorPreferencePage.this.fAnnotationColorListModel[i][2];
                AntEditorPreferencePage.this.fOverlayStore.setValue(key, AntEditorPreferencePage.this.fShowInTextCheckBox.getSelection());
            }
        });
        this.fShowInOverviewRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AntEditorPreferencePage.this.fAnnotationList.getSelectionIndex();
                String key = AntEditorPreferencePage.this.fAnnotationColorListModel[i][3];
                AntEditorPreferencePage.this.fOverlayStore.setValue(key, AntEditorPreferencePage.this.fShowInOverviewRulerCheckBox.getSelection());
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AntEditorPreferencePage.this.fAnnotationList.getSelectionIndex();
                String key = AntEditorPreferencePage.this.fAnnotationColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)AntEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)AntEditorPreferencePage.this.fAnnotationForegroundColorEditor.getColorValue());
            }
        });
        return composite;
    }

    protected Control createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ant.ui.ant_editor_preference_page_context");
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Font font = parent.getFont();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        folder.setFont(font);
        TabItem item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.general"));
        item.setControl(this.createAppearancePage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.codeAssistTab.title"));
        item.setControl(this.createContentAssistPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntEditorPreferencePage.annotationsTab.title"));
        item.setControl(this.createAnnotationsPage((Composite)folder));
        this.initialize();
        return folder;
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
            ++i;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AntEditorPreferencePage.this.fAppearanceColorList != null && !AntEditorPreferencePage.this.fAppearanceColorList.isDisposed()) {
                    AntEditorPreferencePage.this.fAppearanceColorList.select(0);
                    AntEditorPreferencePage.this.handleAppearanceColorListSelection();
                }
            }
        });
        i = 0;
        while (i < this.fAnnotationColorListModel.length) {
            this.fAnnotationList.add(this.fAnnotationColorListModel[i][0]);
            ++i;
        }
        this.fAnnotationList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AntEditorPreferencePage.this.fAnnotationList != null && !AntEditorPreferencePage.this.fAnnotationList.isDisposed()) {
                    AntEditorPreferencePage.this.fAnnotationList.select(0);
                    AntEditorPreferencePage.this.handleAnnotationListSelection();
                }
            }
        });
        i = 0;
        while (i < this.fContentAssistColorListModel.length) {
            this.fContentAssistColorList.add(this.fContentAssistColorListModel[i][0]);
            ++i;
        }
        this.fContentAssistColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AntEditorPreferencePage.this.fContentAssistColorList != null && !AntEditorPreferencePage.this.fContentAssistColorList.isDisposed()) {
                    AntEditorPreferencePage.this.fContentAssistColorList.select(0);
                    AntEditorPreferencePage.this.handleContentAssistColorListSelection();
                }
            }
        });
    }

    private void initializeFields() {
        String key;
        Iterator e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        e = this.fTextFields.keySet().iterator();
        while (e.hasNext()) {
            Text t = (Text)e.next();
            key = (String)this.fTextFields.get(t);
            t.setText(this.fOverlayStore.getString(key));
        }
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        AntUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleAppearanceColorListSelection();
        this.handleAnnotationListSelection();
        this.handleContentAssistColorListSelection();
        super.performDefaults();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    private Button addCheckBox(Composite parent, String labelText, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(labelText);
        checkBox.setFont(parent.getFont());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private Control addTextField(Composite composite, String labelText, String key, int textLimit, int indentation, String[] errorMessages) {
        Font font = composite.getFont();
        Label label = new Label(composite, 0);
        label.setText(labelText);
        label.setFont(font);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        label.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        textControl.setFont(font);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (errorMessages != null) {
            this.fNumberFields.put(textControl, errorMessages);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return textControl;
    }

    private void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number, (String[])this.fNumberFields.get(textControl));
        if (!status.matches(4)) {
            this.fOverlayStore.setValue((String)this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number, String[] errorMessages) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(errorMessages[0]);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(MessageFormat.format(errorMessages[1], number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(MessageFormat.format(errorMessages[1], number));
            }
        }
        return status;
    }

    private void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            Set keys = this.fNumberFields.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Text text = (Text)iter.next();
                IStatus s = this.validatePositiveNumber(text.getText(), (String[])this.fNumberFields.get(text));
                IStatus iStatus = status = s.getSeverity() > status.getSeverity() ? s : status;
            }
        }
        this.setValid(!status.matches(4));
        this.applyToStatusLine((DialogPage)this, status);
    }

    private void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }
}

