/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.AntClasspathBlock;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.AntRuntimePreferencePage;
import org.eclipse.ant.internal.ui.preferences.ClasspathModel;
import org.eclipse.ant.internal.ui.preferences.IAntBlockContainer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntClasspathPage
implements IAntBlockContainer {
    private AntClasspathBlock antClasspathBlock = new AntClasspathBlock(false);
    private AntRuntimePreferencePage preferencePage;
    private ClasspathModel model;

    public AntClasspathPage(AntRuntimePreferencePage preferencePage) {
        this.preferencePage = preferencePage;
    }

    protected IAntClasspathEntry[] getAdditionalEntries() {
        return this.model.getEntries(1);
    }

    protected IAntClasspathEntry[] getAntHomeEntries() {
        return this.model.getEntries(0);
    }

    protected String getAntHome() {
        return this.antClasspathBlock.getAntHome();
    }

    protected void initialize() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.createClasspathModel();
        this.antClasspathBlock.setInput(this.model);
        this.antClasspathBlock.initializeAntHome(prefs.getAntHome(), true);
        this.preferencePage.setErrorMessage(null);
        this.preferencePage.setValid(true);
    }

    protected void createClasspathModel() {
        this.model = new ClasspathModel();
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.model.setAntHomeEntries(prefs.getAntHomeClasspathEntries());
        this.model.setGlobalEntries(prefs.getAdditionalClasspathEntries());
    }

    protected void performDefaults() {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        this.model = new ClasspathModel();
        this.model.setAntHomeEntries(prefs.getDefaultAntHomeEntries());
        IAntClasspathEntry toolsEntry = prefs.getToolsJarEntry();
        IAntClasspathEntry[] additionalEntries = toolsEntry == null ? new IAntClasspathEntry[]{} : new IAntClasspathEntry[]{toolsEntry};
        this.model.setGlobalEntries(additionalEntries);
        this.antClasspathBlock.setInput(this.model);
        this.antClasspathBlock.initializeAntHome(prefs.getDefaultAntHome(), false);
        this.update();
    }

    protected TabItem createTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.getString("AntClasspathPage.title"));
        item.setImage(this.antClasspathBlock.getClasspathImage());
        item.setData((Object)this);
        item.setControl((Control)this.createContents((Composite)folder));
        return item;
    }

    protected Composite createContents(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.ant.ui.ant_classpath_page_context");
        Font font = parent.getFont();
        Composite top = new Composite(parent, 0);
        top.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        this.antClasspathBlock.setContainer(this);
        this.antClasspathBlock.createContents(top);
        return top;
    }

    public void update() {
        if (this.antClasspathBlock.isValidated()) {
            return;
        }
        this.setMessage(null);
        this.setErrorMessage(null);
        boolean valid = true;
        if (this.antClasspathBlock.isAntHomeEnabled()) {
            valid = this.antClasspathBlock.validateAntHome();
        }
        if (valid) {
            valid = this.antClasspathBlock.validateToolsJAR();
        }
        this.preferencePage.setValid(valid);
    }

    public void setMessage(String message) {
        this.preferencePage.setMessage(message);
    }

    public void setErrorMessage(String message) {
        this.preferencePage.setErrorMessage(message);
    }

    public Button createPushButton(Composite parent, String buttonText) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(buttonText);
        this.preferencePage.setButtonLayoutData(button);
        return button;
    }
}

