/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.AntClasspathContentProvider;
import org.eclipse.ant.internal.ui.preferences.AntClasspathLabelProvider;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.ClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.ClasspathModel;
import org.eclipse.ant.internal.ui.preferences.GlobalClasspathEntries;
import org.eclipse.ant.internal.ui.preferences.GlobalClasspathEntriesSelectionDialog;
import org.eclipse.ant.internal.ui.preferences.IAntBlockContainer;
import org.eclipse.ant.internal.ui.preferences.IClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.MessageDialogWithToggle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ArchiveFilter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class AntClasspathBlock {
    private static final String[] TOOLS = new String[]{"tools.jar"};
    private TreeViewer treeViewer;
    private AntClasspathContentProvider antContentProvider;
    private Button upButton;
    private Button downButton;
    private Button removeButton;
    private AntClasspathLabelProvider labelProvider = new AntClasspathLabelProvider();
    private Button addFolderButton;
    private Button addJARButton;
    private Button addExternalJARButton;
    private Button restoreButton;
    private boolean localBlock = false;
    private Text antHome;
    private Button browseAntHomeButton;
    private IDialogSettings dialogSettings = AntUIPlugin.getDefault().getDialogSettings();
    private boolean initializing = true;
    private IAntBlockContainer container;
    private int validated = 2;
    private IClasspathEntry currentParent;

    public AntClasspathBlock(boolean localClasspathBlock) {
        this.localBlock = localClasspathBlock;
    }

    public void setContainer(IAntBlockContainer container) {
        this.container = container;
    }

    private void addButtonsToButtonGroup(Composite parent) {
        this.addJARButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.addJarButtonTitle"));
        this.addJARButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AntClasspathBlock.this.addJars(AntClasspathBlock.this.treeViewer);
            }
        });
        this.addExternalJARButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.42"));
        this.addExternalJARButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AntClasspathBlock.this.addExternalJars(AntClasspathBlock.this.treeViewer);
            }
        });
        this.addFolderButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.addFolderButtonTitle"));
        this.addFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AntClasspathBlock.this.addFolder(AntClasspathBlock.this.treeViewer, AntPreferencesMessages.getString("AntClasspathBlock.1"));
            }
        });
        this.upButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.upButtonTitle"));
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AntClasspathBlock.this.handleMoveUp();
            }
        });
        this.downButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.downButtonTitle"));
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AntClasspathBlock.this.handleMoveDown();
            }
        });
        this.removeButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.removeButtonTitle"));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AntClasspathBlock.this.remove(AntClasspathBlock.this.treeViewer);
            }
        });
        if (this.localBlock) {
            this.restoreButton = this.container.createPushButton(parent, AntPreferencesMessages.getString("AntClasspathBlock.54"));
            this.restoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    AntClasspathBlock.this.restoreGlobalEntries();
                }
            });
        }
    }

    private void restoreGlobalEntries() {
        GlobalClasspathEntriesSelectionDialog dialog = new GlobalClasspathEntriesSelectionDialog(this.treeViewer.getControl().getShell(), (AntClasspathLabelProvider)this.treeViewer.getLabelProvider());
        ClasspathModel model = this.antContentProvider.getModel();
        Object[] removed = model.getRemovedGlobalEntries();
        Object[] elements = new Object[removed.length + 1];
        elements[0] = model.getAntHomeEntry();
        int i = 0;
        while (i < removed.length) {
            elements[i + 1] = removed[i];
            ++i;
        }
        dialog.setElements(elements);
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            int i2 = 0;
            while (i2 < result.length) {
                IAntClasspathEntry[] entries;
                GlobalClasspathEntries entry = (GlobalClasspathEntries)result[i2];
                if (entry.canBeRemoved()) {
                    if (dialog.addAsUnit()) {
                        model.setGlobalEntries(AntCorePlugin.getPlugin().getPreferences().getAdditionalClasspathEntries());
                        this.treeViewer.refresh();
                    } else {
                        entries = AntCorePlugin.getPlugin().getPreferences().getAdditionalClasspathEntries();
                        this.addEntries(entries);
                    }
                } else if (dialog.addAsUnit()) {
                    this.initializeAntHome(AntCorePlugin.getPlugin().getPreferences().getAntHome(), false);
                } else {
                    entries = AntCorePlugin.getPlugin().getPreferences().getAntHomeClasspathEntries();
                    this.addEntries(entries);
                }
                ++i2;
            }
            this.updateContainer();
        }
    }

    private void addEntries(IAntClasspathEntry[] entries) {
        this.antContentProvider.setRefreshEnabled(false);
        int j = 0;
        while (j < entries.length) {
            this.antContentProvider.add(2, (Object)entries[j]);
            ++j;
        }
        this.antContentProvider.setRefreshEnabled(true);
    }

    private List getOrderedSelection(IClasspathEntry parent) {
        ArrayList<IAntClasspathEntry> targets = new ArrayList<IAntClasspathEntry>();
        List selection = ((IStructuredSelection)this.treeViewer.getSelection()).toList();
        IAntClasspathEntry[] entries = parent.getEntries();
        int i = 0;
        while (i < entries.length) {
            IAntClasspathEntry target = entries[i];
            if (selection.contains(target)) {
                targets.add(target);
            }
            ++i;
        }
        return targets;
    }

    private void handleMoveDown() {
        List targets = this.getOrderedSelection(this.currentParent);
        if (targets.isEmpty()) {
            return;
        }
        ArrayList<IAntClasspathEntry> list = new ArrayList<IAntClasspathEntry>(Arrays.asList(this.currentParent.getEntries()));
        int bottom = list.size() - 1;
        int index = 0;
        int i = targets.size() - 1;
        while (i >= 0) {
            Object target = targets.get(i);
            index = list.indexOf(target);
            if (index < bottom) {
                bottom = index + 1;
                Object temp = list.get(bottom);
                list.set(bottom, (IAntClasspathEntry)target);
                list.set(index, (IAntClasspathEntry)temp);
            }
            bottom = index;
            --i;
        }
        AntClasspathContentProvider viewerContentProvider = (AntClasspathContentProvider)this.treeViewer.getContentProvider();
        viewerContentProvider.setEntries(this.currentParent, list);
        this.treeViewer.refresh();
        this.treeViewer.setSelection(this.treeViewer.getSelection());
        this.updateContainer();
    }

    private void handleMoveUp() {
        List targets = this.getOrderedSelection(this.currentParent);
        int top = 0;
        int index = 0;
        ArrayList<IAntClasspathEntry> list = new ArrayList<IAntClasspathEntry>(Arrays.asList(this.currentParent.getEntries()));
        Iterator entries = targets.iterator();
        while (entries.hasNext()) {
            Object target = entries.next();
            index = list.indexOf(target);
            if (index > top) {
                top = index - 1;
                Object temp = list.get(top);
                list.set(top, (IAntClasspathEntry)target);
                list.set(index, (IAntClasspathEntry)temp);
            }
            top = index;
        }
        AntClasspathContentProvider viewerContentProvider = (AntClasspathContentProvider)this.treeViewer.getContentProvider();
        viewerContentProvider.setEntries(this.currentParent, list);
        this.treeViewer.refresh();
        this.treeViewer.setSelection(this.treeViewer.getSelection());
        this.updateContainer();
    }

    private void remove(TreeViewer viewer) {
        AntClasspathContentProvider viewerContentProvider = (AntClasspathContentProvider)viewer.getContentProvider();
        IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
        viewerContentProvider.remove(sel);
        this.updateContainer();
    }

    private void addFolder(TreeViewer viewer, String message) {
        String lastUsedPath = this.dialogSettings.get("org.eclipse.ant.ui.lastfolder");
        if (lastUsedPath == null) {
            lastUsedPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.treeViewer.getControl().getShell());
        dialog.setMessage(message);
        dialog.setFilterPath(lastUsedPath);
        String result = dialog.open();
        if (result != null) {
            try {
                URL url = new URL("file:" + result + "/");
                ((AntClasspathContentProvider)viewer.getContentProvider()).add(this.currentParent, (Object)url);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        viewer.setSelection(viewer.getSelection());
        this.dialogSettings.put("org.eclipse.ant.ui.lastfolder", result);
        this.updateContainer();
    }

    private void addExternalJars(TreeViewer viewer) {
        String lastUsedPath = this.dialogSettings.get("org.eclipse.ant.ui.lastextjar");
        if (lastUsedPath == null) {
            lastUsedPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        FileDialog dialog = new FileDialog(this.treeViewer.getControl().getShell(), 2);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(lastUsedPath);
        String result = dialog.open();
        if (result == null) {
            return;
        }
        Path filterPath = new Path(dialog.getFilterPath());
        String[] results = dialog.getFileNames();
        AntClasspathContentProvider contentProvider = (AntClasspathContentProvider)viewer.getContentProvider();
        contentProvider.setRefreshEnabled(false);
        int i = 0;
        while (i < results.length) {
            String jarName = results[i];
            try {
                IPath path = filterPath.append(jarName).makeAbsolute();
                URL url = new URL("file:" + path.toOSString());
                contentProvider.add(this.currentParent, (Object)url);
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        contentProvider.setRefreshEnabled(true);
        viewer.setSelection(viewer.getSelection());
        this.dialogSettings.put("org.eclipse.ant.ui.lastextjar", filterPath.toOSString());
        this.updateContainer();
    }

    private void addJars(TreeViewer viewer) {
        ArrayList<IAntClasspathEntry> allEntries = new ArrayList<IAntClasspathEntry>();
        if (this.currentParent != null) {
            allEntries.addAll(Arrays.asList(this.currentParent.getEntries()));
        } else {
            IAntClasspathEntry[] entries = this.antContentProvider.getModel().getEntries(2);
            if (entries != null) {
                allEntries.addAll(Arrays.asList(entries));
            }
        }
        ArchiveFilter filter = new ArchiveFilter(allEntries);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(viewer.getControl().getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(AntPreferencesMessages.getString("AntClasspathBlock.44"));
        dialog.setMessage(AntPreferencesMessages.getString("AntClasspathBlock.45"));
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return new Status(4, AntUIPlugin.getUniqueIdentifier(), 0, "", null);
                }
                int i = 0;
                while (i < selection.length) {
                    if (!(selection[i] instanceof IFile)) {
                        return new Status(4, AntUIPlugin.getUniqueIdentifier(), 0, "", null);
                    }
                    ++i;
                }
                return new Status(0, AntUIPlugin.getUniqueIdentifier(), 0, "", null);
            }
        };
        dialog.setValidator(validator);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            AntClasspathContentProvider contentProvider = (AntClasspathContentProvider)viewer.getContentProvider();
            contentProvider.setRefreshEnabled(false);
            int i = 0;
            while (i < elements.length) {
                IFile file = (IFile)elements[i];
                String varExpression = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", file.getFullPath().toString());
                contentProvider.add(this.currentParent, (Object)varExpression);
                ++i;
            }
            contentProvider.setRefreshEnabled(true);
            this.updateContainer();
        }
    }

    private void updateContainer() {
        this.validated = 0;
        this.container.update();
    }

    private void createButtonGroup(Composite top) {
        Composite buttonGroup = new Composite(top, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)new GridData(1040));
        buttonGroup.setFont(top.getFont());
        this.addButtonsToButtonGroup(buttonGroup);
    }

    private void createClasspathTree(Composite parent) {
        Tree tree = new Tree(parent, 67586);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = tree.getItemHeight();
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    AntClasspathBlock.this.remove(AntClasspathBlock.this.treeViewer);
                }
            }
        });
        this.antContentProvider = new AntClasspathContentProvider();
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.antContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!AntClasspathBlock.this.initializing) {
                    AntClasspathBlock.this.tableSelectionChanged((IStructuredSelection)event.getSelection(), (AntClasspathContentProvider)AntClasspathBlock.this.treeViewer.getContentProvider());
                }
            }
        });
    }

    public void createContents(Composite parent) {
        this.createClasspathTree(parent);
        this.createButtonGroup(parent);
        this.createAntHome(parent);
        this.tableSelectionChanged((IStructuredSelection)this.treeViewer.getSelection(), this.antContentProvider);
    }

    private void createAntHome(Composite top) {
        Composite antHomeComposite = new Composite(top, 0);
        antHomeComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        antHomeComposite.setLayout((Layout)layout);
        antHomeComposite.setFont(top.getFont());
        Label antHomeLabel = new Label(antHomeComposite, 0);
        antHomeLabel.setFont(top.getFont());
        antHomeLabel.setText(AntPreferencesMessages.getString("AntClasspathBlock.55"));
        this.antHome = new Text(antHomeComposite, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        this.antHome.setLayoutData((Object)gd);
        this.antHome.setFont(top.getFont());
        this.antHome.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AntClasspathBlock.this.initializing) {
                    return;
                }
                String path = AntClasspathBlock.this.antHome.getText();
                if (path.length() > 0) {
                    File rootDir = new File(path, "lib");
                    if (rootDir.exists()) {
                        AntClasspathBlock.this.setAntHome(rootDir);
                    } else {
                        AntClasspathBlock.this.updateContainer();
                    }
                } else {
                    AntClasspathBlock.this.updateContainer();
                }
            }
        });
        this.browseAntHomeButton = this.container.createPushButton(top, AntPreferencesMessages.getString("AntClasspathBlock.&Browse..._10"));
        this.browseAntHomeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntClasspathBlock.this.browseAntHome();
            }
        });
    }

    private void tableSelectionChanged(IStructuredSelection selection, AntClasspathContentProvider contentProvider) {
        boolean notEmpty = !selection.isEmpty();
        Iterator selected = selection.iterator();
        boolean first = false;
        boolean last = false;
        boolean canRemove = true;
        boolean haveGlobalEntrySelected = false;
        while (selected.hasNext()) {
            IClasspathEntry parent;
            IClasspathEntry element = (IClasspathEntry)selected.next();
            if (!(!(element instanceof GlobalClasspathEntries) || ((GlobalClasspathEntries)element).canBeRemoved() && this.localBlock)) {
                canRemove = false;
            }
            if ((parent = element.getParent()) instanceof GlobalClasspathEntries) {
                haveGlobalEntrySelected = ((GlobalClasspathEntries)parent).canBeRemoved();
            }
            Object[] childEntries = contentProvider.getChildren(parent);
            List<Object> entries = Arrays.asList(childEntries);
            int lastEntryIndex = entries.size() - 1;
            if (!first && entries.indexOf(element) == 0) {
                first = true;
            }
            if (last || entries.indexOf(element) != lastEntryIndex) continue;
            last = true;
        }
        boolean canAdd = false;
        if (this.localBlock) {
            if (!notEmpty) {
                canAdd = true;
                this.currentParent = this.antContentProvider.getModel();
            } else {
                this.resolveCurrentParent(selection);
                if (haveGlobalEntrySelected) {
                    canRemove = false;
                }
            }
        } else {
            boolean bl = canAdd = this.resolveCurrentParent(selection) && notEmpty;
        }
        if (this.addJARButton != null) {
            this.addJARButton.setEnabled(canAdd);
        }
        this.addExternalJARButton.setEnabled(canAdd);
        this.addFolderButton.setEnabled(canAdd);
        this.removeButton.setEnabled(notEmpty && canRemove);
        this.upButton.setEnabled((canRemove || this.localBlock) && notEmpty && !first);
        this.downButton.setEnabled((canRemove || this.localBlock) && notEmpty && !last);
    }

    private boolean resolveCurrentParent(IStructuredSelection selection) {
        this.currentParent = null;
        Iterator selected = selection.iterator();
        while (selected.hasNext()) {
            Object element = selected.next();
            if (element instanceof ClasspathEntry) {
                IClasspathEntry parent = ((IClasspathEntry)element).getParent();
                if (this.currentParent != null) {
                    if (this.currentParent.equals(parent)) continue;
                    return false;
                }
                this.currentParent = parent;
                continue;
            }
            if (this.currentParent != null) {
                if (this.currentParent.equals(element)) continue;
                return false;
            }
            this.currentParent = (IClasspathEntry)element;
        }
        return true;
    }

    private File validateAntHome(String path) {
        File rootDir = null;
        if (path.length() > 0) {
            rootDir = new File(path, "lib");
            if (!rootDir.exists()) {
                this.container.setErrorMessage(AntPreferencesMessages.getString("AntClasspathBlock.Specified_ANT_HOME_does_not_contain_a___lib___directory_7"));
                this.setValidated();
                return null;
            }
        } else {
            this.setValidated();
            this.container.setErrorMessage(AntPreferencesMessages.getString("AntClasspathBlock.Specified_ANT_HOME_does_not_contain_a___lib___directory_7"));
            return null;
        }
        this.container.setErrorMessage(null);
        return rootDir;
    }

    private void browseAntHome() {
        String lastUsedPath = this.dialogSettings.get("org.eclipse.ant.ui.lastanthome");
        if (lastUsedPath == null) {
            lastUsedPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        DirectoryDialog dialog = new DirectoryDialog(this.treeViewer.getControl().getShell());
        dialog.setMessage(AntPreferencesMessages.getString("AntClasspathBlock.3"));
        dialog.setFilterPath(lastUsedPath);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        this.antHome.setText(path);
        this.dialogSettings.put("org.eclipse.ant.ui.lastanthome", path);
    }

    private void setAntHome(File rootDir) {
        AntClasspathContentProvider contentProvider = (AntClasspathContentProvider)this.treeViewer.getContentProvider();
        contentProvider.setRefreshEnabled(false);
        contentProvider.removeAllGlobalAntClasspathEntries();
        Object[] names = rootDir.list();
        Arrays.sort(names);
        int i = 0;
        while (i < names.length) {
            File file = new File(rootDir, (String)names[i]);
            if (file.isFile() && file.getPath().endsWith(".jar")) {
                try {
                    URL url = new URL("file:" + file.getAbsolutePath());
                    contentProvider.add(0, (Object)url);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++i;
        }
        contentProvider.setRefreshEnabled(true);
        this.updateContainer();
    }

    public String getAntHome() {
        String antHomeText = this.antHome.getText().trim();
        if (antHomeText.length() == 0) {
            antHomeText = "";
        }
        return antHomeText;
    }

    public void initializeAntHome(String antHomeString, boolean setInitializing) {
        this.initializing = setInitializing;
        this.antHome.setText(antHomeString);
        this.initializing = false;
    }

    public void setInput(ClasspathModel model) {
        this.treeViewer.setInput((Object)model);
    }

    public boolean isAntHomeEnabled() {
        return this.antHome.isEnabled();
    }

    public boolean validateAntHome() {
        ++this.validated;
        return this.validateAntHome(this.antHome.getText()) != null;
    }

    public Image getClasspathImage() {
        return this.labelProvider.getClasspathImage();
    }

    public boolean validateToolsJAR() {
        ++this.validated;
        boolean check = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("toolsJAR");
        if (check && !AntUIPlugin.isMacOS()) {
            boolean valid;
            Object[] entries = this.antContentProvider.getModel().getEntries(0);
            boolean bl = valid = !this.JARPresent(entries, TOOLS).isEmpty();
            if (!valid) {
                entries = this.antContentProvider.getModel().getEntries(1);
                boolean bl2 = valid = !this.JARPresent(entries, TOOLS).isEmpty();
                if (!valid) {
                    entries = this.antContentProvider.getModel().getEntries(2);
                    boolean bl3 = valid = !this.JARPresent(entries, TOOLS).isEmpty();
                    if (!valid) {
                        valid = MessageDialogWithToggle.openQuestion(AntUIPlugin.getActiveWorkbenchWindow().getShell(), AntPreferencesMessages.getString("AntClasspathBlock.31"), AntPreferencesMessages.getString("AntClasspathBlock.32"), "toolsJAR", AntPreferencesMessages.getString("AntClasspathBlock.33"), AntUIPlugin.getDefault().getPreferenceStore());
                    }
                }
            }
            if (!valid) {
                this.container.setErrorMessage(AntPreferencesMessages.getString("AntClasspathBlock.34"));
                this.setValidated();
            }
            return valid;
        }
        return true;
    }

    private List JARPresent(Object[] classpathEntries, String[] suffixes) {
        if (classpathEntries == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> found = new ArrayList<String>(2);
        int i = 0;
        while (i < classpathEntries.length) {
            Object entry = classpathEntries[i];
            String file = entry instanceof URL ? ((URL)entry).getFile() : entry.toString();
            int j = 0;
            while (j < suffixes.length) {
                String suffix = suffixes[j];
                if (file.endsWith(suffix)) {
                    found.add(suffix);
                }
                ++j;
            }
            ++i;
        }
        return found;
    }

    public boolean isValidated() {
        return this.validated >= 2;
    }

    public void setValidated() {
        this.validated = 2;
    }
}

