/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddPropertyDialog
extends Dialog {
    private String fName;
    private String fValue;
    private String fTitle;
    private Label fNameLabel;
    private Text fNameText;
    private Label fValueLabel;
    private Text fValueText;
    private String[] fInitialValues;

    public AddPropertyDialog(Shell shell, String title, String[] initialValues) {
        super(shell);
        this.fTitle = title;
        this.fInitialValues = initialValues;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        ((GridLayout)comp.getLayout()).numColumns = 2;
        this.fNameLabel = new Label(comp, 0);
        this.fNameLabel.setText(AntPreferencesMessages.getString("AddPropertyDialog.&Name__1"));
        this.fNameLabel.setFont(comp.getFont());
        this.fNameText = new Text(comp, 2052);
        this.fNameText.setText(this.fInitialValues[0]);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.setFont(comp.getFont());
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPropertyDialog.this.updateButtons();
            }
        });
        this.fValueLabel = new Label(comp, 0);
        this.fValueLabel.setText(AntPreferencesMessages.getString("AddPropertyDialog.&Value__2"));
        this.fValueLabel.setFont(comp.getFont());
        this.fValueText = new Text(comp, 2052);
        this.fValueText.setText(this.fInitialValues[1]);
        gd = new GridData(768);
        gd.widthHint = 300;
        this.fValueText.setLayoutData((Object)gd);
        this.fValueText.setFont(comp.getFont());
        this.fValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPropertyDialog.this.updateButtons();
            }
        });
        return comp;
    }

    public String[] getNameValuePair() {
        return new String[]{this.fName, this.fValue};
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.fName = this.fNameText.getText();
            this.fValue = this.fValueText.getText();
        } else {
            this.fName = null;
            this.fValue = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
        if (this.fInitialValues[0].length() == 0) {
            WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.ant.ui.add_property_dialog_context");
        } else {
            WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.ant.ui.edit_property_dialog_context");
        }
    }

    protected void updateButtons() {
        String name = this.fNameText.getText().trim();
        String value = this.fValueText.getText().trim();
        this.getButton(0).setEnabled(name.length() > 0 && value.length() > 0);
    }

    public void create() {
        super.create();
        this.updateButtons();
    }
}

