/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.ImageDescriptorRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class AntUIImages {
    private static ImageRegistry imageRegistry;
    private static ImageDescriptorRegistry imageDescriptorRegistry;
    private static Map imageDescriptors;
    private static URL ICON_BASE_URL;
    private static final String LOCALTOOL = "clcl16/";
    private static final String OBJECT = "obj16/";
    private static final String OVR = "ovr16/";

    static {
        ICON_BASE_URL = null;
        String pathSuffix = "icons/full/";
        try {
            ICON_BASE_URL = new URL(AntUIPlugin.getDefault().getDescriptor().getInstallURL(), pathSuffix);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private static void declareImages() {
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.IMG_PROPERTY", "obj16/property_obj.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.html_tab_obj", "obj16/task_obj.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.remove", "clcl16/remove_co.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.removeAll", "clcl16/removeAll_co.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.add", "clcl16/add_co.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.run", "clcl16/run_tool.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.search", "clcl16/search.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.filterInternalTargets", "clcl16/filter_internal_targets.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.sortOutline", "clcl16/alpha_mode.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.antProject", "obj16/ant_buildfile.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.antTarget", "obj16/targetpublic_obj.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.antPrivateTarget", "obj16/targetinternal_obj.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.antDefaultTarget", "obj16/defaulttarget_obj.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.antTargetError", "obj16/ant_target_err.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.IMG_TAB_ANT_TARGETS", "clcl16/ant_targets.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.IMG_TAB_CLASSPATH", "obj16/classpath.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.IMG_JAR_FILE", "obj16/jar_l_obj.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.type", "obj16/type.gif");
        AntUIImages.declareRegistryImage("org.eclipse.ant.ui.ovrError", "ovr16/error_co.gif");
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)AntUIImages.makeIconFileURL(path));
        }
        catch (MalformedURLException malformedURLException) {}
        imageRegistry.put(key, desc);
        imageDescriptors.put(key, desc);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            AntUIImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    public static ImageRegistry initializeImageRegistry() {
        imageRegistry = new ImageRegistry(AntUIPlugin.getStandardDisplay());
        imageDescriptors = new HashMap(30);
        AntUIImages.declareImages();
        return imageRegistry;
    }

    public static Image getImage(String key) {
        return AntUIImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (imageDescriptors == null) {
            AntUIImages.initializeImageRegistry();
        }
        return (ImageDescriptor)imageDescriptors.get(key);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        AntUIImages.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id;
        try {
            id = ImageDescriptor.createFromURL((URL)AntUIImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            AntUIPlugin.log(e);
        }
        try {
            id = ImageDescriptor.createFromURL((URL)AntUIImages.makeIconFileURL("c" + type, relPath));
            if (id != null) {
                action.setHoverImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            AntUIPlugin.log(e);
        }
        action.setImageDescriptor(AntUIImages.create("e" + type, relPath));
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)AntUIImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            AntUIPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(CompositeImageDescriptor imageDescriptor) {
        if (imageDescriptorRegistry == null) {
            imageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return imageDescriptorRegistry.get((ImageDescriptor)imageDescriptor);
    }

    public static void disposeImageDescriptorRegistry() {
        if (imageDescriptorRegistry != null) {
            imageDescriptorRegistry.dispose();
        }
    }
}

