/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.WorkingDirectoryBlock;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;

public class AntWorkingDirectoryBlock
extends WorkingDirectoryBlock {
    private String fDefaultWorkingDirPath;

    public String getDefaultWorkingDirPath() {
        return this.fDefaultWorkingDirPath;
    }

    protected void setDefaultWorkingDir() {
        if (this.fDefaultWorkingDirPath == null) {
            super.setDefaultWorkingDir();
            return;
        }
        this.fWorkingDirText.setText(this.fDefaultWorkingDirPath);
        this.fLocalDirButton.setSelection(true);
        this.fWorkspaceDirButton.setSelection(false);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            try {
                this.fDefaultWorkingDirPath = ExternalToolsUtil.getLocation((ILaunchConfiguration)configuration).removeLastSegments(1).toOSString();
            }
            catch (CoreException coreException) {}
            String wd = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
            this.fWorkspaceDirText.setText("");
            this.fWorkingDirText.setText("");
            if (wd == null || this.isSameAsDefault(wd)) {
                this.fUseDefaultWorkingDirButton.setSelection(true);
            } else {
                Path path = new Path(wd);
                if (path.isAbsolute()) {
                    this.fWorkingDirText.setText(wd);
                    this.fLocalDirButton.setSelection(true);
                    this.fWorkspaceDirButton.setSelection(false);
                } else {
                    this.fWorkspaceDirText.setText(wd);
                    this.fWorkspaceDirButton.setSelection(true);
                    this.fLocalDirButton.setSelection(false);
                }
                this.fUseDefaultWorkingDirButton.setSelection(false);
            }
            this.handleUseDefaultWorkingDirButtonSelected();
        }
        catch (CoreException e) {
            this.setErrorMessage(String.valueOf(LauncherMessages.getString((String)"JavaArgumentsTab.Exception_occurred_reading_configuration___15")) + e.getStatus().getMessage());
            JDIDebugUIPlugin.log((Throwable)e);
        }
    }

    private boolean isSameAsDefault(String workingDir) {
        return workingDir == null || workingDir.equals(this.fDefaultWorkingDirPath) || workingDir.equals(System.getProperty("user.dir"));
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String wd = this.getCurrentWorkingDirectory();
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, wd);
    }

    private String getCurrentWorkingDirectory() {
        String wd = null;
        if (this.isLocalWorkingDirectory()) {
            wd = this.getAttributeValueFrom(this.fWorkingDirText);
        } else {
            Path path = new Path(this.fWorkspaceDirText.getText());
            path = path.makeRelative();
            wd = path.toString();
        }
        return wd;
    }

    public void setEnabled(boolean enabled) {
        this.fWorkingDirLabel.setEnabled(enabled);
        this.fUseDefaultWorkingDirButton.setEnabled(enabled);
        if (!this.isDefaultWorkingDirectory() && enabled) {
            boolean local = this.isLocalWorkingDirectory();
            this.fWorkingDirText.setEnabled(local);
            this.fWorkingDirBrowseButton.setEnabled(local);
            this.fLocalDirButton.setEnabled(true);
            this.fWorkspaceDirText.setEnabled(!local);
            this.fWorkspaceDirBrowseButton.setEnabled(!local);
            this.fWorkspaceDirButton.setEnabled(true);
        } else {
            this.fWorkingDirText.setEnabled(false);
            this.fWorkingDirBrowseButton.setEnabled(false);
            this.fWorkspaceDirText.setEnabled(false);
            this.fWorkspaceDirBrowseButton.setEnabled(false);
            this.fLocalDirButton.setEnabled(false);
            this.fWorkspaceDirButton.setEnabled(false);
            this.fUseDefaultWorkingDirButton.setSelection(this.isSameAsDefault(this.getCurrentWorkingDirectory()));
        }
    }
}

