/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntProcess;
import org.eclipse.ant.internal.ui.launchConfigurations.RemoteAntBuildListener;
import org.eclipse.ant.internal.ui.launchConfigurations.TaskLinkManager;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.ant.internal.ui.preferences.MessageDialogWithToggle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jdt.internal.launching.JavaLocalApplicationLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.externaltools.internal.program.launchConfigurations.BackgroundResourceRefresher;

public class AntLaunchDelegate
implements ILaunchConfigurationDelegate {
    private static final String ANT_LOGGER_CLASS = "org.eclipse.ant.internal.ui.antsupport.logger.AntProcessBuildLogger";
    private static final String NULL_LOGGER_CLASS = "org.eclipse.ant.internal.ui.antsupport.logger.NullBuildLogger";
    private static final String REMOTE_ANT_LOGGER_CLASS = "org.eclipse.ant.internal.ui.antsupport.logger.RemoteAntBuildLogger";
    private static final String BASE_DIR_PREFIX = "-Dbasedir=";
    private static final String INPUT_HANDLER_CLASS = "org.eclipse.ant.internal.ui.antsupport.inputhandler.AntInputHandler";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        String vmTypeID = null;
        try {
            vmTypeID = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
        }
        catch (CoreException ce) {
            AntUIPlugin.log(ce);
        }
        if (CommonTab.isLaunchInBackground((ILaunchConfiguration)configuration)) {
            monitor.beginTask(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchDelegate.Launching_{0}_1"), configuration.getName()), 10);
        } else {
            monitor.beginTask(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchDelegate.Running_{0}_2"), configuration.getName()), 100);
        }
        IPath location = ExternalToolsUtil.getLocation((ILaunchConfiguration)configuration);
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        if (vmTypeID == null && AntRunner.isBuildRunning()) {
            Status status = new Status(4, "org.eclipse.ant.ui", 1, MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchDelegate.Build_In_Progress"), location.toOSString()), null);
            throw new CoreException((IStatus)status);
        }
        IPath workingDirectory = ExternalToolsUtil.getWorkingDirectory((ILaunchConfiguration)configuration);
        String baseDir = null;
        if (workingDirectory != null) {
            baseDir = workingDirectory.toOSString();
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        long timeStamp = System.currentTimeMillis();
        String idStamp = Long.toString(timeStamp);
        StringBuffer idProperty = new StringBuffer("-D");
        idProperty.append("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID");
        idProperty.append('=');
        idProperty.append(idStamp);
        String[] arguments = ExternalToolsUtil.getArguments((ILaunchConfiguration)configuration);
        int argLength = 1;
        if (arguments != null) {
            argLength += arguments.length;
        }
        if (baseDir != null && baseDir.length() > 0) {
            ++argLength;
        }
        String[] runnerArgs = new String[argLength];
        if (arguments != null) {
            System.arraycopy(arguments, 0, runnerArgs, 0, arguments.length);
        }
        if (baseDir != null && baseDir.length() > 0) {
            runnerArgs[runnerArgs.length - 2] = BASE_DIR_PREFIX + baseDir;
        }
        runnerArgs[runnerArgs.length - 1] = idProperty.toString();
        HashMap<String, String> userProperties = AntUtil.getProperties(configuration);
        String[] propertyFiles = AntUtil.getPropertyFiles(configuration);
        String[] targets = AntUtil.getTargetsFromConfig(configuration);
        URL[] customClasspath = AntUtil.getCustomClasspath(configuration);
        String antHome = AntUtil.getAntHome(configuration);
        AntRunner runner = null;
        if (vmTypeID == null) {
            runner = new AntRunner();
            runner.setBuildFileLocation(location.toOSString());
            if (ExternalToolsUtil.getCaptureOutput((ILaunchConfiguration)configuration)) {
                runner.addBuildLogger(ANT_LOGGER_CLASS);
            } else {
                runner.addBuildLogger(NULL_LOGGER_CLASS);
            }
            runner.setInputHandler(INPUT_HANDLER_CLASS);
            runner.setArguments(runnerArgs);
            if (userProperties != null) {
                runner.addUserProperties(userProperties);
            }
            if (propertyFiles != null) {
                runner.setPropertyFiles(propertyFiles);
            }
            if (targets != null) {
                runner.setExecutionTargets(targets);
            }
            if (customClasspath != null) {
                runner.setCustomClasspath(customClasspath);
            }
            if (antHome != null) {
                runner.setAntHome(antHome);
            }
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        int port = -1;
        if (vmTypeID != null) {
            if (userProperties == null) {
                userProperties = new HashMap<String, String>();
            }
            port = SocketUtil.findFreePort();
            userProperties.put("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID", idStamp);
            userProperties.put("eclipse.connect.port", Integer.toString(port));
        }
        StringBuffer commandLine = this.generateCommandLine(location, arguments, userProperties, propertyFiles, targets, antHome, vmTypeID != null);
        if (vmTypeID != null) {
            monitor.beginTask(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchDelegate.Launching_{0}_1"), configuration.getName()), 10);
            this.runInSeparateVM(configuration, launch, monitor, idStamp, port, commandLine);
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(IProcess.ATTR_PROCESS_TYPE, "org.eclipse.ant.ui.antProcess");
        attributes.put("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID", idStamp);
        final AntProcess process = new AntProcess(location.toOSString(), launch, attributes);
        this.setProcessAttributes(process, idStamp, commandLine);
        if (CommonTab.isLaunchInBackground((ILaunchConfiguration)configuration)) {
            final AntRunner finalRunner = runner;
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        finalRunner.run((IProgressMonitor)process);
                    }
                    catch (CoreException e) {
                        AntLaunchDelegate.this.handleException(e, AntLaunchConfigurationMessages.getString("AntLaunchDelegate.Failure"));
                    }
                    process.terminated();
                }
            };
            Thread background = new Thread(r);
            background.start();
            monitor.worked(1);
            if (RefreshTab.getRefreshScope((ILaunchConfiguration)configuration) != null) {
                BackgroundResourceRefresher refresher = new BackgroundResourceRefresher(configuration, (IProcess)process);
                refresher.startBackgroundRefresh();
            }
        } else {
            try {
                runner.run(monitor);
            }
            catch (CoreException e) {
                process.terminated();
                monitor.done();
                this.handleException(e, AntLaunchConfigurationMessages.getString("AntLaunchDelegate.23"));
                return;
            }
            process.terminated();
            RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
        }
        monitor.done();
    }

    private void handleException(final CoreException e, final String title) {
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("errorDialog")) {
            AntUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialogWithToggle.openError(null, title, e.getMessage(), "errorDialog", AntLaunchConfigurationMessages.getString("AntLaunchDelegate.22"), AntUIPlugin.getDefault().getPreferenceStore());
                }
            });
        }
    }

    private void setProcessAttributes(IProcess process, String idStamp, StringBuffer commandLine) {
        process.setAttribute("org.eclipse.ant.ui.ATTR_ANT_PROCESS_ID", idStamp);
        if (commandLine != null) {
            process.setAttribute(IProcess.ATTR_CMDLINE, commandLine.toString());
        }
        TaskLinkManager.registerAntBuild(process);
    }

    private StringBuffer generateCommandLine(IPath location, String[] arguments, Map userProperties, String[] propertyFiles, String[] targets, String antHome, boolean separateVM) {
        String key;
        String path;
        StringBuffer commandLine = new StringBuffer();
        if (!separateVM) {
            commandLine.append("ant");
        }
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                String arg = arguments[i];
                commandLine.append(' ');
                commandLine.append(arg);
                ++i;
            }
        }
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        String[] files = prefs.getCustomPropertyFiles();
        int i = 0;
        while (i < files.length) {
            path = files[i];
            commandLine.append(" -propertyfile ");
            commandLine.append(path);
            ++i;
        }
        if (propertyFiles != null) {
            i = 0;
            while (i < propertyFiles.length) {
                path = propertyFiles[i];
                commandLine.append(" -propertyfile ");
                commandLine.append(path);
                ++i;
            }
        }
        if (userProperties != null) {
            Iterator keys = userProperties.keySet().iterator();
            while (keys.hasNext()) {
                key = (String)keys.next();
                this.appendProperty(commandLine, key, (String)userProperties.get(key));
            }
        }
        List<Property> properties = null;
        properties = !separateVM ? prefs.getProperties() : Arrays.asList(prefs.getCustomProperties());
        Iterator<Property> iter = properties.iterator();
        while (iter.hasNext()) {
            Property property = iter.next();
            key = property.getName();
            if (property.getValue() == null || userProperties != null && userProperties.get(key) != null) continue;
            this.appendProperty(commandLine, key, property.getValue());
        }
        if (antHome != null) {
            commandLine.append(" -Dant.home=");
            commandLine.append(antHome);
        }
        if (separateVM) {
            if (commandLine.indexOf("-logger") == -1) {
                commandLine.append(" -logger ");
                commandLine.append(REMOTE_ANT_LOGGER_CLASS);
            }
        } else {
            commandLine.append(" -inputhandler ");
            commandLine.append(INPUT_HANDLER_CLASS);
            commandLine.append(" -logger ");
            commandLine.append(ANT_LOGGER_CLASS);
        }
        commandLine.append(" -buildfile \"");
        commandLine.append(String.valueOf(location.toOSString()) + '\"');
        if (targets != null) {
            int i2 = 0;
            while (i2 < targets.length) {
                commandLine.append(" \"");
                commandLine.append(targets[i2]);
                commandLine.append('\"');
                ++i2;
            }
        }
        return commandLine;
    }

    private void appendProperty(StringBuffer commandLine, String name, String value) {
        commandLine.append(" \"-D");
        commandLine.append(name);
        commandLine.append('=');
        commandLine.append(value);
        commandLine.append('\"');
    }

    private void runInSeparateVM(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor, String idStamp, int port, StringBuffer commandLine) throws CoreException {
        RemoteAntBuildListener client = new RemoteAntBuildListener(launch);
        if (port != -1) {
            client.startListening(port);
        }
        ILaunchConfigurationWorkingCopy copy = configuration.getWorkingCopy();
        copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, commandLine.toString());
        launch.setSourceLocator(new ISourceLocator(){

            public Object getSourceElement(IStackFrame stackFrame) {
                return null;
            }
        });
        JavaLocalApplicationLaunchConfigurationDelegate delegate = new JavaLocalApplicationLaunchConfigurationDelegate();
        delegate.launch((ILaunchConfiguration)copy, "run", launch, monitor);
        IProcess[] processes = launch.getProcesses();
        int i = 0;
        while (i < processes.length) {
            this.setProcessAttributes(processes[i], idStamp, null);
            ++i;
        }
        if (RefreshTab.getRefreshScope((ILaunchConfiguration)configuration) != null) {
            BackgroundResourceRefresher refresher = new BackgroundResourceRefresher(configuration, processes[0]);
            refresher.startBackgroundRefresh();
        }
    }
}

