/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.ui.launchConfigurations.AntClasspathTab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntTargetsTab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntWorkingDirectoryBlock;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.ant.internal.ui.preferences.ClasspathModel;
import org.eclipse.ant.internal.ui.preferences.MessageDialogWithToggle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaJRETab;
import org.eclipse.jdt.internal.debug.ui.jres.DefaultJREDescriptor;
import org.eclipse.jdt.internal.debug.ui.launcher.VMArgumentsBlock;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntJRETab
extends JavaJRETab {
    private static final String XERCES_IMPL = "xercesImpl.jar";
    private static final String XERCES_API = "xml-apis.jar";
    private static final String XERCES_PARSER_API = "xmlParserAPIs.jar";
    private static final String MAIN_TYPE_NAME = "org.eclipse.ant.internal.ui.antsupport.InternalAntRunner";
    private Button updateClasspathButton;
    private IVMInstall previousJRE;
    protected VMArgumentsBlock fVMArgumentsBlock = new VMArgumentsBlock();
    protected AntWorkingDirectoryBlock fWorkingDirectoryBlock = new AntWorkingDirectoryBlock();
    private boolean warningShown = false;

    public void createControl(Composite parent) {
        super.createControl(parent);
        Font font = parent.getFont();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"ant_jre_tab_context");
        Composite comp = (Composite)this.fJREBlock.getControl();
        this.createVerticalSpacer(comp, 3);
        Composite lowerComp = new Composite(comp, 0);
        GridLayout updateLayout = new GridLayout();
        updateLayout.numColumns = 2;
        updateLayout.marginHeight = 0;
        updateLayout.marginWidth = 0;
        lowerComp.setLayout((Layout)updateLayout);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        lowerComp.setLayoutData((Object)gd);
        lowerComp.setFont(font);
        Label label = new Label(lowerComp, 0);
        label.setText(AntLaunchConfigurationMessages.getString("AntJRETab.9"));
        label.setFont(font);
        gd = new GridData(256);
        label.setLayoutData((Object)gd);
        this.updateClasspathButton = this.createPushButton(lowerComp, AntLaunchConfigurationMessages.getString("AntJRETab.10"), null);
        this.updateClasspathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntJRETab.this.updateClasspath(AntJRETab.this.getLaunchConfigurationWorkingCopy());
            }
        });
        gd = (GridData)this.updateClasspathButton.getLayoutData();
        gd.horizontalAlignment = 32;
        this.createVerticalSpacer(lowerComp, 2);
        this.fVMArgumentsBlock.createControl(lowerComp);
        ((GridData)this.fVMArgumentsBlock.getControl().getLayoutData()).horizontalSpan = 2;
        this.createVerticalSpacer(lowerComp, 2);
        this.fWorkingDirectoryBlock.createControl(lowerComp);
        ((GridData)this.fWorkingDirectoryBlock.getControl().getLayoutData()).horizontalSpan = 2;
    }

    protected DefaultJREDescriptor getDefaultJREDescriptor() {
        return new DefaultJREDescriptor(){

            public IVMInstall getDefaultJRE() {
                return null;
            }

            public String getDescription() {
                return AntLaunchConfigurationMessages.getString("AntJRETab.2");
            }
        };
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.fWorkingDirectoryBlock.setEnabled(!this.fJREBlock.isDefaultJRE());
        this.fVMArgumentsBlock.setEnabled(!this.fJREBlock.isDefaultJRE());
        if (this.fJREBlock.isDefaultJRE()) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, null);
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
        } else {
            super.performApply(configuration);
            this.applySeparateVMAttributes(configuration);
            this.fVMArgumentsBlock.performApply(configuration);
            this.fWorkingDirectoryBlock.performApply(configuration);
        }
        this.setLaunchConfigurationWorkingCopy(configuration);
    }

    private void applySeparateVMAttributes(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, MAIN_TYPE_NAME);
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        configuration.setAttribute("process_factory_id", "org.eclipse.ant.ui.remoteAntProcessFactory");
    }

    private void updateClasspath(ILaunchConfigurationWorkingCopy configuration) {
        IVMInstall vm = this.fJREBlock.getJRE();
        if (this.fJREBlock.isDefaultJRE()) {
            vm = null;
        }
        Path oldJavaPath = null;
        oldJavaPath = this.previousJRE == null ? new Path(System.getProperty("java.home")) : new Path(this.previousJRE.getInstallLocation().getAbsolutePath());
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        IAntClasspathEntry oldToolsEntry = prefs.getToolsJarEntry((IPath)oldJavaPath);
        Path newJavaPath = null;
        newJavaPath = vm == null ? new Path(System.getProperty("java.home")) : new Path(vm.getInstallLocation().getAbsolutePath());
        IAntClasspathEntry newToolsEntry = prefs.getToolsJarEntry((IPath)newJavaPath);
        ArrayList antEntries = new ArrayList();
        ArrayList userEntries = new ArrayList();
        this.getEntries(prefs, configuration, antEntries, userEntries);
        StringBuffer classpath = new StringBuffer();
        boolean found = false;
        boolean xercesImplFound = false;
        boolean xercesAPIFound = false;
        boolean[] xercesFlags = new boolean[]{xercesImplFound, xercesAPIFound};
        found = this.lookForToolsAndXerces(antEntries, oldToolsEntry, newToolsEntry, xercesFlags);
        boolean foundInAdditional = this.lookForToolsAndXerces(userEntries, oldToolsEntry, newToolsEntry, xercesFlags);
        if (newToolsEntry != null && !found && !foundInAdditional) {
            classpath.append(newToolsEntry.getLabel());
            classpath.append(",");
        }
        if (!(this.fJREBlock.isDefaultJRE() || xercesFlags[0] && xercesFlags[1])) {
            IPluginDescriptor descriptor = Platform.getPlugin((String)"org.apache.xerces").getDescriptor();
            this.addLibraries(descriptor, classpath, !xercesFlags[1], !xercesFlags[0]);
        }
        ClasspathModel model = this.getClasspathModel();
        classpath.append(model.serializeClasspath(true));
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", classpath.toString());
        this.previousJRE = vm;
        this.updateOtherTabs();
        this.updateLaunchConfigurationDialog();
    }

    private void updateOtherTabs() {
        ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationDialog().getTabs();
        int i = 0;
        while (i < tabs.length) {
            ILaunchConfigurationTab tab = tabs[i];
            if (tab instanceof AntTargetsTab) {
                ((AntTargetsTab)tab).setDirty(true);
            } else if (tab instanceof AntClasspathTab) {
                ((AntClasspathTab)tab).setDirty(true);
            }
            ++i;
        }
    }

    private ClasspathModel getClasspathModel() {
        ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationDialog().getTabs();
        int i = 0;
        while (i < tabs.length) {
            ILaunchConfigurationTab tab = tabs[i];
            if (tab instanceof AntClasspathTab) {
                return ((AntClasspathTab)tab).getClasspathModel();
            }
            ++i;
        }
        return null;
    }

    private void getEntries(AntCorePreferences prefs, ILaunchConfigurationWorkingCopy configuration, List antHomeEntries, List additionalEntries) {
        String entryStrings = null;
        try {
            entryStrings = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
        if (entryStrings == null) {
            antHomeEntries.addAll(Arrays.asList(prefs.getAntHomeClasspathEntries()));
            additionalEntries.addAll(Arrays.asList(prefs.getAdditionalClasspathEntries()));
        } else {
            AntUtil.getCustomClasspaths((ILaunchConfiguration)configuration, antHomeEntries, additionalEntries);
        }
    }

    private boolean lookForToolsAndXerces(List entries, IAntClasspathEntry oldToolsEntry, IAntClasspathEntry newToolsEntry, boolean[] xercesFlags) {
        boolean found = false;
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            IAntClasspathEntry entry = (IAntClasspathEntry)iter.next();
            if (this.sameURL(oldToolsEntry, entry)) {
                entry = newToolsEntry;
                found = newToolsEntry != null;
                continue;
            }
            if (this.sameURL(newToolsEntry, entry)) {
                found = true;
                continue;
            }
            if (entry.getLabel().endsWith(XERCES_API)) {
                xercesFlags[1] = true;
                continue;
            }
            if (entry.getLabel().endsWith(XERCES_IMPL)) {
                xercesFlags[0] = true;
                continue;
            }
            if (!entry.getLabel().endsWith(XERCES_PARSER_API)) continue;
            xercesFlags[1] = true;
        }
        return found;
    }

    private void addLibraries(IPluginDescriptor xercesPlugin, StringBuffer urlString, boolean addAPI, boolean addImpl) {
        URL root = xercesPlugin.getInstallURL();
        ILibrary[] libraries = xercesPlugin.getRuntimeLibraries();
        int i = 0;
        while (i < libraries.length) {
            try {
                IPath path = libraries[i].getPath();
                if (!(path.lastSegment().equals(XERCES_API) && !addAPI || path.lastSegment().equals(XERCES_PARSER_API) && !addAPI || path.lastSegment().equals(XERCES_IMPL) && !addImpl)) {
                    URL url = new URL(root, path.toString());
                    urlString.append(Platform.asLocalURL((URL)url).getFile());
                    urlString.append(",");
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
            ++i;
        }
    }

    private boolean sameURL(IAntClasspathEntry first, IAntClasspathEntry second) {
        if (first == null || second == null) {
            return false;
        }
        File newFile = new File(first.getEntryURL().getFile());
        File existingFile = new File(second.getEntryURL().getFile());
        return existingFile.equals(newFile);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.fVMArgumentsBlock.initializeFrom(configuration);
        this.fWorkingDirectoryBlock.initializeFrom(configuration);
        this.fWorkingDirectoryBlock.setEnabled(!this.fJREBlock.isDefaultJRE());
        this.fVMArgumentsBlock.setEnabled(!this.fJREBlock.isDefaultJRE());
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.fWorkingDirectoryBlock.isValid(config);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.fWorkingDirectoryBlock.setLaunchConfigurationDialog(dialog);
        this.fVMArgumentsBlock.setLaunchConfigurationDialog(dialog);
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getErrorMessage();
        }
        return m;
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getMessage();
        }
        return m;
    }

    protected void handleSelectedJREChanged() {
        if (this.fIsInitializing) {
            return;
        }
        boolean check = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("antClasspathInfo");
        if (check && !this.warningShown) {
            this.warningShown = true;
            MessageDialogWithToggle.openWarning(AntUIPlugin.getActiveWorkbenchWindow().getShell(), AntLaunchConfigurationMessages.getString("AntJRETab.11"), AntLaunchConfigurationMessages.getString("AntJRETab.12"), "antClasspathInfo", AntLaunchConfigurationMessages.getString("AntJRETab.13"), AntUIPlugin.getDefault().getPreferenceStore());
        }
        super.handleSelectedJREChanged();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.setLaunchConfigurationWorkingCopy(workingCopy);
        this.warningShown = false;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        IVMInstall defaultInstall = null;
        try {
            defaultInstall = JavaRuntime.computeVMInstall((ILaunchConfiguration)config);
        }
        catch (CoreException coreException) {
            defaultInstall = JavaRuntime.getDefaultVMInstall();
        }
        if (defaultInstall != null) {
            String vmName = defaultInstall.getName();
            String vmTypeID = defaultInstall.getVMInstallType().getId();
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmName);
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vmTypeID);
            this.applySeparateVMAttributes(config);
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

