/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.ant.internal.ui.launchConfigurations.AntProcess;
import org.eclipse.ant.internal.ui.launchConfigurations.AntStreamsProxy;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.swt.graphics.Color;

public class AntConsoleColorProvider
extends ConsoleColorProvider {
    public Color getColor(String streamIdentifer) {
        if (streamIdentifer.equals(IDebugUIConstants.ID_STANDARD_OUTPUT_STREAM)) {
            return AntUIPlugin.getPreferenceColor("console.infoColor");
        }
        if (streamIdentifer.equals(IDebugUIConstants.ID_STANDARD_ERROR_STREAM)) {
            return AntUIPlugin.getPreferenceColor("console.errorColor");
        }
        if (streamIdentifer.equals("org.eclipse.ant.ui.ANT_DEBUG_STREAM")) {
            return AntUIPlugin.getPreferenceColor("console.debugColor");
        }
        if (streamIdentifer.equals("org.eclipse.ant.ui.ANT_VERBOSE_STREAM")) {
            return AntUIPlugin.getPreferenceColor("console.verboseColor");
        }
        if (streamIdentifer.equals("org.eclipse.ant.ui.ANT_WARNING_STREAM")) {
            return AntUIPlugin.getPreferenceColor("console.warningColor");
        }
        return super.getColor(streamIdentifer);
    }

    public void connect(IProcess process, IConsole console) {
        AntStreamsProxy proxy = (AntStreamsProxy)process.getStreamsProxy();
        if (process instanceof AntProcess) {
            ((AntProcess)process).setConsole(console);
        }
        if (proxy != null) {
            console.connect(proxy.getDebugStreamMonitor(), "org.eclipse.ant.ui.ANT_DEBUG_STREAM");
            console.connect(proxy.getWarningStreamMonitor(), "org.eclipse.ant.ui.ANT_WARNING_STREAM");
            console.connect(proxy.getVerboseStreamMonitor(), "org.eclipse.ant.ui.ANT_VERBOSE_STREAM");
        }
        super.connect(process, console);
    }

    public boolean isReadOnly() {
        return true;
    }
}

