/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntTargetsTab;
import org.eclipse.ant.internal.ui.preferences.AntClasspathBlock;
import org.eclipse.ant.internal.ui.preferences.ClasspathModel;
import org.eclipse.ant.internal.ui.preferences.IAntBlockContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntClasspathTab
extends AbstractLaunchConfigurationTab
implements IAntBlockContainer {
    private ClasspathModel model;
    private AntClasspathBlock antClasspathBlock = new AntClasspathBlock(true);

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        top.setFont(font);
        this.setControl((Control)top);
        WorkbenchHelp.setHelp((Control)top, (String)"org.eclipse.ant.ui.ant_classpath_tab_context");
        this.antClasspathBlock.setContainer(this);
        this.antClasspathBlock.createContents(top);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String antHomeString = null;
        String defaultAntHome = AntCorePlugin.getPlugin().getPreferences().getAntHome();
        try {
            antHomeString = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_HOME", defaultAntHome);
        }
        catch (CoreException coreException) {}
        this.createClasspathModel(configuration, !antHomeString.equals(defaultAntHome));
        this.antClasspathBlock.setInput(this.model);
        this.antClasspathBlock.initializeAntHome(antHomeString, this.model.getAntHomeEntry() != null);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String dfltAntHome = AntCorePlugin.getPlugin().getPreferences().getDefaultAntHome();
        boolean defaultAntHome = this.antClasspathBlock.getAntHome().equals(dfltAntHome);
        if (defaultAntHome) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_HOME", null);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_HOME", this.antClasspathBlock.getAntHome());
        }
        String classpath = this.model.serializeClasspath(defaultAntHome);
        if (classpath.equals("G,UG")) {
            classpath = null;
        }
        if (classpath != null) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", classpath);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
        }
    }

    public String getName() {
        return AntLaunchConfigurationMessages.getString("AntClasspathTab.Classpath_6");
    }

    public Image getImage() {
        return this.antClasspathBlock.getClasspathImage();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (this.antClasspathBlock.isValidated()) {
            return this.getErrorMessage() == null;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean valid = true;
        if (this.antClasspathBlock.isAntHomeEnabled()) {
            valid = this.antClasspathBlock.validateAntHome();
        }
        if (valid) {
            valid = this.antClasspathBlock.validateToolsJAR();
            this.antClasspathBlock.setValidated();
        }
        if (valid) {
            return super.isValid(launchConfig);
        }
        return valid;
    }

    public void setMessage(String message) {
        super.setMessage(message);
    }

    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
    }

    public Button createPushButton(Composite parent, String buttonText) {
        return super.createPushButton(parent, buttonText, null);
    }

    public void update() {
        this.updateTargetsTab();
        this.updateLaunchConfigurationDialog();
    }

    private void updateTargetsTab() {
        ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationDialog().getTabs();
        int i = 0;
        while (i < tabs.length) {
            ILaunchConfigurationTab tab = tabs[i];
            if (tab instanceof AntTargetsTab) {
                ((AntTargetsTab)tab).setDirty(true);
                break;
            }
            ++i;
        }
    }

    private void createClasspathModel(ILaunchConfiguration configuration, boolean customAntHome) {
        String classpathString = null;
        try {
            classpathString = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_CUSTOM_CLASSPATH", null);
        }
        catch (CoreException coreException) {}
        if (classpathString == null) {
            this.model = new ClasspathModel();
            AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
            this.model.setAntHomeEntries(prefs.getAntHomeClasspathEntries());
            this.model.setGlobalEntries(prefs.getAdditionalClasspathEntries());
        } else {
            this.model = new ClasspathModel(classpathString, customAntHome);
        }
    }

    protected ClasspathModel getClasspathModel() {
        return this.model;
    }

    protected void setDirty(boolean dirty) {
        super.setDirty(dirty);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (this.isDirty()) {
            super.activated(workingCopy);
        }
    }
}

