/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathProvider;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;

public class AntClasspathProvider
implements IRuntimeClasspathProvider {
    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) {
        return new IRuntimeClasspathEntry[0];
    }

    public IRuntimeClasspathEntry[] resolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        ArrayList<URL> fullClasspath;
        boolean separateVM = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null) != null;
        URL[] antURLs = AntUtil.getCustomClasspath(configuration);
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        if (antURLs == null) {
            antURLs = separateVM ? prefs.getRemoteAntURLs() : prefs.getURLs();
        } else if (separateVM) {
            fullClasspath = new ArrayList<URL>(40);
            fullClasspath.addAll(Arrays.asList(antURLs));
            URL remote = prefs.getRemoteAntURL();
            if (remote != null) {
                fullClasspath.add(remote);
            }
            antURLs = fullClasspath.toArray(new URL[fullClasspath.size()]);
        } else {
            fullClasspath = new ArrayList(50);
            fullClasspath.addAll(Arrays.asList(antURLs));
            fullClasspath.addAll(Arrays.asList(prefs.getExtraClasspathURLs()));
            antURLs = fullClasspath.toArray(new URL[fullClasspath.size()]);
        }
        IVMInstall vm = JavaRuntime.computeVMInstall((ILaunchConfiguration)configuration);
        LibraryLocation[] libs = JavaRuntime.getLibraryLocations((IVMInstall)vm);
        IRuntimeClasspathEntry[] rtes = new IRuntimeClasspathEntry[libs.length + antURLs.length];
        int i = 0;
        while (i < libs.length) {
            IRuntimeClasspathEntry r = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)libs[i].getSystemLibraryPath());
            r.setSourceAttachmentPath(libs[i].getSystemLibrarySourcePath());
            r.setSourceAttachmentRootPath(libs[i].getPackageRootPath());
            r.setClasspathProperty(1);
            rtes[i] = r;
            ++i;
        }
        int j = 0;
        while (j < antURLs.length) {
            URL url = antURLs[j];
            Path path = new Path(url.getPath());
            rtes[i] = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path);
            ++i;
            ++j;
        }
        return rtes;
    }
}

