/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.tools;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ant.internal.ui.editor.tools.AntEditorToolsMessages;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TaskXMLFileMerger {
    public static String HTML_TASKS_DESCRIPTION_XML_FILE_NAME = "/tasks.xml";
    public static String HTML_XML_TAG_TASKS = "TASKS";
    public static String HTML_XML_TAG_TASK = "TASK";
    public static String HTML_XML_TAG_ATTRIBUTE = "ATTRIBUTE";
    public static String HTML_XML_ATTRIBUTE_NAME = "NAME";
    public static String HTML_XML_ATTRIBUTE_REQUIRED = "REQUIRED";
    public static String XDOC_TASKS_DESCRIPTION_XML_FILE_NAME = "/XDOCtasks.xml";
    public static String XDOC_XML_TAG_TASKS = "tasks";
    public static String XDOC_XML_TAG_TASK = "task";
    public static String XDOC_XML_TAG_NAME = "name";
    public static String XDOC_XML_TAG_STRUCTURE = "structure";
    public static String XDOC_XML_TAG_ATTRIBUTES = "attributes";
    public static String XDOC_XML_TAG_ATTRIBUTE = "attribute";
    public static String XDOC_XML_TAG_ELEMENTS = "elements";
    public static String XDOC_XML_TAG_ELEMENT = "element";
    public static String XDOC_XML_TAG_REQUIRED = "required";
    protected NodeList taskNodes_HTML = null;
    protected NodeList taskNodes_XDOC = null;
    public Document xdocXMLDocument = null;

    public TaskXMLFileMerger() {
        this.initialize();
    }

    private void initialize() {
        Document tmpDocument = null;
        tmpDocument = this.parseFile(HTML_TASKS_DESCRIPTION_XML_FILE_NAME);
        this.taskNodes_HTML = tmpDocument.getFirstChild().getChildNodes();
        tmpDocument = this.parseFile(XDOC_TASKS_DESCRIPTION_XML_FILE_NAME);
        this.taskNodes_XDOC = tmpDocument.getFirstChild().getChildNodes();
        this.xdocXMLDocument = tmpDocument;
    }

    public void runReplaceAttributeRequiredProcess() {
        int i = 0;
        while (i < this.taskNodes_XDOC.getLength()) {
            Node tmpTargetNode = this.taskNodes_XDOC.item(i);
            if (tmpTargetNode.getNodeType() == 1) {
                this.replaceAttributeRequiredInTaskNode(tmpTargetNode);
            }
            ++i;
        }
    }

    private void replaceAttributeRequiredInTaskNode(Node aTargetTaskNode) {
        String tmpTaskName = aTargetTaskNode.getAttributes().getNamedItem(XDOC_XML_TAG_NAME).getNodeValue();
        if (tmpTaskName != null) {
            Node tmpSourceNode = this.getTaskInHTMLGeneratedTaskListNamed(tmpTaskName);
            if (tmpSourceNode != null) {
                this.replaceAttributeRequiredInXMLTaskNodeWithAttributeRequiredInHTMLNode(aTargetTaskNode, tmpSourceNode);
            } else {
                System.out.println(MessageFormat.format(AntEditorToolsMessages.getString("TaskXMLFileMerger.No_Task"), tmpTaskName));
            }
        } else {
            System.out.println(MessageFormat.format(AntEditorToolsMessages.getString("TaskXMLFileMerger.No_TaskName"), aTargetTaskNode.toString()));
        }
    }

    private Node getTaskInHTMLGeneratedTaskListNamed(String aTaskName) {
        int i = 0;
        while (i < this.taskNodes_HTML.getLength()) {
            NamedNodeMap tmpMap;
            Node tmpNameNode;
            String tmpTagName;
            Node tmpTaskNode = this.taskNodes_HTML.item(i);
            if (tmpTaskNode.getNodeType() == 1 && (tmpTagName = tmpTaskNode.getNodeName()).equals(HTML_XML_TAG_TASK) && aTaskName.equals((tmpNameNode = (tmpMap = tmpTaskNode.getAttributes()).getNamedItem(HTML_XML_ATTRIBUTE_NAME)).getNodeValue())) {
                return tmpTaskNode;
            }
            ++i;
        }
        return null;
    }

    private void replaceAttributeRequiredInXMLTaskNodeWithAttributeRequiredInHTMLNode(Node aTargetTaskNode, Node aSourceTaskNode) {
        Node tmpTargetAttributesNode;
        Node tmpStructureNode = this.getChildNodeNamedWithTypeFromNode(XDOC_XML_TAG_STRUCTURE, (short)1, aTargetTaskNode);
        if (tmpStructureNode != null && (tmpTargetAttributesNode = this.getChildNodeNamedWithTypeFromNode(XDOC_XML_TAG_ATTRIBUTES, (short)1, tmpStructureNode)) != null) {
            Vector tmpTargetAttributesVector = this.getAttributeNodesFromXMLAttributesNode(tmpTargetAttributesNode);
            Vector tmpSourceAttributesVector = this.getAttributeNodesFromHTMLTaskNode(aSourceTaskNode);
            int i = 0;
            while (i < tmpTargetAttributesVector.size()) {
                Node tmpAttributeNode = (Node)tmpTargetAttributesVector.get(i);
                this.replaceAttributeRequiredInAttributeNodeWithValueFoundInNodeVector(tmpAttributeNode, tmpSourceAttributesVector);
                ++i;
            }
        }
    }

    private void replaceAttributeRequiredInAttributeNodeWithValueFoundInNodeVector(Node aTargetAttributeNode, Vector aSourceAttributeVector) {
        NamedNodeMap tmpTargetNamedNodeMap = aTargetAttributeNode.getAttributes();
        String tmpTargetAttributeName = tmpTargetNamedNodeMap.getNamedItem(XDOC_XML_TAG_NAME).getNodeValue();
        String tmpSourceAttributeName = null;
        String tmpSourceRequiredValue = null;
        int i = 0;
        while (i < aSourceAttributeVector.size()) {
            Node tmpSourceAttributeNode = (Node)aSourceAttributeVector.get(i);
            NamedNodeMap tmpSourceAttributeNamedNodeMap = tmpSourceAttributeNode.getAttributes();
            tmpSourceAttributeName = tmpSourceAttributeNamedNodeMap.getNamedItem(HTML_XML_ATTRIBUTE_NAME).getNodeValue();
            if (tmpTargetAttributeName.equals(tmpSourceAttributeName)) {
                tmpSourceRequiredValue = tmpSourceAttributeNamedNodeMap.getNamedItem(HTML_XML_ATTRIBUTE_REQUIRED).getNodeValue();
                tmpTargetNamedNodeMap.getNamedItem(XDOC_XML_TAG_REQUIRED).setNodeValue(tmpSourceRequiredValue);
            }
            ++i;
        }
    }

    private Vector getAttributeNodesFromXMLAttributesNode(Node anXMLAttributesNode) {
        Vector<Node> allAttributes = new Vector<Node>();
        NodeList tmpList = anXMLAttributesNode.getChildNodes();
        int i = 0;
        while (i < tmpList.getLength()) {
            Node tmpNode = tmpList.item(i);
            if (tmpNode.getNodeType() == 1 && XDOC_XML_TAG_ATTRIBUTE.equals(tmpNode.getNodeName())) {
                allAttributes.add(tmpNode);
            }
            ++i;
        }
        return allAttributes;
    }

    private Vector getAttributeNodesFromHTMLTaskNode(Node anHTTP_XML_TaskNode) {
        Vector<Node> tmpVector = new Vector<Node>();
        NodeList tmpList = anHTTP_XML_TaskNode.getChildNodes();
        int i = 0;
        while (i < tmpList.getLength()) {
            Node tmpNode = tmpList.item(i);
            if (tmpNode.getNodeType() == 1 && HTML_XML_TAG_ATTRIBUTE.equals(tmpNode.getNodeName())) {
                tmpVector.add(tmpNode);
            }
            ++i;
        }
        return tmpVector;
    }

    private Node getChildNodeNamedWithTypeFromNode(String aName, short aNodeType, Node aNode) {
        NodeList tmpNodeList = aNode.getChildNodes();
        int i = 0;
        while (i < tmpNodeList.getLength()) {
            Node tmpNode = tmpNodeList.item(i);
            if (tmpNode.getNodeType() == aNodeType && aName.equals(tmpNode.getNodeName())) {
                return tmpNode;
            }
            ++i;
        }
        return null;
    }

    private Document parseFile(String aFileName) {
        Document tempDocument = null;
        DocumentBuilderFactory tempFactory = DocumentBuilderFactory.newInstance();
        tempFactory.setIgnoringComments(true);
        tempFactory.setIgnoringElementContentWhitespace(true);
        tempFactory.setCoalescing(true);
        try {
            DocumentBuilder tempDocBuilder = tempFactory.newDocumentBuilder();
            URL tempURL = this.getClass().getResource(aFileName);
            InputSource tempInputSource = new InputSource(tempURL.toExternalForm());
            tempDocument = tempDocBuilder.parse(tempInputSource);
        }
        catch (ParserConfigurationException e) {
            AntUIPlugin.log(e);
        }
        catch (IOException ioException) {
            AntUIPlugin.log(ioException);
        }
        catch (SAXException saxException) {
            AntUIPlugin.log(saxException);
        }
        return tempDocument;
    }

    public void writeXMLDocumentToFile(String aFileName) {
    }

    public static void main(String[] args) {
        TaskXMLFileMerger tmpTaskXMLFileMerger = new TaskXMLFileMerger();
        tmpTaskXMLFileMerger.runReplaceAttributeRequiredProcess();
        tmpTaskXMLFileMerger.writeXMLDocumentToFile("src\\anttasks_1.5b.xml");
    }
}

