/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.outline;

import org.eclipse.ant.internal.ui.editor.outline.IProblem;
import org.eclipse.ant.internal.ui.editor.outline.IProblemRequestor;
import org.eclipse.ant.internal.ui.editor.xml.XmlElement;
import org.eclipse.jface.text.Region;
import org.xml.sax.SAXParseException;

public class XEErrorHandler
implements IProblemRequestor {
    private static final int SEVERTITY_WARNING = 0;
    private static final int SEVERTITY_ERROR = 1;
    private static final int SEVERTITY_FATAL_ERROR = 2;
    private IProblemRequestor fProblemRequestor;

    public XEErrorHandler(IProblemRequestor problemRequestor) {
        this.fProblemRequestor = problemRequestor;
    }

    public void acceptProblem(IProblem problem) {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.acceptProblem(problem);
        }
    }

    public void beginReporting() {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.beginReporting();
        }
    }

    public void endReporting() {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.endReporting();
        }
    }

    protected IProblem createProblem(SAXParseException exception, XmlElement element, int severity) {
        return new XMLProblem(exception.toString(), exception.getMessage(), severity, element.getOffset(), element.getLength());
    }

    protected void notifyProblemRequestor(SAXParseException exception, XmlElement element, int severity) {
        IProblem problem = this.createProblem(exception, element, severity);
        this.acceptProblem(problem);
    }

    public void warning(SAXParseException exception, XmlElement element) {
        this.notifyProblemRequestor(exception, element, 0);
    }

    public void error(SAXParseException exception, XmlElement element) {
        this.notifyProblemRequestor(exception, element, 1);
    }

    public void fatalError(SAXParseException exception, XmlElement element) {
        this.notifyProblemRequestor(exception, element, 2);
    }

    protected class XMLProblem
    extends Region
    implements IProblem {
        private String fCode;
        private String fMessage;
        private int fSeverity;

        public XMLProblem(String code, String message, int severity, int offset, int length) {
            super(offset, length);
            this.fCode = code;
            this.fMessage = message;
            this.fSeverity = severity;
        }

        public String getCode() {
            return this.fCode;
        }

        public String getMessage() {
            return this.fMessage;
        }

        public boolean isError() {
            return this.fSeverity == 1 || this.fSeverity == 2;
        }

        public boolean isWarning() {
            return this.fSeverity == 0;
        }
    }
}

