/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.outline;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Stack;
import org.eclipse.ant.internal.ui.editor.AntEditorException;
import org.eclipse.ant.internal.ui.editor.outline.AntOutlineMessages;
import org.eclipse.ant.internal.ui.editor.outline.ILocationProvider;
import org.eclipse.ant.internal.ui.editor.outline.IProblemRequestor;
import org.eclipse.ant.internal.ui.editor.outline.XEErrorHandler;
import org.eclipse.ant.internal.ui.editor.xml.XmlAttribute;
import org.eclipse.ant.internal.ui.editor.xml.XmlElement;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class OutlinePreparingHandler
extends DefaultHandler
implements LexicalHandler {
    private Locator locator;
    private Stack stillOpenElements = new Stack();
    private XmlElement rootElement;
    private File mainFile;
    private XEErrorHandler errorHandler;
    private IDocument document;
    private FindReplaceDocumentAdapter findReplaceAdapter;
    private boolean isTopLevelRootExternal;
    private boolean isInDTD;
    private int lastExternalEntityOffset = -1;

    public OutlinePreparingHandler(ILocationProvider locationProvider) {
        IPath location = locationProvider.getLocation();
        if (location != null) {
            this.mainFile = location.toFile();
        }
    }

    public void startElement(String aUri, String aLocalName, String aQualifiedName, Attributes anAttributes) throws SAXException {
        XmlElement tempElement = this.createXmlElement(aLocalName, aQualifiedName, anAttributes);
        if (this.rootElement == null) {
            this.rootElement = tempElement;
        } else {
            XmlElement tempLastOpenedElement = (XmlElement)this.stillOpenElements.peek();
            tempLastOpenedElement.addChildNode(tempElement);
            tempElement.setExternal(this.isExternal());
        }
        this.computeStartLocation(tempElement);
        this.stillOpenElements.push(tempElement);
        super.startElement(aUri, aLocalName, aQualifiedName, anAttributes);
    }

    private XmlElement createXmlElement(String aLocalName, String aQualifiedName, Attributes attributes) {
        String tempElementName = null;
        XmlElement tempElement = null;
        if (aLocalName.length() > 0) {
            tempElementName = aLocalName;
        } else if (aQualifiedName.length() > 0) {
            tempElementName = aQualifiedName;
        } else {
            throw new AntEditorException(AntOutlineMessages.getString("OutlinePreparingHandler.Error_Name"));
        }
        String elementType = null;
        if (tempElementName.equalsIgnoreCase("target")) {
            elementType = "target";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("name");
                    if (tempXmlAttr != null) {
                        XmlAttribute defaultTarget;
                        StringBuffer nodeName = new StringBuffer(tempXmlAttr.getValue());
                        XmlElement parentNode = this.getParentNode();
                        XmlAttribute type = parentNode != null ? parentNode.getAttributeNamed("type") : null;
                        while (!(parentNode == null || type != null && type.getValue().equals("project"))) {
                            if ((parentNode = parentNode.getParentNode()) == null) continue;
                            type = parentNode.getAttributeNamed("type");
                        }
                        if (parentNode != null && (defaultTarget = parentNode.getAttributeNamed("default")) != null && defaultTarget.getValue().equals(tempXmlAttr.getValue())) {
                            nodeName.append(AntOutlineMessages.getString("OutlinePreparingHandler._[default]_2"));
                        }
                        return nodeName.toString();
                    }
                    return super.getDisplayName();
                }
            };
        } else if (tempElementName.equalsIgnoreCase("project")) {
            elementType = "project";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("name");
                    if (tempXmlAttr != null) {
                        return tempXmlAttr.getValue();
                    }
                    return super.getDisplayName();
                }
            };
        } else if (tempElementName.equalsIgnoreCase("property")) {
            elementType = "property";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("name");
                    if (tempXmlAttr != null) {
                        return tempXmlAttr.getValue();
                    }
                    tempXmlAttr = this.getAttributeNamed("file");
                    if (tempXmlAttr != null) {
                        return "file=" + tempXmlAttr.getValue();
                    }
                    tempXmlAttr = this.getAttributeNamed("resource");
                    if (tempXmlAttr != null) {
                        return "resource=" + tempXmlAttr.getValue();
                    }
                    tempXmlAttr = this.getAttributeNamed("environment");
                    if (tempXmlAttr != null) {
                        return "environment=" + tempXmlAttr.getValue();
                    }
                    return super.getDisplayName();
                }
            };
        } else if (tempElementName.equalsIgnoreCase("antcall")) {
            elementType = "antcall";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = "antcall ";
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("target");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("mkdir")) {
            elementType = "mkdir";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = "mkdir ";
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("dir");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("copy")) {
            elementType = "copy";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = "copy ";
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("file");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("tar") || tempElementName.equalsIgnoreCase("jar") || tempElementName.equalsIgnoreCase("war") || tempElementName.equalsIgnoreCase("zip")) {
            elementType = "archive";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = super.getDisplayName();
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("destfile");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + " " + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("untar") || tempElementName.equalsIgnoreCase("unjar") || tempElementName.equalsIgnoreCase("unwar") || tempElementName.equalsIgnoreCase("gunzip") || tempElementName.equalsIgnoreCase("bunzip2") || tempElementName.equalsIgnoreCase("unzip")) {
            elementType = "decompress";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = super.getDisplayName();
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("src");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + " " + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("gzip") || tempElementName.equalsIgnoreCase("bzip2")) {
            elementType = "compress";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = super.getDisplayName();
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("zipfile");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + " " + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("exec")) {
            elementType = "exec";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = "exec ";
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("command");
                    if (tempXmlAttr != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    if ((tempXmlAttr = this.getAttributeNamed("executable")) != null) {
                        tempDisplayName = String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else if (tempElementName.equalsIgnoreCase("delete")) {
            elementType = "delete";
            tempElement = new XmlElement(tempElementName){

                public String getDisplayName() {
                    String tempDisplayName = "delete ";
                    XmlAttribute tempXmlAttr = this.getAttributeNamed("file");
                    if (tempXmlAttr != null) {
                        return String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    tempXmlAttr = this.getAttributeNamed("dir");
                    if (tempXmlAttr != null) {
                        return String.valueOf(tempDisplayName) + tempXmlAttr.getValue();
                    }
                    return tempDisplayName;
                }
            };
        } else {
            elementType = "unknown";
            tempElement = new XmlElement(tempElementName);
        }
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                String tempAttrName = attributes.getLocalName(i);
                if (tempAttrName == null || tempAttrName.length() == 0) {
                    tempAttrName = attributes.getQName(i);
                }
                String tempAttrValue = attributes.getValue(i);
                tempElement.addAttribute(new XmlAttribute(tempAttrName, tempAttrValue));
                ++i;
            }
        }
        tempElement.addAttribute(new XmlAttribute("type", elementType));
        tempElement.setFilePath(this.locator.getSystemId());
        return tempElement;
    }

    public void endElement(String aUri, String aLocalName, String aQualifiedName) {
        String tempTagName = aLocalName.length() > 0 ? aLocalName : aQualifiedName;
        XmlElement tempLastStillOpenElement = (XmlElement)this.stillOpenElements.peek();
        if (tempLastStillOpenElement != null && tempLastStillOpenElement.getName().equalsIgnoreCase(tempTagName)) {
            this.computeEndLocation(tempLastStillOpenElement);
            this.stillOpenElements.pop();
        }
    }

    public void setDocumentLocator(Locator aLocator) {
        this.locator = aLocator;
        super.setDocumentLocator(aLocator);
    }

    public XmlElement getRootElement() {
        return this.rootElement;
    }

    public void warning(SAXParseException anException) {
        if (this.errorHandler != null) {
            XmlElement element = this.createProblemElement(anException);
            this.errorHandler.warning(anException, element);
        }
    }

    public void error(SAXParseException anException) {
        this.generateErrorElementHierarchy();
        if (this.errorHandler != null) {
            XmlElement errorElement = this.createProblemElement(anException);
            this.errorHandler.error(anException, errorElement);
        }
    }

    public void fatalError(SAXParseException anException) {
        this.generateErrorElementHierarchy();
        if (this.errorHandler != null) {
            XmlElement errorElement = this.createProblemElement(anException);
            this.errorHandler.fatalError(anException, errorElement);
        }
    }

    private XmlElement createProblemElement(SAXParseException exception) {
        int lineNumber = exception.getLineNumber();
        StringBuffer message = new StringBuffer(exception.getMessage());
        if (lineNumber != -1) {
            message.append(String.valueOf(AntOutlineMessages.getString("OutlinePreparingHandler._line___2")) + lineNumber);
        }
        XmlElement errorNode = new XmlElement(message.toString());
        errorNode.setFilePath(exception.getSystemId());
        errorNode.setExternal(this.isExternal());
        errorNode.setIsErrorNode(true);
        this.computeErrorLocation(errorNode, exception);
        return errorNode;
    }

    private void generateErrorElementHierarchy() {
        XmlElement openElement = this.getLastOpenElement();
        while (openElement != null) {
            openElement.setIsErrorNode(true);
            openElement = openElement.getParentNode();
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        IFile file;
        int index = systemId.indexOf(58);
        if (index > 0) {
            systemId = systemId.substring(index + 1, systemId.length());
        }
        if ((file = AntUtil.getFileForLocation(systemId, this.mainFile.getParentFile())) == null) {
            return null;
        }
        File resolvedFile = file.getLocation().toFile();
        try {
            InputSource inputSource = new InputSource(new FileReader(resolvedFile));
            inputSource.setSystemId(resolvedFile.getAbsolutePath());
            return inputSource;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public void comment(char[] ch, int start, int length) {
        if (this.isInDTD || this.isExternal()) {
            return;
        }
        try {
            this.lastExternalEntityOffset = this.getOffset(this.locator.getLineNumber(), this.locator.getColumnNumber()) - 1;
        }
        catch (BadLocationException e) {
            AntUIPlugin.log(e);
        }
    }

    public void endCDATA() {
    }

    public void endDTD() {
        this.isInDTD = false;
    }

    public void endEntity(String name) {
        boolean isNestedRootExternal;
        if (this.isInDTD) {
            return;
        }
        XmlElement element = this.getLastOpenElement();
        boolean bl = isNestedRootExternal = element == null || element.getParentNode() == null || element.getParentNode().isExternal();
        if (!isNestedRootExternal) {
            this.isTopLevelRootExternal = true;
        }
        this.endElement(null, name, "");
        if (!isNestedRootExternal) {
            this.isTopLevelRootExternal = false;
        }
    }

    public void startCDATA() {
    }

    public void startDTD(String name, String publicId, String systemId) {
        this.isInDTD = true;
    }

    public void startEntity(String name) throws SAXException {
        if (this.isInDTD) {
            return;
        }
        boolean isNestedRootExternal = this.isExternal();
        if (!isNestedRootExternal) {
            this.isTopLevelRootExternal = true;
        }
        this.startElement(null, name, "", null);
        XmlElement external = (XmlElement)this.stillOpenElements.peek();
        external.setExternal(true);
        external.setRootExternal(true);
        external.getAttributes().removeAll(external.getAttributes());
        external.addAttribute(new XmlAttribute("type", "external"));
        if (!isNestedRootExternal) {
            this.isTopLevelRootExternal = false;
        }
    }

    private void computeStartLocation(XmlElement element) {
        if (element.isExternal()) {
            return;
        }
        try {
            int offset;
            if (this.isTopLevelRootExternal) {
                StringBuffer source = new StringBuffer();
                source.append('&');
                source.append(element.getName());
                source.append(';');
                IRegion result = this.findReplaceAdapter.search(this.lastExternalEntityOffset + 1, source.toString(), true, true, false, false);
                this.lastExternalEntityOffset = offset = result.getOffset();
            } else {
                int locatorLine = this.locator.getLineNumber();
                int locatorColumn = this.locator.getColumnNumber();
                String prefix = "<";
                if (locatorColumn <= 0) {
                    offset = this.getOffset(locatorLine, this.getLastCharColumn(locatorLine));
                    IRegion result = this.findReplaceAdapter.search(offset, String.valueOf(prefix) + element.getName(), false, false, false, false);
                    this.lastExternalEntityOffset = offset = result.getOffset();
                } else {
                    offset = this.getOffset(locatorLine, locatorColumn);
                    this.lastExternalEntityOffset = offset - 1;
                    IRegion result = this.findReplaceAdapter.search(offset - 1, prefix, false, true, false, false);
                    offset = result.getOffset();
                }
            }
            element.setOffset(offset);
        }
        catch (BadLocationException badLocationException) {}
    }

    private void computeEndLocation(XmlElement element) {
        if (element.isExternal() && !this.isTopLevelRootExternal) {
            return;
        }
        try {
            int length;
            if (this.isTopLevelRootExternal) {
                length = element.getName().length() + 2;
            } else {
                int lineOffset;
                IRegion result;
                int offset;
                int line = this.locator.getLineNumber();
                int column = this.locator.getColumnNumber();
                offset = column <= 0 ? ((offset = (result = this.findReplaceAdapter.search(lineOffset = this.getOffset(line, 1), ">", true, true, false, false)) == null ? -1 : result.getOffset()) < 0 || this.getLine(offset) != line ? lineOffset : ++offset) : this.getOffset(line, column);
                length = offset - element.getOffset();
                this.lastExternalEntityOffset = offset - 1;
            }
            element.setLength(length);
        }
        catch (BadLocationException badLocationException) {}
    }

    private void computeErrorLocation(XmlElement element, SAXParseException exception) {
        if (element.isExternal()) {
            return;
        }
        try {
            int endColumn;
            int line = exception.getLineNumber();
            int startColumn = exception.getColumnNumber();
            if (line <= 0) {
                line = this.locator.getLineNumber();
                startColumn = this.locator.getColumnNumber();
                if (line <= 0) {
                    line = 1;
                    startColumn = 1;
                }
            }
            if (startColumn <= 0) {
                startColumn = 1;
                endColumn = this.getLastCharColumn(line) + 1;
            } else {
                if (startColumn > 1) {
                    --startColumn;
                }
                endColumn = startColumn;
                if (startColumn <= this.getLastCharColumn(line)) {
                    ++endColumn;
                }
            }
            int offset = this.getOffset(line, startColumn);
            element.setOffset(offset);
            element.setLength(endColumn - startColumn);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void fixEndLocations() {
        this.fixEndLocations(null);
    }

    public void fixEndLocations(SAXParseException e) {
        XmlElement lastOpenElement = this.getLastOpenElement();
        if (lastOpenElement == null) {
            return;
        }
        boolean recoverFromExternal = lastOpenElement.isExternal();
        while (lastOpenElement.isExternal() && (!lastOpenElement.isRootExternal() || lastOpenElement.getParentNode() != null && lastOpenElement.getParentNode().isExternal())) {
            this.stillOpenElements.pop();
            lastOpenElement = this.getLastOpenElement();
        }
        try {
            int offset;
            if (recoverFromExternal) {
                XmlElement element = (XmlElement)this.stillOpenElements.peek();
                int length = element.getName().length() + 2;
                offset = element.getOffset() + length;
            } else if (e == null) {
                XmlElement element = (XmlElement)this.stillOpenElements.peek();
                offset = element.getOffset();
            } else {
                int line = e.getLineNumber();
                int column = e.getColumnNumber();
                if (line <= 0) {
                    line = 1;
                }
                if (column <= 0) {
                    column = 1;
                }
                offset = this.getOffset(line, column);
            }
            while (!this.stillOpenElements.empty()) {
                XmlElement element = (XmlElement)this.stillOpenElements.pop();
                element.setLength(offset - element.getOffset());
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public XmlElement getLastOpenElement() {
        if (!this.stillOpenElements.empty()) {
            return (XmlElement)this.stillOpenElements.peek();
        }
        return null;
    }

    private boolean isExternal() {
        if (!this.stillOpenElements.empty()) {
            return ((XmlElement)this.stillOpenElements.peek()).isExternal();
        }
        return false;
    }

    private int getLastCharColumn(int line) throws BadLocationException {
        String lineDelimiter = this.document.getLineDelimiter(line - 1);
        int lineDelimiterLength = lineDelimiter != null ? lineDelimiter.length() : 0;
        return this.document.getLineLength(line - 1) - lineDelimiterLength;
    }

    private int getOffset(int line, int column) throws BadLocationException {
        return this.document.getLineOffset(line - 1) + column - 1;
    }

    private int getLine(int offset) throws BadLocationException {
        return this.document.getLineOfOffset(offset) + 1;
    }

    public void begin() {
        if (this.errorHandler != null) {
            this.errorHandler.beginReporting();
        }
    }

    public void end() {
        if (this.errorHandler != null) {
            this.errorHandler.endReporting();
        }
    }

    public void setDocument(IDocument document) {
        this.document = document;
        this.findReplaceAdapter = new FindReplaceDocumentAdapter(document);
    }

    public void setProblemRequestor(IProblemRequestor requestor) {
        this.errorHandler = requestor != null ? new XEErrorHandler(requestor) : null;
    }
}

