/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.outline;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.ant.internal.ui.editor.outline.DocumentModelChangeEvent;
import org.eclipse.ant.internal.ui.editor.outline.ILocationProvider;
import org.eclipse.ant.internal.ui.editor.outline.IProblemRequestor;
import org.eclipse.ant.internal.ui.editor.outline.OutlinePreparingHandler;
import org.eclipse.ant.internal.ui.editor.outline.XMLCore;
import org.eclipse.ant.internal.ui.editor.xml.XmlElement;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AntModel {
    private XMLCore fCore;
    private IDocument fDocument;
    private IProblemRequestor fProblemRequestor;
    private ILocationProvider fLocationProvider;
    private XmlElement[] fRootElements = new XmlElement[0];
    private Object fRootElementLock = new Object();
    private final Object fDirtyLock = new Object();
    private boolean fIsDirty = true;
    private IDocumentListener fListener;

    public AntModel(XMLCore core, IDocument document, IProblemRequestor problemRequestor, ILocationProvider locationProvider) {
        this.fCore = core;
        this.fDocument = document;
        this.fProblemRequestor = problemRequestor;
        this.fLocationProvider = locationProvider;
    }

    public void install() {
        this.fListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
                Object object = AntModel.this.fDirtyLock;
                synchronized (object) {
                    AntModel.this.fIsDirty = true;
                }
            }

            public void documentChanged(DocumentEvent event) {
            }
        };
        this.fDocument.addDocumentListener(this.fListener);
        this.reconcile();
    }

    public void dispose() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fListener);
        }
        AntModel antModel = this;
        synchronized (antModel) {
            this.fDocument = null;
            this.fCore = null;
        }
    }

    public void reconcile() {
        Object object = this.fDirtyLock;
        synchronized (object) {
            if (!this.fIsDirty) {
                return;
            }
            this.fIsDirty = false;
        }
        object = this;
        synchronized (object) {
            XmlElement rootElement;
            if (this.fCore == null) {
                return;
            }
            XmlElement[] rootElements = this.fDocument == null ? new XmlElement[]{} : ((rootElement = this.parseDocument(this.fDocument)) == null ? new XmlElement[]{} : new XmlElement[]{rootElement});
            this.setRootElements(rootElements);
            this.fCore.notifyDocumentModelListeners(new DocumentModelChangeEvent(this));
        }
    }

    private void setRootElements(XmlElement[] rootElements) {
        Object object = this.fRootElementLock;
        synchronized (object) {
            this.fRootElements = rootElements;
        }
    }

    public XmlElement[] getRootElements() {
        Object object = this.fRootElementLock;
        synchronized (object) {
            return this.fRootElements;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XmlElement parseDocument(IDocument input) {
        SAXParser parser = this.getSAXParser();
        if (parser == null) {
            return null;
        }
        OutlinePreparingHandler handler = new OutlinePreparingHandler(this.fLocationProvider);
        handler.setProblemRequestor(this.fProblemRequestor);
        handler.setDocument(input);
        try {
            try {
                handler.begin();
                String wholeDocString = input.get();
                InputSource inputSource = new InputSource(new StringReader(wholeDocString));
                IPath location = this.fLocationProvider.getLocation();
                if (location != null) {
                    inputSource.setSystemId(location.toOSString());
                }
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                parser.parse(inputSource, (DefaultHandler)handler);
            }
            catch (SAXParseException e) {
                handler.fixEndLocations(e);
            }
            catch (SAXException e) {
                AntUIPlugin.log(e);
                XmlElement xmlElement = null;
                Object var7_10 = null;
                handler.end();
                return xmlElement;
            }
            catch (IOException iOException) {
                handler.fixEndLocations();
                this.generateExceptionOutline(handler.getLastOpenElement());
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            handler.end();
            throw throwable;
        }
        {
            Object var7_12 = null;
            handler.end();
            return handler.getRootElement();
        }
    }

    private SAXParser getSAXParser() {
        SAXParser parser = null;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            AntUIPlugin.log(e);
        }
        catch (SAXException e) {
            AntUIPlugin.log(e);
        }
        return parser;
    }

    private void generateExceptionOutline(XmlElement openElement) {
        while (openElement != null) {
            openElement.setIsErrorNode(true);
            openElement = openElement.getParentNode();
        }
    }

    public ILocationProvider getLocationProvider() {
        return this.fLocationProvider;
    }
}

