/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TaskDescriptionProvider {
    public static String TASKS_DESCRIPTION_XML_FILE_NAME = "/anttasks_1.5b.xml";
    public static String XML_TAG_TASKS = "tasks";
    public static String XML_TAG_TASK = "task";
    public static String XML_TAG_ELEMENTS = "elements";
    public static String XML_TAG_ATTRIBUTE = "attribute";
    public static String XML_TAG_ATTRIBUTES = "attributes";
    public static String XML_TAG_ELEMENT = "element";
    public static String XML_TAG_STRUCTURE = "structure";
    public static String XML_TAG_DESCRIPTION = "short-description";
    public static String XML_ATTRIBUTE_NAME = "name";
    public static String XML_ATTRIBUTE_REQUIRED = "required";
    protected Map taskNodes = new HashMap();

    public TaskDescriptionProvider() {
        this.initialize();
    }

    protected void initialize() {
        Document tempDocument = this.parseFile(TASKS_DESCRIPTION_XML_FILE_NAME);
        Element tempRootNode = tempDocument.getDocumentElement();
        NodeList tempChildNodes = tempRootNode.getChildNodes();
        int i = 0;
        while (i < tempChildNodes.getLength()) {
            String tempTaskName;
            NamedNodeMap tempAttributes;
            Node tempAttributeNode;
            String tempTagName;
            Node tempNode = tempChildNodes.item(i);
            if (tempNode.getNodeType() == 1 && (tempTagName = tempNode.getNodeName()).equals(XML_TAG_TASK) && (tempAttributeNode = (tempAttributes = tempNode.getAttributes()).getNamedItem(XML_ATTRIBUTE_NAME)) != null && (tempTaskName = tempAttributeNode.getNodeValue()) != null) {
                this.taskNodes.put(tempTaskName, tempNode);
            }
            ++i;
        }
    }

    protected Document parseFile(String aFileName) {
        Document tempDocument = null;
        DocumentBuilderFactory tempFactory = DocumentBuilderFactory.newInstance();
        tempFactory.setIgnoringComments(true);
        tempFactory.setIgnoringElementContentWhitespace(true);
        tempFactory.setCoalescing(true);
        try {
            DocumentBuilder tempDocBuilder = tempFactory.newDocumentBuilder();
            URL tempURL = this.getClass().getResource(aFileName);
            InputSource tempInputSource = new InputSource(tempURL.toExternalForm());
            tempDocument = tempDocBuilder.parse(tempInputSource);
        }
        catch (ParserConfigurationException e) {
            AntUIPlugin.log(e);
        }
        catch (IOException ioException) {
            AntUIPlugin.log(ioException);
        }
        catch (SAXException saxException) {
            AntUIPlugin.log(saxException);
        }
        return tempDocument;
    }

    public String getDescriptionForTask(String aTaskName) {
        Element tempTaskElement = (Element)this.taskNodes.get(aTaskName);
        if (tempTaskElement != null) {
            return this.getDescriptionOfNode(tempTaskElement);
        }
        return null;
    }

    protected String getDescriptionOfNode(Node aNode) {
        NodeList tempChildNodes = aNode.getChildNodes();
        int i = 0;
        while (i < tempChildNodes.getLength()) {
            Node tempNode = tempChildNodes.item(i);
            if (tempNode instanceof Element && XML_TAG_DESCRIPTION.equals(tempNode.getNodeName())) {
                Element tempDescriptionElement = (Element)tempNode;
                Node tempChildNode = tempDescriptionElement.getFirstChild();
                if (!(tempChildNode instanceof Text)) break;
                return ((Text)tempChildNode).getData();
            }
            ++i;
        }
        return null;
    }

    protected String getRequiredOfNode(Node aNode) {
        String tmpNodeName = aNode.getNodeName();
        String tmpRequiredValue = null;
        if (aNode.getNodeType() == 1 && (XML_TAG_ATTRIBUTE.equals(tmpNodeName) || XML_TAG_ELEMENT.equals(tmpNodeName))) {
            tmpRequiredValue = aNode.getAttributes().getNamedItem(XML_ATTRIBUTE_REQUIRED).getNodeValue();
        }
        if (tmpRequiredValue == null || tmpRequiredValue.equals("NOTDEFINED")) {
            return "";
        }
        return tmpRequiredValue;
    }

    public String getDescriptionForTaskAttribute(String aTaskName, String anAttributeName) {
        String tmpDescription = null;
        Node tmpAttributesNode = this.getAttributesNode(aTaskName);
        if (tmpAttributesNode != null && (tmpDescription = this.getDescriptionForNodeNamedWithNameInNodeList(XML_TAG_ATTRIBUTE, anAttributeName, tmpAttributesNode.getChildNodes())) != null) {
            return tmpDescription;
        }
        tmpAttributesNode = this.getElementsNode(aTaskName);
        if (tmpAttributesNode != null) {
            tmpDescription = this.getDescriptionForNodeNamedWithNameInNodeList(XML_TAG_ELEMENT, anAttributeName, tmpAttributesNode.getChildNodes());
            return tmpDescription;
        }
        return null;
    }

    public String getRequiredAttributeForTaskAttribute(String aTaskName, String anAttributeName) {
        String tmpRequired = null;
        Node tmpAttributesNode = this.getAttributesNode(aTaskName);
        if (tmpAttributesNode != null && (tmpRequired = this.getRequiredForNodeNamedWithNameInNodeList(XML_TAG_ATTRIBUTE, anAttributeName, tmpAttributesNode.getChildNodes())) != null) {
            return tmpRequired;
        }
        tmpAttributesNode = this.getElementsNode(aTaskName);
        if (tmpAttributesNode != null) {
            tmpRequired = this.getDescriptionForNodeNamedWithNameInNodeList(XML_TAG_ELEMENT, anAttributeName, tmpAttributesNode.getChildNodes());
            return tmpRequired;
        }
        return null;
    }

    protected Node getElementsNode(String aTaskName) {
        Node tmpStructureNode = this.getStructureNode(aTaskName);
        if (tmpStructureNode != null) {
            return this.getChildNodeNamedOfTypeFromNode(XML_TAG_ELEMENTS, (short)1, tmpStructureNode);
        }
        return null;
    }

    protected Node getAttributesNode(String aTaskName) {
        Node tmpStructureNode = this.getStructureNode(aTaskName);
        if (tmpStructureNode != null) {
            return this.getChildNodeNamedOfTypeFromNode(XML_TAG_ATTRIBUTES, (short)1, tmpStructureNode);
        }
        return null;
    }

    protected Node getStructureNode(String aTaskName) {
        Element tempTaskElement = (Element)this.taskNodes.get(aTaskName);
        if (tempTaskElement != null) {
            Node tmpStructureNode = this.getChildNodeNamedOfTypeFromNode(XML_TAG_STRUCTURE, (short)1, tempTaskElement);
            return tmpStructureNode;
        }
        return null;
    }

    protected String getDescriptionForNodeNamedWithNameInNodeList(String aNodeName, String anAttributeName, NodeList anAttributesNodeList) {
        int i = 0;
        while (i < anAttributesNodeList.getLength()) {
            Node tempNode = anAttributesNodeList.item(i);
            if (tempNode.getNodeType() == 1 && aNodeName.equals(tempNode.getNodeName()) && anAttributeName.equals(this.getTaskAttributeName(tempNode))) {
                return this.getDescriptionOfNode(tempNode);
            }
            ++i;
        }
        return null;
    }

    public String getTaskAttributeName(Node aTaskAttributeNode) {
        NamedNodeMap tmpNamedNodeMap = aTaskAttributeNode.getAttributes();
        return tmpNamedNodeMap.getNamedItem(XML_ATTRIBUTE_NAME).getNodeValue();
    }

    protected Node getChildNodeNamedOfTypeFromNode(String aNodeName, short aNodeType, Node aParentNode) {
        NodeList tmpNodeList = aParentNode.getChildNodes();
        int i = 0;
        while (i < tmpNodeList.getLength()) {
            Node tmpNode = tmpNodeList.item(i);
            if (tmpNode.getNodeType() == aNodeType && aNodeName.equals(tmpNode.getNodeName())) {
                return tmpNode;
            }
            ++i;
        }
        return null;
    }

    protected String getRequiredForNodeNamedWithNameInNodeList(String aNodeName, String anAttributeName, NodeList anAttributesNodeList) {
        int i = 0;
        while (i < anAttributesNodeList.getLength()) {
            Node tempNode = anAttributesNodeList.item(i);
            if (tempNode.getNodeType() == 1 && aNodeName.equals(tempNode.getNodeName()) && anAttributeName.equals(this.getTaskAttributeName(tempNode))) {
                return this.getRequiredOfNode(tempNode);
            }
            ++i;
        }
        return null;
    }
}

