/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import java.io.File;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ant.internal.ui.editor.AntEditorException;
import org.eclipse.ant.internal.ui.editor.AntEditorMessages;
import org.eclipse.ant.internal.ui.editor.AntEditorSaxDefaultHandler;
import org.eclipse.jface.text.IDocument;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class EnclosingTargetSearchingHandler
extends AntEditorSaxDefaultHandler {
    protected boolean enclosingTargetElementDetermined;

    public EnclosingTargetSearchingHandler(IDocument document, File mainFileContainer, int cursorRow, int cursorColumn) throws ParserConfigurationException {
        super(document, mainFileContainer, cursorRow, cursorColumn);
    }

    public void endElement(String aUri, String aLocalName, String aQualifiedName) {
        Element lastStillOpenElement;
        String tagName;
        if (this.parsingFinished) {
            return;
        }
        boolean parentKnown = this.checkForParentElement();
        String string = tagName = aLocalName.length() > 0 ? aLocalName : aQualifiedName;
        if (tagName.equals("target") && !this.stillOpenElements.isEmpty() && (lastStillOpenElement = (Element)this.stillOpenElements.peek()) != null && lastStillOpenElement.getTagName().equals(tagName)) {
            this.stillOpenElements.pop();
            if (!this.stillOpenElements.empty()) {
                Element secondLastStillOpenElement = (Element)this.stillOpenElements.peek();
                secondLastStillOpenElement.appendChild(lastStillOpenElement);
            }
            if (parentKnown && this.parentElement != null && this.parentElement.getTagName().equals(tagName)) {
                this.parsingFinished = true;
            }
        }
    }

    public void startElement(String aUri, String aLocalName, String aQualifiedName, Attributes anAttributes) {
        String tagName;
        if (this.parsingFinished) {
            return;
        }
        this.checkForParentElement();
        String string = tagName = aLocalName.length() > 0 ? aLocalName : aQualifiedName;
        if (tagName == null || tagName.length() == 0) {
            throw new AntEditorException(AntEditorMessages.getString("EnclosingTargetSearchingHandler.Error_parsing"));
        }
        if (tagName.equals("target")) {
            Element element = this.document.createElement(tagName);
            String targetName = anAttributes.getValue("name");
            if (targetName != null && targetName.length() > 0) {
                element.setAttribute("name", targetName);
            }
            this.stillOpenElements.push(element);
        }
    }

    protected boolean checkForParentElement() {
        if (this.parentElement == null && !this.enclosingTargetElementDetermined) {
            if (this.locator != null) {
                int lineNr = this.locator.getLineNumber() - 1;
                int columnNr = this.locator.getColumnNumber() - 1;
                if (lineNr > this.rowOfCursorPosition || lineNr == this.rowOfCursorPosition && columnNr > this.columnOfCursorPosition) {
                    this.determineEnclosingTargetTaskElement();
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected void determineEnclosingTargetTaskElement() {
        while (this.parentElement == null && !this.stillOpenElements.empty()) {
            Element stillOpen = (Element)this.stillOpenElements.pop();
            if (!stillOpen.getTagName().equals("target")) continue;
            this.parentElement = stillOpen;
        }
        this.enclosingTargetElementDetermined = true;
    }

    public Element getParentElement(boolean guessParent) {
        if (this.enclosingTargetElementDetermined) {
            return this.parentElement;
        }
        if (guessParent && !this.stillOpenElements.empty()) {
            this.determineEnclosingTargetTaskElement();
            return this.parentElement;
        }
        return null;
    }
}

