/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.AntEditorCompletionProcessor;
import org.eclipse.ant.internal.ui.editor.derived.HTMLTextPresenter;
import org.eclipse.ant.internal.ui.editor.text.AntEditorProcInstrScanner;
import org.eclipse.ant.internal.ui.editor.text.AntEditorTagScanner;
import org.eclipse.ant.internal.ui.editor.text.MultilineDamagerRepairer;
import org.eclipse.ant.internal.ui.editor.text.NotifyingReconciler;
import org.eclipse.ant.internal.ui.editor.text.XMLAnnotationHover;
import org.eclipse.ant.internal.ui.editor.text.XMLReconcilingStrategy;
import org.eclipse.ant.internal.ui.editor.text.XMLTextHover;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.ColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public class AntEditorSourceViewerConfiguration
extends SourceViewerConfiguration {
    private AntEditorTagScanner tagScanner;
    private AntEditorProcInstrScanner instructionScanner;
    private MultilineDamagerRepairer damageRepairer;
    private AntEditor fEditor;
    private XMLTextHover fTextHover;
    private ContentAssistant contentAssistant;

    public AntEditorSourceViewerConfiguration(AntEditor editor) {
        this.fEditor = editor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        this.contentAssistant = new ContentAssistant();
        AntEditorCompletionProcessor processor = new AntEditorCompletionProcessor();
        this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__xml_tag");
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        String triggers = store.getString("content_assist_autoactivation_triggers_java");
        if (triggers != null) {
            processor.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        this.contentAssistant.enableAutoInsert(store.getBoolean("content_assist_autoinsert"));
        this.contentAssistant.enableAutoActivation(store.getBoolean("content_assist_autoactivation"));
        this.contentAssistant.setAutoActivationDelay(store.getInt("content_assist_autoactivation_delay"));
        this.contentAssistant.setProposalPopupOrientation(10);
        this.contentAssistant.setContextInformationPopupOrientation(20);
        this.contentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        ColorManager manager = ColorManager.getDefault();
        Color background = this.getColor(store, "content_assist_proposals_background", manager);
        this.contentAssistant.setContextInformationPopupBackground(background);
        this.contentAssistant.setContextSelectorBackground(background);
        this.contentAssistant.setProposalSelectorBackground(background);
        Color foreground = this.getColor(store, "content_assist_proposals_foreground", manager);
        this.contentAssistant.setContextInformationPopupForeground(foreground);
        this.contentAssistant.setContextSelectorForeground(foreground);
        this.contentAssistant.setProposalSelectorForeground(foreground);
        IInformationControlCreator creator = this.getInformationControlCreator(true);
        this.contentAssistant.setInformationControlCreator(creator);
        return this.contentAssistant;
    }

    protected IInformationControlCreator getInformationControlCreator(final boolean cutDown) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(parent, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
            }
        };
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return 4;
    }

    private AntEditorProcInstrScanner getDefaultScanner() {
        if (this.instructionScanner == null) {
            this.instructionScanner = new AntEditorProcInstrScanner();
        }
        return this.instructionScanner;
    }

    private AntEditorTagScanner getTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new AntEditorTagScanner();
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        MultilineDamagerRepairer dr = new MultilineDamagerRepairer((ITokenScanner)this.getDefaultScanner(), null);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new MultilineDamagerRepairer((ITokenScanner)this.getTagScanner(), null);
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        this.damageRepairer = new MultilineDamagerRepairer(null, new TextAttribute(AntUIPlugin.getPreferenceColor("antEditor.color.xml_comment")));
        reconciler.setDamager((IPresentationDamager)this.damageRepairer, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)this.damageRepairer, "__xml_comment");
        return reconciler;
    }

    public void updateScanners() {
        this.tagScanner.adaptToColorChange();
        this.instructionScanner.adaptToColorChange();
        this.damageRepairer.setDefaultTextAttribute(new TextAttribute(AntUIPlugin.getPreferenceColor("antEditor.color.xml_comment")));
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        NotifyingReconciler reconciler = new NotifyingReconciler(new XMLReconcilingStrategy((ITextEditor)this.fEditor), false);
        reconciler.setDelay(500);
        return reconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new XMLAnnotationHover();
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return this.getInformationControlCreator(true);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.fTextHover == null) {
            this.fTextHover = new XMLTextHover();
        }
        return this.fTextHover;
    }

    private Color getColor(IPreferenceStore store, String key, ColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    protected void changeConfiguration(PropertyChangeEvent event) {
        IPreferenceStore store = AntUIPlugin.getDefault().getPreferenceStore();
        String p = event.getProperty();
        ColorManager manager = ColorManager.getDefault();
        if ("content_assist_autoactivation".equals(p)) {
            boolean enabled = store.getBoolean("content_assist_autoactivation");
            this.contentAssistant.enableAutoActivation(enabled);
        } else if ("content_assist_autoactivation_delay".equals(p)) {
            int delay = store.getInt("content_assist_autoactivation_delay");
            this.contentAssistant.setAutoActivationDelay(delay);
        } else if ("content_assist_proposals_foreground".equals(p)) {
            Color c = this.getColor(store, "content_assist_proposals_foreground", manager);
            this.contentAssistant.setProposalSelectorForeground(c);
        } else if ("content_assist_proposals_background".equals(p)) {
            Color c = this.getColor(store, "content_assist_proposals_background", manager);
            this.contentAssistant.setProposalSelectorBackground(c);
        } else if ("content_assist_autoinsert".equals(p)) {
            boolean enabled = store.getBoolean("content_assist_autoinsert");
            this.contentAssistant.enableAutoInsert(enabled);
        } else if ("content_assist_autoactivation_triggers_java".equals(p)) {
            this.changeContentAssistProcessor(store);
        }
    }

    private void changeContentAssistProcessor(IPreferenceStore store) {
        AntEditorCompletionProcessor cp;
        String triggers = store.getString("content_assist_autoactivation_triggers_java");
        if (triggers != null && (cp = (AntEditorCompletionProcessor)this.contentAssistant.getContentAssistProcessor("__dftl_partition_content_type")) != null) {
            cp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
    }
}

