/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.text.MessageFormat;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ant.internal.ui.editor.AntEditorException;
import org.eclipse.ant.internal.ui.editor.AntEditorMessages;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AntEditorSaxDefaultHandler
extends DefaultHandler {
    protected Locator locator;
    protected Stack stillOpenElements = new Stack();
    protected Element parentElement;
    protected boolean parsingFinished;
    protected Document document;
    protected int rowOfCursorPosition = -1;
    protected int columnOfCursorPosition = -1;
    public String rootElementName;
    private File mainFileContainer;
    private IDocument editorDocument;
    private FindReplaceDocumentAdapter findReplaceAdapter;

    public AntEditorSaxDefaultHandler(IDocument document, File fileContainer, int rowOfCursorPosition, int columnOfCursorPosition) throws ParserConfigurationException {
        if (rowOfCursorPosition < 0 || columnOfCursorPosition < 0) {
            throw new IllegalArgumentException(MessageFormat.format(AntEditorMessages.getString("AntEditorSaxDefaultHandler.Invalid_cursor_position"), Integer.toString(rowOfCursorPosition), Integer.toString(columnOfCursorPosition)));
        }
        this.rowOfCursorPosition = rowOfCursorPosition;
        this.columnOfCursorPosition = columnOfCursorPosition;
        this.mainFileContainer = fileContainer;
        this.editorDocument = document;
        this.findReplaceAdapter = new FindReplaceDocumentAdapter(document);
        this.initialize();
    }

    protected void initialize() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.document = documentBuilder.newDocument();
    }

    protected boolean checkForParentElement(String tagName) {
        if (this.parentElement == null) {
            if (this.locator != null) {
                int lineNum = this.locator.getLineNumber();
                int columnNum = this.locator.getColumnNumber() - 1;
                if (columnNum < 0) {
                    try {
                        int offset = this.getOffset(lineNum, this.getLastCharColumn(lineNum));
                        IRegion result = this.findReplaceAdapter.search(offset, tagName, false, false, false, false);
                        if (result != null) {
                            offset = result.getOffset();
                            columnNum = this.getColumn(offset, lineNum);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                if (--lineNum > this.rowOfCursorPosition || lineNum == this.rowOfCursorPosition && columnNum > this.columnOfCursorPosition && !this.stillOpenElements.isEmpty()) {
                    this.parentElement = (Element)this.stillOpenElements.peek();
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private int getColumn(int offset, int line) throws BadLocationException {
        return offset - this.editorDocument.getLineOffset(line - 1) + 1;
    }

    private int getOffset(int line, int column) throws BadLocationException {
        return this.editorDocument.getLineOffset(line - 1) + column - 1;
    }

    private int getLastCharColumn(int line) throws BadLocationException {
        String lineDelimiter = this.editorDocument.getLineDelimiter(line - 1);
        int lineDelimiterLength = lineDelimiter != null ? lineDelimiter.length() : 0;
        return this.editorDocument.getLineLength(line - 1) - lineDelimiterLength;
    }

    public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) {
        String tagName;
        if (this.parsingFinished) {
            return;
        }
        String string = tagName = localName.length() > 0 ? localName : qualifiedName;
        if (tagName == null || tagName.length() == 0) {
            throw new AntEditorException(AntEditorMessages.getString("AntEditorSaxDefaultHandler.Error_parsing"));
        }
        this.checkForParentElement(String.valueOf('<') + tagName);
        Element element = this.document.createElement(tagName);
        this.stillOpenElements.push(element);
        if (this.rootElementName == null) {
            this.rootElementName = tagName;
        }
    }

    public void endElement(String aUri, String aLocalName, String aQualifiedName) {
        Element lastStillOpenElement;
        if (this.parsingFinished) {
            return;
        }
        String tagName = aLocalName.length() > 0 ? aLocalName : aQualifiedName;
        boolean parentKnown = this.checkForParentElement(String.valueOf('/') + tagName);
        if (!this.stillOpenElements.isEmpty() && (lastStillOpenElement = (Element)this.stillOpenElements.peek()) != null && lastStillOpenElement.getTagName().equals(tagName)) {
            this.stillOpenElements.pop();
            if (!this.stillOpenElements.empty()) {
                Element secondLastStillOpenElement = (Element)this.stillOpenElements.peek();
                secondLastStillOpenElement.appendChild(lastStillOpenElement);
            }
            if (parentKnown && this.parentElement != null && this.parentElement.getTagName().equals(tagName)) {
                this.parsingFinished = true;
            }
        }
    }

    public void setDocumentLocator(Locator aLocator) {
        this.locator = aLocator;
    }

    public Element getParentElement(boolean guessParent) {
        if (this.parentElement != null) {
            return this.parentElement;
        }
        if (guessParent && !this.stillOpenElements.empty()) {
            return (Element)this.stillOpenElements.peek();
        }
        return null;
    }

    public void fatalError(SAXParseException anException) {
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        int index = systemId.indexOf(58);
        if (index > 0) {
            systemId = systemId.substring(index + 1, systemId.length());
        }
        File resolvedFile = null;
        IFile file = AntUtil.getFileForLocation(systemId, this.mainFileContainer);
        if (file == null) {
            return null;
        }
        resolvedFile = file.getLocation().toFile();
        try {
            InputSource inputSource = new InputSource(new FileReader(resolvedFile));
            inputSource.setSystemId(resolvedFile.getAbsolutePath());
            return inputSource;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }
}

