/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Available;
import org.apache.tools.ant.taskdefs.Parallel;
import org.apache.tools.ant.taskdefs.PathConvert;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.taskdefs.Sequential;
import org.apache.tools.ant.taskdefs.UpToDate;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.eclipse.ant.internal.ui.dtd.IAttribute;
import org.eclipse.ant.internal.ui.dtd.IDfm;
import org.eclipse.ant.internal.ui.dtd.IElement;
import org.eclipse.ant.internal.ui.dtd.ISchema;
import org.eclipse.ant.internal.ui.dtd.ParseError;
import org.eclipse.ant.internal.ui.dtd.Parser;
import org.eclipse.ant.internal.ui.editor.AntCompletionProposal;
import org.eclipse.ant.internal.ui.editor.AntEditorException;
import org.eclipse.ant.internal.ui.editor.AntEditorMessages;
import org.eclipse.ant.internal.ui.editor.AntEditorSaxDefaultHandler;
import org.eclipse.ant.internal.ui.editor.EnclosingTargetSearchingHandler;
import org.eclipse.ant.internal.ui.editor.TaskDescriptionProvider;
import org.eclipse.ant.internal.ui.editor.utils.ProjectHelper;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AntEditorCompletionProcessor
implements IContentAssistProcessor {
    private Comparator proposalComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String string1 = ((ICompletionProposal)o1).getDisplayString();
            String string2 = ((ICompletionProposal)o2).getDisplayString();
            return string1.compareToIgnoreCase(string2);
        }
    };
    private static final int PROPOSAL_MODE_NONE = 0;
    private static final int PROPOSAL_MODE_TASK_PROPOSAL = 1;
    private static final int PROPOSAL_MODE_ATTRIBUTE_PROPOSAL = 2;
    private static final int PROPOSAL_MODE_TASK_PROPOSAL_CLOSING = 3;
    private static final int PROPOSAL_MODE_ATTRIBUTE_VALUE_PROPOSAL = 4;
    private static final int PROPOSAL_MODE_PROPERTY_PROPOSAL = 5;
    protected int lineNumber = -1;
    protected int columnNumber = -1;
    private int additionalProposalOffset = -1;
    private static final String ANT_1_5_DTD_FILENAME = "/ant1.5b.dtd";
    private static ISchema dtd;
    protected int cursorPosition = -1;
    private ITextViewer viewer;
    private char[] autoActivationChars = null;
    private TaskDescriptionProvider descriptionProvider = new TaskDescriptionProvider();
    private AntEditorSaxDefaultHandler lastDefaultHandler;
    private String errorMessage;

    public AntEditorCompletionProcessor() {
        if (dtd == null) {
            try {
                dtd = this.parseDtd();
            }
            catch (IOException e) {
                AntUIPlugin.log(e);
            }
            catch (ParseError e) {
                AntUIPlugin.log(e);
            }
        }
    }

    private ISchema parseDtd() throws ParseError, IOException {
        InputStream stream = this.getClass().getResourceAsStream(ANT_1_5_DTD_FILENAME);
        InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
        Parser parser = new Parser();
        ISchema schema = parser.parseDTD(reader, "project");
        reader.close();
        return schema;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer refViewer, int documentOffset) {
        this.viewer = refViewer;
        return this.determineProposals();
    }

    public IContextInformation[] computeContextInformation(ITextViewer refViewer, int documentOffset) {
        return new IContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.autoActivationChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private ICompletionProposal[] determineProposals() {
        this.cursorPosition = ((ITextSelection)this.viewer.getSelectionProvider().getSelection()).getOffset();
        IDocument doc = this.viewer.getDocument();
        try {
            this.lineNumber = doc.getLineOfOffset(this.cursorPosition);
            this.columnNumber = this.cursorPosition - doc.getLineOffset(this.lineNumber);
        }
        catch (BadLocationException e) {
            AntUIPlugin.log(e);
        }
        String prefix = this.getCurrentPrefix();
        if (prefix == null || this.cursorPosition == -1) {
            AntUIPlugin.getStandardDisplay().beep();
            return null;
        }
        ICompletionProposal[] proposals = this.getProposalsFromDocument(doc, prefix);
        return proposals;
    }

    private ICompletionProposal[] getProposalsFromDocument(IDocument document, String prefix) {
        String taskString = null;
        ICompletionProposal[] proposals = null;
        switch (this.determineProposalMode(document, this.cursorPosition, prefix)) {
            case 2: {
                taskString = this.getTaskStringFromDocumentStringToPrefix(document.get().substring(0, this.cursorPosition - prefix.length()));
                proposals = this.getAttributeProposals(taskString, prefix);
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.28");
                break;
            }
            case 1: {
                proposals = this.getTaskProposals(document, this.findParentElement(document, this.lineNumber, this.columnNumber), prefix);
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.29");
                break;
            }
            case 3: {
                proposals = this.getClosingTaskProposals(this.findNotClosedParentElement(document, this.lineNumber, this.columnNumber), prefix);
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.30");
                break;
            }
            case 4: {
                String textToSearch = document.get().substring(0, this.cursorPosition - prefix.length());
                taskString = this.getTaskStringFromDocumentStringToPrefix(textToSearch);
                String attributeString = this.getAttributeStringFromDocumentStringToPrefix(textToSearch);
                proposals = this.getAttributeValueProposals(taskString, attributeString, prefix);
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.31");
                break;
            }
            case 5: {
                proposals = this.getPropertyProposals(document, prefix, this.cursorPosition);
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.32");
                break;
            }
            default: {
                proposals = new ICompletionProposal[]{};
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.33");
            }
        }
        Arrays.sort(proposals, this.proposalComparator);
        if (proposals.length > 0) {
            this.errorMessage = "";
        }
        return proposals;
    }

    protected ICompletionProposal[] getAttributeProposals(String aTaskName, String aPrefix) {
        ArrayList<AntCompletionProposal> proposals = new ArrayList<AntCompletionProposal>();
        IElement element = dtd.getElement(aTaskName);
        if (element != null) {
            Iterator keys = element.getAttributes().keySet().iterator();
            while (keys.hasNext()) {
                String description;
                String attrName = (String)keys.next();
                if (!attrName.toLowerCase().startsWith(aPrefix)) continue;
                IAttribute dtdAttributes = (IAttribute)element.getAttributes().get(attrName);
                String replacementString = String.valueOf(attrName) + "=\"\"";
                String displayString = attrName;
                String[] items = dtdAttributes.getEnum();
                if (items != null) {
                    if (items.length > 1) {
                        displayString = String.valueOf(displayString) + " - (";
                    }
                    int i = 0;
                    while (i < items.length) {
                        displayString = String.valueOf(displayString) + items[i];
                        displayString = i + 1 < items.length ? String.valueOf(displayString) + " | " : String.valueOf(displayString) + ")";
                        ++i;
                    }
                }
                String proposalInfo = null;
                String required = this.descriptionProvider.getRequiredAttributeForTaskAttribute(aTaskName, attrName);
                if (required != null && required.length() > 0) {
                    proposalInfo = String.valueOf(AntEditorMessages.getString("AntEditorCompletionProcessor.Required___4")) + required;
                    proposalInfo = String.valueOf(proposalInfo) + "<BR><BR>";
                }
                if ((description = this.descriptionProvider.getDescriptionForTaskAttribute(aTaskName, attrName)) != null) {
                    proposalInfo = proposalInfo == null ? "" : proposalInfo;
                    proposalInfo = String.valueOf(proposalInfo) + description;
                }
                AntCompletionProposal proposal = new AntCompletionProposal(replacementString, this.cursorPosition - aPrefix.length(), aPrefix.length(), attrName.length() + 2, null, displayString, proposalInfo, 0);
                proposals.add(proposal);
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private ICompletionProposal[] getAttributeValueProposals(String aTaskName, String anAttributeName, String aPrefix) {
        String[] items;
        IAttribute attribute;
        ArrayList<AntCompletionProposal> proposals = new ArrayList<AntCompletionProposal>();
        IElement taskElement = dtd.getElement(aTaskName);
        if (taskElement != null && (attribute = (IAttribute)taskElement.getAttributes().get(anAttributeName)) != null && (items = attribute.getEnum()) != null) {
            int i = 0;
            while (i < items.length) {
                String item = items[i];
                if (item.toLowerCase().startsWith(aPrefix)) {
                    AntCompletionProposal proposal = new AntCompletionProposal(item, this.cursorPosition - aPrefix.length(), aPrefix.length(), item.length(), null, item, null, 0);
                    proposals.add(proposal);
                }
                ++i;
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    protected ICompletionProposal[] getPropertyProposals(IDocument document, String aPrefix, int aCursorPosition) {
        ArrayList<AntCompletionProposal> proposals = new ArrayList<AntCompletionProposal>();
        HashMap<String, AntCompletionProposal> displayStringToProposals = new HashMap<String, AntCompletionProposal>();
        Map properties = this.findPropertiesFromDocument(document);
        Image image = AntUIImages.getImage("org.eclipse.ant.ui.IMG_PROPERTY");
        int replacementLength = aPrefix.length();
        int replacementOffset = 0;
        String text = document.get();
        String stringToPrefix = text.substring(0, aCursorPosition - aPrefix.length());
        String lastTwoCharacters = stringToPrefix.substring(stringToPrefix.length() - 2, stringToPrefix.length());
        if (lastTwoCharacters.equals("${")) {
            replacementLength += 2;
            replacementOffset = aCursorPosition - aPrefix.length() - 2;
        } else if (lastTwoCharacters.endsWith("$")) {
            ++replacementLength;
            replacementOffset = aCursorPosition - aPrefix.length() - 1;
        } else {
            throw new AntEditorException("Internal Error computing property proposals");
        }
        if (text.length() > aCursorPosition && text.charAt(aCursorPosition) == '}') {
            ++replacementLength;
        }
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String propertyName = (String)i.next();
            if (!propertyName.toLowerCase().startsWith(aPrefix)) continue;
            String additionalPropertyInfo = (String)properties.get(propertyName);
            String replacementString = "${" + propertyName + '}';
            if (displayStringToProposals.get(propertyName) != null) continue;
            AntCompletionProposal proposal = new AntCompletionProposal(replacementString, replacementOffset, replacementLength, replacementString.length(), image, propertyName, additionalPropertyInfo, 1);
            proposals.add(proposal);
            displayStringToProposals.put(propertyName, proposal);
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    protected ICompletionProposal[] getTaskProposals(IDocument document, Element aParentTaskElement, String aPrefix) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (aParentTaskElement == null) {
            IElement rootElement;
            String rootElementName = null;
            if (this.lastDefaultHandler != null) {
                rootElementName = this.lastDefaultHandler.rootElementName;
            }
            if (rootElementName == null) {
                rootElementName = "project";
            }
            if ((rootElement = dtd.getElement(rootElementName)) != null && rootElementName.toLowerCase().startsWith(aPrefix)) {
                this.additionalProposalOffset = 0;
                ICompletionProposal proposal = this.newCompletionProposal(document, aPrefix, rootElementName);
                proposals.add(proposal);
            }
        } else {
            IElement parent = dtd.getElement(aParentTaskElement.getTagName());
            if (parent != null) {
                IDfm dfm = parent.getDfm();
                String[] accepts = dfm.getAccepts();
                int i = 0;
                while (i < accepts.length) {
                    this.additionalProposalOffset = 0;
                    String elementName = accepts[i];
                    if (elementName.toLowerCase().startsWith(aPrefix)) {
                        ICompletionProposal proposal = this.newCompletionProposal(document, aPrefix, elementName);
                        proposals.add(proposal);
                    }
                    ++i;
                }
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private ICompletionProposal newCompletionProposal(IDocument document, String aPrefix, String elementName) {
        Image proposalImage = AntUIImages.getImage("org.eclipse.ant.ui.html_tab_obj");
        String proposalInfo = this.descriptionProvider.getDescriptionForTask(elementName);
        String replacementString = this.getTaskProposalReplacementString(elementName);
        int replacementOffset = this.cursorPosition - aPrefix.length();
        int replacementLength = aPrefix.length();
        if (replacementOffset > 0 && document.get().charAt(replacementOffset - 1) == '<') {
            --replacementOffset;
            ++replacementLength;
        }
        return new AntCompletionProposal(replacementString, replacementOffset, replacementLength, elementName.length() + 2 + this.additionalProposalOffset, proposalImage, elementName, proposalInfo, 0);
    }

    private ICompletionProposal[] getClosingTaskProposals(Element unclosedTaskElement, String prefix) {
        ICompletionProposal[] proposals = null;
        if (unclosedTaskElement != null && unclosedTaskElement.getTagName().toLowerCase().startsWith(prefix)) {
            String replaceString = unclosedTaskElement.getTagName();
            proposals = new ICompletionProposal[]{new AntCompletionProposal(String.valueOf(replaceString) + '>', this.cursorPosition - prefix.length(), prefix.length(), replaceString.length() + 1, null, replaceString, null, 0)};
        }
        if (proposals == null) {
            proposals = new ICompletionProposal[]{};
        }
        return proposals;
    }

    private String getTaskProposalReplacementString(String aTaskName) {
        StringBuffer replacement = new StringBuffer("<");
        replacement.append(aTaskName);
        Node attributeNode = this.descriptionProvider.getAttributesNode(aTaskName);
        if (attributeNode != null) {
            this.appendRequiredAttributes(replacement, attributeNode);
        } else if ("project".equals(aTaskName)) {
            replacement.append(" default=\"\"");
            this.additionalProposalOffset = 9;
        }
        if (this.isEmpty(aTaskName)) {
            replacement.append("/>");
        } else {
            replacement.append("></");
            replacement.append(aTaskName);
            replacement.append('>');
        }
        return replacement.toString();
    }

    private void appendRequiredAttributes(StringBuffer replacement, Node attributeNode) {
        boolean requiredAdded = false;
        NodeList attributes = attributeNode.getChildNodes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            String required = this.descriptionProvider.getRequiredOfNode(attribute);
            if (required.equalsIgnoreCase("yes")) {
                String attributeName = this.descriptionProvider.getTaskAttributeName(attribute);
                replacement.append(' ');
                replacement.append(attributeName);
                replacement.append("=\"\"");
                if (!requiredAdded) {
                    this.additionalProposalOffset = attributeName.length() + 2;
                    requiredAdded = true;
                }
            }
            ++i;
        }
    }

    private boolean isEmpty(String aDTDElementName) {
        IElement element = dtd.getElement(aDTDElementName);
        return element.isEmpty();
    }

    protected Element findChildElementNamedOf(Element anElement, String aChildElementName) {
        NodeList nodeList = anElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && childNode.getNodeName().equals(aChildElementName)) {
                return (Element)childNode;
            }
            ++i;
        }
        return null;
    }

    private String getCurrentPrefix() {
        ITextSelection selection = (ITextSelection)this.viewer.getSelectionProvider().getSelection();
        if (selection.getLength() > 0) {
            return null;
        }
        IDocument doc = this.viewer.getDocument();
        return this.getPrefixFromDocument(doc.get(), selection.getOffset()).toLowerCase();
    }

    protected String getPrefixFromDocument(String aDocumentText, int anOffset) {
        int startOfWordToken = anOffset;
        char token = 'a';
        if (startOfWordToken > 0) {
            token = aDocumentText.charAt(startOfWordToken - 1);
        }
        while (startOfWordToken > 0 && (Character.isJavaIdentifierPart(token) || '.' == token || '-' == token || ';' == token) && '$' != token) {
            token = aDocumentText.charAt(--startOfWordToken - 1);
        }
        if (startOfWordToken != anOffset) {
            return aDocumentText.substring(startOfWordToken, anOffset);
        }
        return "";
    }

    protected int determineProposalMode(IDocument document, int aCursorPosition, String aPrefix) {
        String text = document.get();
        String stringToPrefix = text.substring(0, aCursorPosition - aPrefix.length());
        String trimmedString = stringToPrefix.trim();
        char lastChar = '\u0000';
        if (trimmedString.length() <= 0) {
            return 1;
        }
        lastChar = trimmedString.charAt(trimmedString.length() - 1);
        if (stringToPrefix.charAt(stringToPrefix.length() - 1) != lastChar && lastChar != '>') {
            String taskString;
            if (lastChar != '>' && lastChar != '<' && (taskString = this.getTaskStringFromDocumentStringToPrefix(trimmedString)) != null && this.isNamedTaskKnown(taskString)) {
                return 2;
            }
        } else if (stringToPrefix.charAt(stringToPrefix.length() - 1) == '\"') {
            String taskString = this.getTaskStringFromDocumentStringToPrefix(trimmedString);
            if (taskString != null && this.isNamedTaskKnown(taskString)) {
                return 4;
            }
        } else {
            int spaceIndex = stringToPrefix.lastIndexOf(32);
            int lessThanIndex = stringToPrefix.lastIndexOf(60);
            int greaterThanIndex = stringToPrefix.lastIndexOf(62);
            if (lessThanIndex > spaceIndex && greaterThanIndex < lessThanIndex) {
                int slashIndex = stringToPrefix.lastIndexOf(47);
                if (slashIndex == lessThanIndex + 1) {
                    return 3;
                }
                return 1;
            }
            if (lessThanIndex < greaterThanIndex) {
                if (this.isPropertyProposalMode(stringToPrefix)) {
                    return 5;
                }
                return 1;
            }
        }
        if (this.isPropertyProposalMode(stringToPrefix)) {
            return 5;
        }
        return 0;
    }

    private boolean isPropertyProposalMode(String stringToPrefix) {
        String lastTwoChars;
        return stringToPrefix.length() >= 2 && ((lastTwoChars = stringToPrefix.substring(stringToPrefix.length() - 2, stringToPrefix.length())).equals("${") || stringToPrefix.charAt(stringToPrefix.length() - 1) == '$');
    }

    private String getTaskStringFromDocumentStringToPrefix(String aDocumentStringToPrefix) {
        int lessThanIndex = aDocumentStringToPrefix.lastIndexOf(60);
        if (lessThanIndex > -1) {
            String taskString = aDocumentStringToPrefix.trim();
            int index = (taskString = taskString.substring(lessThanIndex + 1, taskString.length())).indexOf(32);
            if (index > 0) {
                taskString = taskString.substring(0, index);
            }
            if ((index = taskString.indexOf(10)) > 0) {
                taskString = taskString.substring(0, index);
            }
            if ((index = taskString.indexOf(13)) > 0) {
                taskString = taskString.substring(0, index);
            }
            return taskString;
        }
        return null;
    }

    private String getAttributeStringFromDocumentStringToPrefix(String docStringToPrefix) {
        int index = docStringToPrefix.lastIndexOf(61);
        String subString = docStringToPrefix.substring(0, index);
        index = (subString = subString.trim()).lastIndexOf(32);
        if (index > 0) {
            subString = subString.substring(index + 1, subString.length());
        }
        if ((index = subString.lastIndexOf(10)) > 0) {
            subString = subString.substring(index + 1, subString.length());
        }
        if ((index = subString.lastIndexOf(13)) > 0) {
            subString = subString.substring(index + 1, subString.length());
        }
        return subString;
    }

    private boolean isNamedTaskKnown(String aTaskName) {
        return dtd.getElement(aTaskName) != null;
    }

    protected Element findParentElement(IDocument document, int aLineNumber, int aColumnNumber) {
        return this.parseEditedFileSearchingForParent(document, aLineNumber, aColumnNumber).getParentElement(true);
    }

    private AntEditorSaxDefaultHandler parseEditedFileSearchingForParent(IDocument document, int aLineNumber, int aColumnNumber) {
        SAXParser parser = this.getSAXParser();
        if (parser == null) {
            return null;
        }
        AntEditorSaxDefaultHandler handler = null;
        File editedFile = this.getEditedFile();
        try {
            File parent = null;
            if (editedFile != null) {
                parent = editedFile.getParentFile();
            }
            handler = new AntEditorSaxDefaultHandler(document, parent, aLineNumber, aColumnNumber);
        }
        catch (ParserConfigurationException e) {
            AntUIPlugin.log(e);
        }
        this.parse(document, parser, handler, editedFile);
        this.lastDefaultHandler = handler;
        return handler;
    }

    private void parse(IDocument document, SAXParser parser, AntEditorSaxDefaultHandler handler, File editedFile) {
        InputSource inputSource = new InputSource(new StringReader(document.get()));
        if (editedFile != null) {
            inputSource.setSystemId(editedFile.getAbsolutePath());
        }
        try {
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException e) {
            AntUIPlugin.log(e);
        }
        catch (IOException iOException) {}
    }

    private SAXParser getSAXParser() {
        SAXParser parser = null;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            AntUIPlugin.log(e);
        }
        catch (SAXException e) {
            AntUIPlugin.log(e);
        }
        return parser;
    }

    private Map findPropertiesFromDocument(IDocument document) {
        Target curtarget;
        Project project = new Project();
        project.init();
        File file = this.getEditedFile();
        String filePath = "";
        if (file != null) {
            filePath = file.getAbsolutePath();
        }
        project.setUserProperty("ant.file", filePath);
        try {
            ProjectHelper.configureProject(project, file, document.get());
        }
        catch (BuildException buildException) {}
        Hashtable properties = project.getProperties();
        Element element = this.findEnclosingTargetElement(document, this.lineNumber, this.columnNumber);
        String targetName = null;
        if (element == null || (targetName = element.getAttribute("name")) == null || targetName.length() == 0) {
            return properties;
        }
        Vector sortedTargets = null;
        try {
            sortedTargets = project.topoSort(targetName, project.getTargets());
        }
        catch (BuildException buildException) {
            return project.getProperties();
        }
        int curidx = 0;
        do {
            curtarget = (Target)sortedTargets.get(curidx++);
            Task[] tasks = curtarget.getTasks();
            int i = 0;
            while (i < tasks.length) {
                Task task = tasks[i];
                boolean cfr_ignored_0 = task instanceof Sequential;
                boolean cfr_ignored_1 = task instanceof Parallel;
                if (task instanceof Property || task instanceof PathConvert || task instanceof Available || task instanceof UpToDate || task instanceof Condition) {
                    task.perform();
                }
                ++i;
            }
        } while (!curtarget.getName().equals(targetName));
        return project.getProperties();
    }

    protected File getEditedFile() {
        IWorkbenchPage page = AntUIPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        FileEditorInput input = (FileEditorInput)editor.getEditorInput();
        String projectPath = input.getFile().getProject().getLocation().toFile().getAbsolutePath();
        String projectRelativeFilePath = input.getFile().getFullPath().removeFirstSegments(1).makeRelative().toString();
        return new File(String.valueOf(projectPath) + File.separator + projectRelativeFilePath);
    }

    private Element findNotClosedParentElement(IDocument document, int aLineNumber, int aColumnNumber) {
        AntEditorSaxDefaultHandler handler = this.parseEditedFileSearchingForParent(document, aLineNumber, aColumnNumber);
        if (handler != null && handler.getParentElement(false) == null) {
            return handler.getParentElement(true);
        }
        return null;
    }

    private Element findEnclosingTargetElement(IDocument document, int aLineNumber, int aColumnNumber) {
        SAXParser parser = this.getSAXParser();
        if (parser == null) {
            return null;
        }
        EnclosingTargetSearchingHandler handler = null;
        File editedFile = this.getEditedFile();
        try {
            File parent = null;
            if (editedFile != null) {
                parent = editedFile.getParentFile();
            }
            handler = new EnclosingTargetSearchingHandler(document, parent, aLineNumber, aColumnNumber);
        }
        catch (ParserConfigurationException e) {
            AntUIPlugin.log(e);
        }
        this.parse(document, parser, handler, editedFile);
        return handler.getParentElement(true);
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.autoActivationChars = activationSet;
    }
}

