/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class AntCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension2 {
    public static final int TASK_PROPOSAL = 0;
    public static final int PROPERTY_PROPOSAL = 1;
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private String fAdditionalProposalInfo;
    private int fType;

    public AntCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, String additionalProposalInfo, int type) {
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.fType = type;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.apply(viewer.getDocument());
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        boolean valid;
        String enteredText = "";
        try {
            enteredText = document.get(this.fReplacementOffset, offset - this.fReplacementOffset);
        }
        catch (BadLocationException badLocationException) {}
        if (this.fType == 0 && enteredText.startsWith("<")) {
            enteredText = enteredText.substring(1);
        }
        if (this.fType == 1) {
            if (enteredText.startsWith("${")) {
                enteredText = enteredText.substring(2);
            }
            if (enteredText.startsWith("$")) {
                enteredText = enteredText.substring(1);
            }
        }
        if (valid = this.fDisplayString.startsWith(enteredText)) {
            ++this.fReplacementLength;
        }
        return valid;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String toString() {
        return this.getDisplayString();
    }
}

