/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.IInstallConfigurationChangedListener;
import org.eclipse.update.configuration.LocalSystemInfo;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.ISite;
import org.eclipse.update.internal.api.operations.IInstallFeatureOperation;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.operations.JobTargetSite;
import org.eclipse.update.internal.operations.JobTargetSites;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;
import org.eclipse.update.internal.ui.parts.SWTUtil;
import org.eclipse.update.internal.ui.wizards.BannerPage;
import org.eclipse.update.internal.ui.wizards.IDynamicPage;

public class TargetPage
extends BannerPage
implements IDynamicPage {
    private TableViewer jobViewer;
    private TableViewer siteViewer;
    private IInstallConfiguration config;
    private ConfigListener configListener;
    private Label requiredSpaceLabel;
    private Label availableSpaceLabel;
    private IInstallFeatureOperation[] jobs;
    private Button addButton;
    private Button deleteButton;
    private HashSet added;
    private JobTargetSites targetSites;

    public TargetPage(IInstallConfiguration config) {
        super("Target");
        this.setTitle(UpdateUI.getString("InstallWizard.TargetPage.title"));
        this.setDescription(UpdateUI.getString("InstallWizard.TargetPage.desc"));
        this.config = config;
        UpdateUI.getDefault().getLabelProvider().connect(this);
        this.configListener = new ConfigListener();
        this.targetSites = new JobTargetSites(config);
    }

    public void setJobs(IInstallFeatureOperation[] jobs) {
        this.jobs = jobs;
        this.targetSites.setJobs(jobs);
    }

    public void dispose() {
        UpdateUI.getDefault().getLabelProvider().disconnect(this);
        this.config.removeInstallConfigurationChangedListener((IInstallConfigurationChangedListener)this.configListener);
        super.dispose();
    }

    public Control createContents(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        Label label = new Label(client, 0);
        label.setText(UpdateUI.getString("InstallWizard.TargetPage.jobsLabel"));
        label = new Label(client, 0);
        label.setText(UpdateUI.getString("InstallWizard.TargetPage.siteLabel"));
        new Label(client, 0);
        this.createJobViewer(client);
        this.createSiteViewer(client);
        Composite buttonContainer = new Composite(client, 0);
        GridLayout blayout = new GridLayout();
        blayout.marginHeight = 0;
        blayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)blayout);
        buttonContainer.setLayoutData((Object)new GridData(1040));
        this.addButton = new Button(buttonContainer, 8);
        this.addButton.setText(UpdateUI.getString("InstallWizard.TargetPage.new"));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPage.this.addTargetLocation();
            }
        });
        this.addButton.setEnabled(false);
        this.addButton.setLayoutData((Object)new GridData(64));
        SWTUtil.setButtonDimensionHint(this.addButton);
        this.deleteButton = new Button(buttonContainer, 8);
        this.deleteButton.setText(UpdateUI.getString("InstallWizard.TargetPage.delete"));
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TargetPage.this.removeSelection();
                }
                catch (CoreException ex) {
                    UpdateUI.logException(ex);
                }
            }
        });
        this.deleteButton.setEnabled(false);
        this.deleteButton.setLayoutData((Object)new GridData(64));
        SWTUtil.setButtonDimensionHint(this.deleteButton);
        Composite status = new Composite(client, 0);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        status.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        status.setLayout((Layout)layout);
        label = new Label(status, 0);
        label.setText(UpdateUI.getString("InstallWizard.TargetPage.requiredSpace"));
        this.requiredSpaceLabel = new Label(status, 0);
        this.requiredSpaceLabel.setLayoutData((Object)new GridData(768));
        label = new Label(status, 0);
        label.setText(UpdateUI.getString("InstallWizard.TargetPage.availableSpace"));
        this.availableSpaceLabel = new Label(status, 0);
        this.availableSpaceLabel.setLayoutData((Object)new GridData(768));
        WorkbenchHelp.setHelp((Control)client, (String)"org.eclipse.update.ui.MultiTargetPage2");
        Dialog.applyDialogFont((Control)parent);
        return client;
    }

    private void createJobViewer(Composite parent) {
        this.jobViewer = new TableViewer(parent, 2816);
        GridData gd = new GridData(1808);
        gd.widthHint = 150;
        this.jobViewer.getTable().setLayoutData((Object)gd);
        this.jobViewer.setContentProvider((IContentProvider)new JobsContentProvider());
        this.jobViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.jobViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetPage.this.handleJobsSelected((IStructuredSelection)event.getSelection());
            }
        });
    }

    private void handleJobsSelected(IStructuredSelection selection) {
        IInstallFeatureOperation job = (IInstallFeatureOperation)selection.getFirstElement();
        if (job != null) {
            this.siteViewer.setInput((Object)job);
            JobTargetSite jobSite = (JobTargetSite)this.targetSites.get((Object)job);
            this.addButton.setEnabled(jobSite.affinitySite == null);
            if (jobSite.targetSite != null) {
                this.siteViewer.setSelection((ISelection)new StructuredSelection((Object)jobSite.targetSite));
            }
        }
    }

    private void createSiteViewer(Composite parent) {
        this.siteViewer = new TableViewer(parent, 2816);
        GridData gd = new GridData(1808);
        gd.widthHint = 200;
        this.siteViewer.getTable().setLayoutData((Object)gd);
        this.siteViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.siteViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.siteViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer v, Object parent, Object obj) {
                IInstallFeatureOperation job = (IInstallFeatureOperation)TargetPage.this.siteViewer.getInput();
                JobTargetSite jobSite = (JobTargetSite)TargetPage.this.targetSites.get((Object)job);
                return TargetPage.this.targetSites.getSiteVisibility((IConfiguredSite)obj, jobSite);
            }
        });
        this.siteViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                TargetPage.this.selectTargetSite(ssel);
                TargetPage.this.updateDeleteButton(ssel);
            }
        });
        if (this.config != null) {
            this.config.addInstallConfigurationChangedListener((IInstallConfigurationChangedListener)this.configListener);
        }
    }

    private void updateDeleteButton(IStructuredSelection selection) {
        boolean enable;
        boolean bl = enable = this.added != null && !this.added.isEmpty();
        if (enable) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                if (this.added.contains(iter.next())) continue;
                enable = false;
                break;
            }
        }
        this.deleteButton.setEnabled(enable);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.targetSites.computeDefaultTargetSites();
            this.jobViewer.setInput((Object)this.jobs);
            if (this.jobViewer.getSelection().isEmpty() && this.jobs.length > 0) {
                this.jobViewer.setSelection((ISelection)new StructuredSelection((Object)this.jobs[0]));
            }
        }
        super.setVisible(visible);
    }

    private void verifyNotEmpty(boolean empty) {
        String errorMessage = null;
        if (empty) {
            errorMessage = UpdateUI.getString("InstallWizard.TargetPage.location.empty");
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(!empty);
    }

    private void selectTargetSite(IStructuredSelection selection) {
        IConfiguredSite site = (IConfiguredSite)selection.getFirstElement();
        IInstallFeatureOperation job = (IInstallFeatureOperation)this.siteViewer.getInput();
        if (job != null) {
            JobTargetSite jobSite = (JobTargetSite)this.targetSites.get((Object)job);
            jobSite.targetSite = site;
            this.pageChanged();
        }
        this.updateStatus(site);
    }

    private void addTargetLocation() {
        DirectoryDialog dd = new DirectoryDialog(this.getContainer().getShell());
        dd.setMessage(UpdateUI.getString("InstallWizard.TargetPage.location.message"));
        String path = dd.open();
        if (path != null) {
            TargetPage.addConfiguredSite(this.getContainer().getShell(), this.config, new File(path), false);
        }
    }

    private void removeSelection() throws CoreException {
        IStructuredSelection selection = (IStructuredSelection)this.siteViewer.getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            this.config.removeConfiguredSite((IConfiguredSite)iter.next());
        }
    }

    public static IConfiguredSite addConfiguredSite(Shell shell, IInstallConfiguration config, File file, boolean linked) {
        try {
            IConfiguredSite csite = null;
            if (linked) {
                csite = config.createLinkedConfiguredSite(file);
                config.addConfiguredSite(csite);
            } else {
                if (!TargetPage.ensureUnique(file, config)) {
                    String title = UpdateUI.getString("InstallWizard.TargetPage.location.error.title");
                    String message = UpdateUI.getFormattedMessage("InstallWizard.TargetPage.location.exists", file.getPath());
                    MessageDialog.openError((Shell)shell, (String)title, (String)message);
                    return null;
                }
                csite = config.createConfiguredSite(file);
                IStatus status = csite.verifyUpdatableStatus();
                if (status.isOK()) {
                    config.addConfiguredSite(csite);
                } else {
                    String title = UpdateUI.getString("InstallWizard.TargetPage.location.error.title");
                    String message = UpdateUI.getFormattedMessage("InstallWizard.TargetPage.location.error.message", file.getPath());
                    String message2 = UpdateUI.getFormattedMessage("InstallWizard.TargetPage.location.error.reason", status.getMessage());
                    message = String.valueOf(message) + System.getProperty("line.separator") + message2;
                    ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
                    return null;
                }
            }
            return csite;
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
            return null;
        }
    }

    private void updateStatus(Object element) {
        if (element == null) {
            this.requiredSpaceLabel.setText("");
            this.availableSpaceLabel.setText("");
            return;
        }
        IConfiguredSite site = (IConfiguredSite)element;
        File file = new File(site.getSite().getURL().getFile());
        long available = LocalSystemInfo.getFreeSpace((File)file);
        long required = this.computeRequiredSizeFor(site);
        if (required == -1L) {
            this.requiredSpaceLabel.setText(UpdateUI.getString("InstallWizard.TargetPage.unknownSize"));
        } else {
            this.requiredSpaceLabel.setText(UpdateUI.getFormattedMessage("InstallWizard.TargetPage.size", "" + required));
        }
        if (available == -1L) {
            this.availableSpaceLabel.setText(UpdateUI.getString("InstallWizard.TargetPage.unknownSize"));
        } else {
            this.availableSpaceLabel.setText(UpdateUI.getFormattedMessage("InstallWizard.TargetPage.size", "" + available));
        }
    }

    private long computeRequiredSizeFor(IConfiguredSite site) {
        long totalSize = 0L;
        int i = 0;
        while (i < this.jobs.length) {
            JobTargetSite jobSite = (JobTargetSite)this.targetSites.get((Object)this.jobs[i]);
            if (site.equals(jobSite.targetSite)) {
                long jobSize = site.getSite().getInstallSizeFor(this.jobs[i].getFeature());
                if (jobSize == -1L) {
                    return -1L;
                }
                totalSize += jobSize;
            }
            ++i;
        }
        return totalSize;
    }

    private void pageChanged() {
        boolean empty = false;
        Iterator iterator = this.targetSites.keySet().iterator();
        while (iterator.hasNext()) {
            JobTargetSite patchedSite;
            JobTargetSite jobSite = (JobTargetSite)this.targetSites.get(iterator.next());
            if (jobSite.targetSite == null) {
                empty = true;
                break;
            }
            IFeature feature = jobSite.job.getFeature();
            if (!feature.isPatch() || (patchedSite = this.targetSites.findPatchedFeature(feature)) == null || jobSite.targetSite == null || patchedSite.targetSite == null || jobSite.targetSite.equals(patchedSite.targetSite)) continue;
            UpdateUI.getFormattedMessage("IntallWizard.TargetPage.patchError", new String[]{feature.getLabel(), patchedSite.job.getFeature().getLabel()});
            this.setPageComplete(false);
            return;
        }
        this.verifyNotEmpty(empty);
    }

    private static boolean ensureUnique(File file, IInstallConfiguration config) {
        URL fileURL;
        IConfiguredSite[] sites = config.getConfiguredSites();
        try {
            fileURL = new URL("file:" + file.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            return true;
        }
        int i = 0;
        while (i < sites.length) {
            URL url = sites[i].getSite().getURL();
            if (UpdateManagerUtils.sameURL((URL)fileURL, (URL)url)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IConfiguredSite getTargetSite(IInstallFeatureOperation job) {
        return this.targetSites.getTargetSite(job);
    }

    public JobTargetSite[] getTargetSites() {
        JobTargetSite[] sites = new JobTargetSite[this.jobs.length];
        int i = 0;
        while (i < this.jobs.length) {
            JobTargetSite jobSite;
            sites[i] = jobSite = (JobTargetSite)this.targetSites.get((Object)this.jobs[i]);
            ++i;
        }
        return sites;
    }

    class JobsContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        JobsContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return TargetPage.this.jobs;
        }
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return TargetPage.this.config.getConfiguredSites();
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object obj, int col) {
            UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
            if (obj instanceof IConfiguredSite) {
                return provider.getLocalSiteImage((IConfiguredSite)obj);
            }
            if (obj instanceof IInstallFeatureOperation) {
                IInstallFeatureOperation job = (IInstallFeatureOperation)obj;
                ImageDescriptor base = job.getFeature().isPatch() ? UpdateUIImages.DESC_EFIX_OBJ : UpdateUIImages.DESC_FEATURE_OBJ;
                int flags = 0;
                JobTargetSite jobSite = (JobTargetSite)TargetPage.this.targetSites.get((Object)job);
                if (jobSite == null || jobSite.targetSite == null) {
                    flags = 1;
                }
                return provider.get(base, flags);
            }
            return null;
        }

        public String getColumnText(Object obj, int col) {
            if (obj instanceof IInstallFeatureOperation && col == 0) {
                IFeature feature = ((IInstallFeatureOperation)obj).getFeature();
                return String.valueOf(feature.getLabel()) + " " + feature.getVersionedIdentifier().getVersion().toString();
            }
            if (obj instanceof IConfiguredSite && col == 0) {
                ISite site = ((IConfiguredSite)obj).getSite();
                return site.getURL().getFile();
            }
            return null;
        }
    }

    class ConfigListener
    implements IInstallConfigurationChangedListener {
        ConfigListener() {
        }

        public void installSiteAdded(IConfiguredSite csite) {
            TargetPage.this.siteViewer.add((Object)csite);
            if (TargetPage.this.added == null) {
                TargetPage.this.added = new HashSet();
            }
            TargetPage.this.added.add(csite);
            TargetPage.this.siteViewer.setSelection((ISelection)new StructuredSelection((Object)csite));
            TargetPage.this.siteViewer.getControl().setFocus();
        }

        public void installSiteRemoved(IConfiguredSite csite) {
            IInstallFeatureOperation job;
            TargetPage.this.siteViewer.remove((Object)csite);
            if (TargetPage.this.added != null) {
                TargetPage.this.added.remove(csite);
            }
            if ((job = (IInstallFeatureOperation)TargetPage.this.siteViewer.getInput()) != null) {
                JobTargetSite jobSite = (JobTargetSite)TargetPage.this.targetSites.get((Object)job);
                IConfiguredSite defaultSite = TargetPage.this.targetSites.computeTargetSite(jobSite);
                if (defaultSite != null) {
                    TargetPage.this.siteViewer.setSelection((ISelection)new StructuredSelection((Object)defaultSite));
                }
            }
            TargetPage.this.siteViewer.getControl().setFocus();
        }
    }
}

