/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configuration.IProblemHandler;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.api.operations.IRevertConfigurationOperation;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.wizards.ActivitiesTableViewer;
import org.eclipse.update.internal.ui.wizards.UIProblemHandler;

public class RevertConfigurationWizardPage
extends WizardPage {
    private TableViewer activitiesViewer;
    private TableViewer configViewer;

    public RevertConfigurationWizardPage() {
        super("RevertConfiguration");
        this.setTitle(UpdateUI.getString("RevertConfigurationWizardPage.title"));
        this.setDescription(UpdateUI.getString("RevertConfigurationWizardPage.desc"));
    }

    public void createControl(Composite parent) {
        SashForm composite = new SashForm(parent, 512);
        composite.setLayout((Layout)new GridLayout());
        this.createConfigurationsSection((Composite)composite);
        this.createActivitiesSection((Composite)composite);
        this.setControl((Control)composite);
        Object element = this.configViewer.getElementAt(0);
        if (element != null) {
            this.configViewer.setSelection((ISelection)new StructuredSelection(element));
        }
        Dialog.applyDialogFont((Control)composite);
    }

    private void createConfigurationsSection(Composite parent) {
        Composite tableContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableContainer.setLayout((Layout)layout);
        Label label = new Label(tableContainer, 0);
        label.setText(UpdateUI.getString("RevertConfigurationWizardPage.label"));
        Table table = new Table(tableContainer, 2560);
        table.setLayoutData((Object)new GridData(1808));
        this.configViewer = new TableViewer(table);
        this.configViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
                return provider.get(UpdateUIImages.DESC_CONFIG_OBJ, 0);
            }

            public String getText(Object element) {
                return Utilities.format((Date)((IInstallConfiguration)element).getCreationDate());
            }
        });
        this.configViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object element) {
                ArrayList<IInstallConfiguration> result = new ArrayList<IInstallConfiguration>();
                ILocalSite localSite = (ILocalSite)element;
                IInstallConfiguration current = localSite.getCurrentConfiguration();
                long currTimeline = current.getTimeline();
                IInstallConfiguration[] configurations = localSite.getConfigurationHistory();
                int i = configurations.length - 1;
                while (i >= 0) {
                    if (configurations[i].getTimeline() == currTimeline && !current.equals(configurations[i])) {
                        result.add(configurations[i]);
                    }
                    --i;
                }
                return result.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.configViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection ssel = (IStructuredSelection)e.getSelection();
                RevertConfigurationWizardPage.this.activitiesViewer.setInput(ssel.getFirstElement());
            }
        });
        this.configViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IInstallConfiguration config1 = (IInstallConfiguration)e1;
                IInstallConfiguration config2 = (IInstallConfiguration)e2;
                if (config1.getCreationDate().before(config2.getCreationDate())) {
                    return 1;
                }
                if (config1.getCreationDate().after(config2.getCreationDate())) {
                    return -1;
                }
                return 0;
            }
        });
        try {
            this.configViewer.setInput((Object)SiteManager.getLocalSite());
        }
        catch (CoreException coreException) {}
    }

    private void createActivitiesSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label line = new Label(composite, 258);
        gd = new GridData(256);
        gd.widthHint = 1;
        line.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(UpdateUI.getString("RevertConfigurationWizardPage.activities"));
        this.activitiesViewer = ActivitiesTableViewer.createViewer(composite);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(8, 20, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 160, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 183, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 100, false));
        this.activitiesViewer.getTable().setLayout((Layout)layout);
    }

    public boolean performFinish() {
        Shell shell = this.getContainer().getShell();
        boolean result = MessageDialog.openQuestion((Shell)shell, (String)shell.getText(), (String)UpdateUI.getString("RevertConfigurationWizardPage.question"));
        if (!result) {
            return false;
        }
        boolean finish = this.performRevert();
        if (finish) {
            PlatformUI.getWorkbench().restart();
        }
        return finish;
    }

    public boolean performRevert() {
        IStructuredSelection ssel = (IStructuredSelection)this.configViewer.getSelection();
        final IInstallConfiguration target = (IInstallConfiguration)ssel.getFirstElement();
        IStatus status = OperationsManager.getValidator().validatePendingRevert(target);
        if (status != null && status.getCode() == 4) {
            ErrorDialog.openError((Shell)UpdateUI.getActiveWorkbenchShell(), null, null, (IStatus)status);
            return false;
        }
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                IRevertConfigurationOperation revertOperation = OperationsManager.getOperationFactory().createRevertConfigurationOperation(target, (IProblemHandler)new UIProblemHandler());
                try {
                    try {
                        revertOperation.execute(monitor, null);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, operation);
            return true;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof InstallAbortedException) {
                return true;
            }
            UpdateUI.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }
}

