/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.internal.api.operations.IInstallFeatureOperation;
import org.eclipse.update.internal.operations.FeatureHierarchyElement;
import org.eclipse.update.internal.operations.JobRoot;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;
import org.eclipse.update.internal.ui.parts.SWTUtil;
import org.eclipse.update.internal.ui.wizards.BannerPage;
import org.eclipse.update.internal.ui.wizards.IDynamicPage;

public class OptionalFeaturesPage
extends BannerPage
implements IDynamicPage {
    private static final String KEY_TITLE = "InstallWizard.OptionalFeaturesPage.title";
    private static final String KEY_DESC = "InstallWizard.OptionalFeaturesPage.desc";
    private static final String KEY_TREE_LABEL = "InstallWizard.OptionalFeaturesPage.treeLabel";
    private static final String KEY_SELECT_ALL = "InstallWizard.OptionalFeaturesPage.selectAll";
    private static final String KEY_DESELECT_ALL = "InstallWizard.OptionalFeaturesPage.deselectAll";
    private CheckboxTreeViewer treeViewer;
    private Button selectAllButton;
    private Button deselectAllButton;
    private IInstallConfiguration config;
    private JobRoot[] jobRoots;

    public OptionalFeaturesPage(IInstallConfiguration config) {
        super("OptionalFeatures");
        this.setTitle(UpdateUI.getString(KEY_TITLE));
        this.setDescription(UpdateUI.getString(KEY_DESC));
        this.config = config;
        UpdateUI.getDefault().getLabelProvider().connect(this);
    }

    public void setJobs(IInstallFeatureOperation[] jobs) {
        this.jobRoots = new JobRoot[jobs.length];
        int i = 0;
        while (i < jobs.length) {
            this.jobRoots[i] = new JobRoot(this.config, jobs[i]);
            ++i;
        }
    }

    public void dispose() {
        UpdateUI.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    public Control createContents(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        this.createCheckboxTreeViewer(client);
        this.selectAllButton = new Button(client, 8);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionalFeaturesPage.this.selectAll(true);
            }
        });
        this.selectAllButton.setText(UpdateUI.getString(KEY_SELECT_ALL));
        GridData gd = new GridData(258);
        this.selectAllButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.selectAllButton);
        this.deselectAllButton = new Button(client, 8);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionalFeaturesPage.this.selectAll(false);
            }
        });
        this.deselectAllButton.setText(UpdateUI.getString(KEY_DESELECT_ALL));
        gd = new GridData(258);
        this.deselectAllButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.deselectAllButton);
        WorkbenchHelp.setHelp((Control)client, (String)"org.eclipse.update.ui.MultiOptionalFeaturesPage2");
        Dialog.applyDialogFont((Control)parent);
        return client;
    }

    private void createCheckboxTreeViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(UpdateUI.getString(KEY_TREE_LABEL));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.treeViewer = new CheckboxTreeViewer(parent, 2816);
        gd = new GridData(1808);
        gd.verticalSpan = 2;
        this.treeViewer.getTree().setLayoutData((Object)gd);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                OptionalFeaturesPage.this.handleChecked(e.getElement(), e.getChecked());
            }
        });
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setInput((Object)this);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.treeViewer.setInput((Object)this.jobRoots);
            this.initializeStates();
        }
        super.setVisible(visible);
        if (visible) {
            this.treeViewer.getTree().setFocus();
        }
    }

    private void initializeStates() {
        ArrayList<JobRoot> checked = new ArrayList<JobRoot>();
        ArrayList<JobRoot> grayed = new ArrayList<JobRoot>();
        ArrayList editable = new ArrayList();
        int i = 0;
        while (i < this.jobRoots.length) {
            checked.add(this.jobRoots[i]);
            grayed.add(this.jobRoots[i]);
            boolean update = this.jobRoots[i].getJob().getOldFeature() != null;
            this.initializeStates(update, this.jobRoots[i].getElements(), checked, grayed, editable);
            ++i;
        }
        this.treeViewer.setCheckedElements(checked.toArray());
        this.treeViewer.setGrayedElements(grayed.toArray());
        this.selectAllButton.setEnabled(editable.size() > 0);
        this.deselectAllButton.setEnabled(editable.size() > 0);
    }

    private void initializeStates(boolean update, Object[] elements, ArrayList checked, ArrayList grayed, ArrayList editable) {
        int i = 0;
        while (i < elements.length) {
            FeatureHierarchyElement element = (FeatureHierarchyElement)elements[i];
            if (element.isChecked()) {
                checked.add(element);
            }
            if (!element.isEditable()) {
                grayed.add(element);
            } else {
                editable.add(element);
            }
            this.initializeStates(update, element.getChildren(), checked, grayed, editable);
            ++i;
        }
    }

    private void selectAll(boolean value) {
        ArrayList<IInstallFeatureOperation> selected = new ArrayList<IInstallFeatureOperation>();
        int i = 0;
        while (i < this.jobRoots.length) {
            IInstallFeatureOperation job = this.jobRoots[i].getJob();
            selected.add(job);
            FeatureHierarchyElement[] elements = this.jobRoots[i].getElements();
            int j = 0;
            while (j < elements.length) {
                FeatureHierarchyElement element = elements[j];
                this.selectAll(job.getOldFeature() != null, element, selected, value);
                ++j;
            }
            ++i;
        }
        this.treeViewer.setCheckedElements(selected.toArray());
    }

    private void selectAll(boolean update, FeatureHierarchyElement ref, ArrayList selected, boolean value) {
        if (!ref.isOptional()) {
            selected.add(ref);
        } else if (ref.isEditable()) {
            ref.setChecked(value);
            if (value) {
                selected.add(ref);
            }
        } else if (ref.isChecked()) {
            selected.add(ref);
        }
        FeatureHierarchyElement[] included = ref.getChildren();
        int i = 0;
        while (i < included.length) {
            this.selectAll(update, included[i], selected, value);
            ++i;
        }
    }

    private void handleChecked(Object element, boolean checked) {
        if (element instanceof JobRoot) {
            this.treeViewer.setChecked(element, !checked);
            return;
        }
        FeatureHierarchyElement fe = (FeatureHierarchyElement)element;
        if (!fe.isEditable()) {
            this.treeViewer.setChecked(element, !checked);
        } else {
            fe.setChecked(checked);
        }
    }

    public IFeature[] getUnconfiguredOptionalFeatures(IInstallFeatureOperation job, IConfiguredSite targetSite) {
        int i = 0;
        while (i < this.jobRoots.length) {
            if (job.equals(this.jobRoots[i].getJob())) {
                return this.jobRoots[i].getUnconfiguredOptionalFeatures(this.config, targetSite);
            }
            ++i;
        }
        return new IFeature[0];
    }

    public IFeatureReference[] getCheckedOptionalFeatures(IInstallFeatureOperation currentJob) {
        HashSet set = new HashSet();
        JobRoot jobRoot = null;
        int i = 0;
        while (i < this.jobRoots.length) {
            if (currentJob.equals(this.jobRoots[i].getJob())) {
                jobRoot = this.jobRoots[i];
                break;
            }
            ++i;
        }
        if (jobRoot == null) {
            return new IFeatureReference[0];
        }
        IInstallFeatureOperation job = jobRoot.getJob();
        boolean update = job.getOldFeature() != null;
        boolean patch = UpdateUtils.isPatch((IFeature)job.getFeature());
        FeatureHierarchyElement[] elements = jobRoot.getElements();
        int i2 = 0;
        while (i2 < elements.length) {
            elements[i2].addCheckedOptionalFeatures(update, patch, this.config, set);
            ++i2;
        }
        return set.toArray(new IFeatureReference[set.size()]);
    }

    class TreeContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof JobRoot) {
                return ((JobRoot)parent).getElements();
            }
            if (parent instanceof FeatureHierarchyElement) {
                FeatureHierarchyElement fe = (FeatureHierarchyElement)parent;
                Object root = fe.getRoot();
                boolean oldFeature = false;
                if (root instanceof JobRoot) {
                    IInstallFeatureOperation job = ((JobRoot)root).getJob();
                    boolean patch = UpdateUtils.isPatch((IFeature)job.getFeature());
                    oldFeature = job.getOldFeature() != null;
                    return fe.getChildren(oldFeature, patch, OptionalFeaturesPage.this.config);
                }
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            return null;
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }

        public Object[] getElements(Object input) {
            if (OptionalFeaturesPage.this.jobRoots == null) {
                return new Object[0];
            }
            return OptionalFeaturesPage.this.jobRoots;
        }
    }

    class TreeLabelProvider
    extends LabelProvider {
        TreeLabelProvider() {
        }

        public String getText(Object obj) {
            String name;
            if (obj instanceof JobRoot) {
                IFeature feature = ((JobRoot)obj).getJob().getFeature();
                return String.valueOf(feature.getLabel()) + " " + feature.getVersionedIdentifier().getVersion().toString();
            }
            if (obj instanceof FeatureHierarchyElement && (name = ((FeatureHierarchyElement)obj).getLabel()) != null) {
                return name;
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            return UpdateUI.getDefault().getLabelProvider().get(UpdateUIImages.DESC_FEATURE_OBJ);
        }
    }
}

