/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.update.internal.api.search.UpdateSearchRequest;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.wizards.BannerPage;
import org.eclipse.update.internal.ui.wizards.ISearchProvider;
import org.eclipse.update.internal.ui.wizards.SearchRunner;

public class ModeSelectionPage
extends BannerPage
implements ISearchProvider {
    private boolean updateMode = true;
    private Button updatesButton;
    private Button newFeaturesButton;
    private UpdateSearchRequest searchRequest;
    private SearchRunner searchRunner;
    private static final String SECTION_ID = "ModeSelectionPage";
    private static final String P_NEW_FEATURES_MODE = "new-features-mode";

    public ModeSelectionPage(SearchRunner searchRunner) {
        super("modeSelection");
        this.setTitle(UpdateUI.getString("ModeSelectionPage.title"));
        this.setDescription(UpdateUI.getString("ModeSelectionPage.desc"));
        this.searchRunner = searchRunner;
    }

    public UpdateSearchRequest getSearchRequest() {
        this.initializeSearch();
        return this.searchRequest;
    }

    private IDialogSettings getSettings() {
        IDialogSettings master = UpdateUI.getDefault().getDialogSettings();
        IDialogSettings section = master.getSection(SECTION_ID);
        if (section == null) {
            section = master.addNewSection(SECTION_ID);
        }
        return section;
    }

    private void initializeSearch() {
        if (this.searchRequest != null) {
            return;
        }
        this.searchRequest = UpdateUtils.createNewUpdatesRequest(null);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.updatesButton = new Button(composite, 16);
        this.updatesButton.setText(UpdateUI.getString("ModeSelectionPage.updates"));
        boolean newFeaturesMode = this.getSettings().getBoolean(P_NEW_FEATURES_MODE);
        this.updatesButton.setSelection(!newFeaturesMode);
        this.updatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModeSelectionPage.this.switchMode();
            }
        });
        this.newFeaturesButton = new Button(composite, 16);
        this.newFeaturesButton.setSelection(newFeaturesMode);
        this.newFeaturesButton.setText(UpdateUI.getString("ModeSelectionPage.newFeatures"));
        this.newFeaturesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModeSelectionPage.this.switchMode();
            }
        });
        this.switchMode();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    public void saveSettings() {
        boolean updateMode = this.updatesButton.getSelection();
        this.getSettings().put(P_NEW_FEATURES_MODE, !updateMode);
    }

    private void switchMode() {
        this.updateMode = this.updatesButton.getSelection();
        if (this.updateMode) {
            this.searchRunner.setSearchProvider(this);
        }
    }

    public boolean isUpdateMode() {
        return this.updateMode;
    }
}

