/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.SiteBookmark;

public class LocalSiteSelector {
    static String lastLocation = null;

    public static SiteBookmark getLocaLSite(Shell parent) {
        DirectoryDialog dialog = new DirectoryDialog(parent);
        dialog.setMessage(UpdateUI.getString("LocalSiteSelector.dialogMessage"));
        dialog.setFilterPath(lastLocation);
        String dir = dialog.open();
        SiteBookmark siteBookmark = null;
        while (dir != null && siteBookmark == null) {
            File dirFile = new File(dir);
            if (LocalSiteSelector.isDirSite(dirFile)) {
                siteBookmark = LocalSiteSelector.createDirSite(dirFile);
                lastLocation = dir;
                continue;
            }
            MessageDialog.openInformation((Shell)parent, (String)UpdateUI.getString("LocalSiteSelector.dirInfoTitle"), (String)UpdateUI.getString("LocalSiteSelector.dirInfoMessage"));
            dialog.setFilterPath(dir);
            dir = dialog.open();
        }
        return siteBookmark;
    }

    public static SiteBookmark getLocaLZippedSite(Shell parent) {
        FileDialog dialog = new FileDialog(parent);
        dialog.setText(UpdateUI.getString("LocalSiteSelector.dialogMessagezip"));
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        SiteBookmark siteBookmark = null;
        String zip = dialog.open();
        while (zip != null && siteBookmark == null) {
            File zipF = new File(zip);
            if (LocalSiteSelector.isZipSite(zipF)) {
                siteBookmark = LocalSiteSelector.createZipSite(zipF);
                continue;
            }
            MessageDialog.openInformation((Shell)parent, (String)UpdateUI.getString("LocalSiteSelector.zipInfoTitle"), (String)UpdateUI.getString("LocalSiteSelector.zipInfoMessage"));
            zip = dialog.open();
        }
        return siteBookmark;
    }

    static boolean isZipSite(File file) {
        if (!file.getName().toLowerCase().endsWith(".zip") && !file.getName().toLowerCase().endsWith(".jar")) {
            return false;
        }
        ZippedSiteValidator validator = new ZippedSiteValidator(file);
        BusyIndicator.showWhile((Display)UpdateUI.getActiveWorkbenchShell().getDisplay(), (Runnable)validator);
        return validator.isValid();
    }

    static boolean isDirSite(File dir) {
        File siteXML = new File(dir, "site.xml");
        File featuresDir = new File(dir, "features");
        File pluginsDir = new File(dir, "plugins");
        return siteXML.exists() || featuresDir.exists() && featuresDir.isDirectory() && pluginsDir.exists() && pluginsDir.isDirectory();
    }

    static SiteBookmark createZipSite(File file) {
        try {
            URL fileURL = new URL("file", null, file.getAbsolutePath());
            URL url = new URL("jar:" + fileURL.toExternalForm().replace('\\', '/') + "!/");
            SiteBookmark site = new SiteBookmark(file.getName(), url, false);
            site.setLocal(true);
            return site;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static SiteBookmark createDirSite(File file) {
        try {
            URL url = new URL("file:" + file.getAbsolutePath() + File.separator);
            String siteName = file.getAbsolutePath();
            SiteBookmark site = new SiteBookmark(siteName, url, false);
            site.setLocal(true);
            return site;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static class ZippedSiteValidator
    implements Runnable {
        File file;
        boolean valid = false;

        public ZippedSiteValidator(File file) {
            this.file = file;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ZipFile siteZip;
            block16: {
                block15: {
                    block14: {
                        siteZip = null;
                        try {
                            try {
                                siteZip = new ZipFile(this.file);
                                if (siteZip.getEntry("site.xml") != null) {
                                    this.valid = true;
                                    Object var6_2 = null;
                                    break block14;
                                }
                                boolean hasFeatures = false;
                                boolean hasPlugins = false;
                                Enumeration<? extends ZipEntry> enumeration = siteZip.entries();
                                while (enumeration.hasMoreElements()) {
                                    ZipEntry zEntry = enumeration.nextElement();
                                    if (!hasFeatures && zEntry.getName().startsWith("features")) {
                                        hasFeatures = true;
                                    }
                                    if (!hasPlugins && zEntry.getName().startsWith("plugins")) {
                                        hasPlugins = true;
                                    }
                                    if (!hasFeatures || !hasPlugins) continue;
                                    this.valid = true;
                                    break block15;
                                }
                                break block16;
                            }
                            catch (Exception exception) {
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_4 = null;
                            try {
                                if (siteZip == null) throw throwable;
                                siteZip.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                    }
                    try {}
                    catch (IOException iOException) {}
                    if (siteZip == null) return;
                    siteZip.close();
                    return;
                }
                Object var6_3 = null;
                try {}
                catch (IOException iOException) {}
                if (siteZip == null) return;
                siteZip.close();
                return;
            }
            Object var6_5 = null;
            try {}
            catch (IOException iOException) {
                return;
            }
            if (siteZip == null) return;
            siteZip.close();
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

