/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.api.operations.IInstallFeatureOperation;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.wizards.IDynamicPage;

public class LicensePage
extends WizardPage
implements IDynamicPage {
    private static final String KEY_TITLE = "InstallWizard.LicensePage.title";
    private static final String KEY_DESC = "InstallWizard.LicensePage.desc";
    private static final String KEY_DESC2 = "InstallWizard.LicensePage.desc2";
    private static final String KEY_ACCEPT = "InstallWizard.LicensePage.accept";
    private static final String KEY_DECLINE = "InstallWizard.LicensePage.decline";
    private static final String KEY_ACCEPT2 = "InstallWizard.LicensePage.accept2";
    private static final String KEY_DECLINE2 = "InstallWizard.LicensePage.decline2";
    private boolean multiLicenseMode = false;
    private IInstallFeatureOperation[] jobs;
    private Text text;
    private Table table;

    public LicensePage(boolean multiLicenseMode) {
        super("License");
        this.setTitle(UpdateUI.getString(KEY_TITLE));
        this.setPageComplete(false);
        this.multiLicenseMode = multiLicenseMode;
        UpdateUI.getDefault().getLabelProvider().connect(this);
        this.setDescription(UpdateUI.getString(multiLicenseMode ? KEY_DESC2 : KEY_DESC));
    }

    public void dispose() {
        UpdateUI.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    public LicensePage(IInstallFeatureOperation job) {
        this(false);
        this.setJobs(new IInstallFeatureOperation[]{job});
    }

    public void setJobs(IInstallFeatureOperation[] jobs) {
        this.jobs = jobs;
    }

    public void createControl(Composite parent) {
        Composite client = new Composite(parent, 0);
        client.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        client.setLayout((Layout)layout);
        WorkbenchHelp.setHelp((Control)client, (String)"org.eclipse.update.ui.LicensePage2");
        if (this.multiLicenseMode) {
            layout.numColumns = 3;
            layout.makeColumnsEqualWidth = true;
            this.table = new Table(client, 2816);
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.item != null) {
                        Object data = e.item.getData();
                        LicensePage.this.text.setText(data == null ? "" : (String)data);
                    }
                }
            });
            this.table.setLayoutData((Object)new GridData(1808));
        }
        this.text = new Text(client, 2826);
        GridData gd = new GridData(1808);
        if (this.multiLicenseMode) {
            gd.horizontalSpan = 2;
        }
        this.text.setLayoutData((Object)gd);
        this.text.setBackground(this.text.getDisplay().getSystemColor(25));
        Composite buttonContainer = new Composite(client, 0);
        gd = new GridData(256);
        if (this.multiLicenseMode) {
            gd.horizontalSpan = 3;
        }
        buttonContainer.setLayout((Layout)new GridLayout());
        buttonContainer.setLayoutData((Object)gd);
        final Button acceptButton = new Button(buttonContainer, 16);
        acceptButton.setText(UpdateUI.getString(this.multiLicenseMode ? KEY_ACCEPT2 : KEY_ACCEPT));
        acceptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensePage.this.setPageComplete(acceptButton.getSelection());
            }
        });
        Button declineButton = new Button(buttonContainer, 16);
        declineButton.setText(UpdateUI.getString(this.multiLicenseMode ? KEY_DECLINE2 : KEY_DECLINE));
        declineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicensePage.this.setPageComplete(acceptButton.getSelection());
            }
        });
        this.setControl((Control)client);
        Dialog.applyDialogFont((Control)parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.multiLicenseMode) {
                int i = 0;
                while (i < this.jobs.length) {
                    IFeature feature = this.jobs[i].getFeature();
                    TableItem item = new TableItem(this.table, 0);
                    String label = String.valueOf(feature.getLabel()) + " " + feature.getVersionedIdentifier().getVersion().toString();
                    item.setText(label);
                    item.setImage(UpdateUI.getDefault().getLabelProvider().get(feature.isPatch() ? UpdateUIImages.DESC_EFIX_OBJ : UpdateUIImages.DESC_FEATURE_OBJ));
                    String license = feature.getLicense().getAnnotation();
                    item.setData((Object)license);
                    ++i;
                }
                this.table.setSelection(0);
            }
            this.showLicenseText();
        } else if (this.multiLicenseMode) {
            TableItem[] items = this.table.getItems();
            int i = items.length - 1;
            while (i >= 0) {
                this.table.getItem(i).dispose();
                --i;
            }
        }
        super.setVisible(visible);
    }

    private void showLicenseText() {
        if (!this.multiLicenseMode) {
            this.text.setText(this.jobs[0].getFeature().getLicense().getAnnotation());
            return;
        }
        TableItem[] selectedItems = this.table.getSelection();
        if (selectedItems.length == 0) {
            this.text.setText("");
        } else {
            Object data = selectedItems[0].getData();
            this.text.setText(data == null ? "" : (String)data);
        }
    }
}

