/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.api.operations.IBatchOperation;
import org.eclipse.update.internal.api.operations.IInstallFeatureOperation;
import org.eclipse.update.internal.api.operations.IOperation;
import org.eclipse.update.internal.api.operations.IOperationListener;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.api.search.UpdateSearchRequest;
import org.eclipse.update.internal.core.FeatureDownloadException;
import org.eclipse.update.internal.operations.DuplicateConflictsValidator;
import org.eclipse.update.internal.operations.JobTargetSite;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.security.JarVerificationService;
import org.eclipse.update.internal.ui.wizards.DuplicateConflictsDialog;
import org.eclipse.update.internal.ui.wizards.ISearchProvider;
import org.eclipse.update.internal.ui.wizards.LicensePage;
import org.eclipse.update.internal.ui.wizards.ModeSelectionPage;
import org.eclipse.update.internal.ui.wizards.OptionalFeaturesPage;
import org.eclipse.update.internal.ui.wizards.ReviewPage;
import org.eclipse.update.internal.ui.wizards.SearchRunner;
import org.eclipse.update.internal.ui.wizards.SitePage;
import org.eclipse.update.internal.ui.wizards.TargetPage;

public class InstallWizard
extends Wizard
implements IOperationListener,
ISearchProvider {
    private ModeSelectionPage modePage;
    private SitePage sitePage;
    private ReviewPage reviewPage;
    private LicensePage licensePage;
    private OptionalFeaturesPage optionalFeaturesPage;
    private TargetPage targetPage;
    private IInstallConfiguration config;
    private int installCount = 0;
    private SearchRunner searchRunner;
    private UpdateSearchRequest searchRequest;
    private ArrayList jobs;
    private static boolean isRunning;

    public InstallWizard() {
        this(null);
    }

    public InstallWizard(UpdateSearchRequest searchRequest) {
        isRunning = true;
        this.searchRequest = searchRequest;
        this.setDialogSettings(UpdateUI.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(UpdateUIImages.DESC_INSTALL_WIZ);
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(UpdateUI.getString("InstallWizard.wtitle"));
    }

    public InstallWizard(UpdateSearchRequest searchRequest, ArrayList jobs) {
        this(searchRequest);
        this.jobs = jobs;
    }

    public boolean isSuccessfulInstall() {
        return this.installCount > 0;
    }

    public boolean performCancel() {
        isRunning = false;
        return super.performCancel();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        try {
            boolean retry;
            DuplicateConflictsDialog dialog;
            final IInstallFeatureOperation[] selectedJobs = this.reviewPage.getSelectedJobs();
            this.installCount = 0;
            this.saveSettings();
            ArrayList conflicts = DuplicateConflictsValidator.computeDuplicateConflicts((JobTargetSite[])this.targetPage.getTargetSites(), (IInstallConfiguration)this.config);
            if (conflicts != null && (dialog = new DuplicateConflictsDialog(this.getShell(), conflicts)).open() != 0) {
                Object var9_4 = null;
                isRunning = false;
                return false;
            }
            final JarVerificationService verificationListener = new JarVerificationService(this.getShell());
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    Object var5_7;
                    IInstallFeatureOperation[] operations = new IInstallFeatureOperation[selectedJobs.length];
                    int i = 0;
                    while (i < selectedJobs.length) {
                        IInstallFeatureOperation op;
                        IInstallFeatureOperation job = selectedJobs[i];
                        IFeature[] unconfiguredOptionalFeatures = null;
                        IFeatureReference[] optionalFeatures = null;
                        if (UpdateUtils.hasOptionalFeatures((IFeature)job.getFeature())) {
                            optionalFeatures = InstallWizard.this.optionalFeaturesPage.getCheckedOptionalFeatures(job);
                            unconfiguredOptionalFeatures = InstallWizard.this.optionalFeaturesPage.getUnconfiguredOptionalFeatures(job, InstallWizard.this.targetPage.getTargetSite(job));
                        }
                        operations[i] = op = OperationsManager.getOperationFactory().createInstallOperation(InstallWizard.this.config, InstallWizard.this.targetPage.getTargetSite(job), job.getFeature(), optionalFeatures, unconfiguredOptionalFeatures, verificationListener);
                        ++i;
                    }
                    IBatchOperation installOperation = OperationsManager.getOperationFactory().createBatchInstallOperation(operations);
                    try {
                        try {
                            installOperation.execute(monitor, (IOperationListener)InstallWizard.this);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        var5_7 = null;
                        monitor.done();
                        throw throwable;
                    }
                    monitor.done();
                }
            };
            do {
                retry = false;
                try {
                    this.getContainer().run(true, true, operation);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    if (targetException instanceof InstallAbortedException) {
                        Object var9_5 = null;
                        isRunning = false;
                        return true;
                    }
                    if (targetException instanceof FeatureDownloadException) {
                        FeatureDownloadException fde = (FeatureDownloadException)targetException;
                        retry = MessageDialog.openQuestion((Shell)this.getShell(), (String)UpdateUI.getString("InstallWizard.retryTitle"), (String)(String.valueOf(fde.getMessage()) + "\n" + UpdateUI.getString("InstallWizard.retry")));
                        if (retry) continue;
                    }
                    UpdateUI.logException(e);
                    Object var9_6 = null;
                    isRunning = false;
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    Object var9_7 = null;
                    isRunning = false;
                    return false;
                }
            } while (retry);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            isRunning = false;
            throw throwable;
        }
        Object var9_8 = null;
        isRunning = false;
        return true;
    }

    public void addPages() {
        this.searchRunner = new SearchRunner(this.getShell(), (IRunnableContext)this.getContainer());
        if (this.searchRequest == null && this.jobs == null) {
            this.modePage = new ModeSelectionPage(this.searchRunner);
            this.addPage((IWizardPage)this.modePage);
            this.sitePage = new SitePage(this.searchRunner);
            this.addPage((IWizardPage)this.sitePage);
        } else {
            this.searchRunner.setSearchProvider(this);
            if (this.jobs != null) {
                this.searchRunner.setNewSearchNeeded(false);
            }
        }
        this.reviewPage = new ReviewPage(this.searchRunner, this.jobs);
        this.searchRunner.setResultCollector(this.reviewPage);
        this.addPage((IWizardPage)this.reviewPage);
        try {
            this.config = UpdateUtils.createInstallConfiguration();
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
        }
        this.licensePage = new LicensePage(true);
        this.addPage((IWizardPage)this.licensePage);
        this.optionalFeaturesPage = new OptionalFeaturesPage(this.config);
        this.addPage((IWizardPage)this.optionalFeaturesPage);
        this.targetPage = new TargetPage(this.config);
        this.addPage((IWizardPage)this.targetPage);
    }

    private void saveSettings() {
        if (this.modePage != null) {
            this.modePage.saveSettings();
        }
    }

    private boolean isPageRequired(IWizardPage page) {
        if (page == null) {
            return false;
        }
        if (page.equals(this.licensePage)) {
            return OperationsManager.hasSelectedJobsWithLicenses((IInstallFeatureOperation[])this.reviewPage.getSelectedJobs());
        }
        if (page.equals(this.optionalFeaturesPage)) {
            return OperationsManager.hasSelectedJobsWithOptionalFeatures((IInstallFeatureOperation[])this.reviewPage.getSelectedJobs());
        }
        if (page.equals(this.targetPage)) {
            return this.reviewPage.getSelectedJobs().length > 0;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        boolean start = false;
        IWizardPage nextPage = null;
        if (this.modePage != null && page.equals(this.modePage)) {
            boolean update = this.modePage.isUpdateMode();
            if (update) {
                return this.reviewPage;
            }
            return this.sitePage;
        }
        if (this.sitePage != null && page.equals(this.sitePage)) {
            return this.reviewPage;
        }
        if (page.equals((Object)this.reviewPage)) {
            this.updateDynamicPages();
        }
        int i = 0;
        while (i < pages.length) {
            if (pages[i].equals(page)) {
                start = true;
            } else if (start && this.isPageRequired(pages[i])) {
                nextPage = pages[i];
                break;
            }
            ++i;
        }
        return nextPage;
    }

    private void updateDynamicPages() {
        if (this.licensePage != null) {
            IInstallFeatureOperation[] licenseJobs = OperationsManager.getSelectedJobsWithLicenses((IInstallFeatureOperation[])this.reviewPage.getSelectedJobs());
            this.licensePage.setJobs(licenseJobs);
        }
        if (this.optionalFeaturesPage != null) {
            IInstallFeatureOperation[] optionalJobs = OperationsManager.getSelectedJobsWithOptionalFeatures((IInstallFeatureOperation[])this.reviewPage.getSelectedJobs());
            this.optionalFeaturesPage.setJobs(optionalJobs);
        }
        if (this.targetPage != null) {
            IInstallFeatureOperation[] installJobs = this.reviewPage.getSelectedJobs();
            this.targetPage.setJobs(installJobs);
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return page.equals(this.targetPage) && page.isPageComplete();
    }

    private void preserveOriginatingURLs(IFeature feature, IFeatureReference[] optionalFeatures) {
        URL url = feature.getSite().getURL();
        try {
            IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
            int i = 0;
            while (i < irefs.length) {
                IIncludedFeatureReference iref = irefs[i];
                boolean preserve = false;
                if (iref.isOptional()) {
                    boolean onTheList = false;
                    int j = 0;
                    while (j < optionalFeatures.length) {
                        if (optionalFeatures[j].equals(iref)) {
                            onTheList = true;
                            break;
                        }
                        ++j;
                    }
                    if (!onTheList) {
                        preserve = true;
                    }
                }
                if (preserve) {
                    try {
                        String id = iref.getVersionedIdentifier().getIdentifier();
                        UpdateUI.setOriginatingURL(id, url);
                    }
                    catch (CoreException coreException) {}
                } else {
                    try {
                        IFeature ifeature = iref.getFeature(null);
                        this.preserveOriginatingURLs(ifeature, optionalFeatures);
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    public boolean afterExecute(IOperation operation, Object data) {
        if (!(operation instanceof IInstallFeatureOperation)) {
            return true;
        }
        IInstallFeatureOperation job = (IInstallFeatureOperation)operation;
        IFeature oldFeature = job.getOldFeature();
        if (oldFeature == null && job.getOptionalFeatures() != null) {
            this.preserveOriginatingURLs(job.getFeature(), job.getOptionalFeatures());
        }
        ++this.installCount;
        return true;
    }

    public boolean beforeExecute(IOperation operation, Object data) {
        return true;
    }

    public UpdateSearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public static synchronized boolean isRunning() {
        return isRunning;
    }
}

