/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.configuration.ISessionDelta;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;
import org.eclipse.update.internal.ui.parts.SWTUtil;
import org.eclipse.update.internal.ui.wizards.DeltaAdapter;
import org.eclipse.update.internal.ui.wizards.DeltaFeatureAdapter;

public class InstallDeltaWizardPage
extends WizardPage {
    private ISessionDelta[] deltas;
    private CheckboxTreeViewer deltaViewer;
    private Button deleteButton;
    private Button errorsButton;
    private ArrayList features = new ArrayList();

    public InstallDeltaWizardPage(ISessionDelta[] deltas) {
        super("installDeltaPage");
        this.deltas = deltas;
        this.setTitle(UpdateUI.getString("InstallDeltaWizard.title"));
        this.setDescription(UpdateUI.getString("InstallDeltaWizard.desc"));
        UpdateUI.getDefault().getLabelProvider().connect((Object)this);
    }

    public void dispose() {
        UpdateUI.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    private Object[] initializeFeatures() {
        ArrayList<DeltaAdapter> selection = new ArrayList<DeltaAdapter>();
        this.features = new ArrayList();
        int i = 0;
        while (i < this.deltas.length) {
            ISessionDelta delta = this.deltas[i];
            DeltaAdapter adapter = new DeltaAdapter(delta);
            this.features.add(adapter);
            selection.add(adapter);
            adapter.addFeaturesTo(selection);
            ++i;
        }
        return selection.toArray();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(UpdateUI.getString("InstallDeltaWizard.label"));
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.deltaViewer = new CheckboxTreeViewer(container, 2048);
        this.deltaViewer.setContentProvider((IContentProvider)new DeltaContentProvider());
        this.deltaViewer.setLabelProvider((IBaseLabelProvider)new DeltaLabelProvider());
        this.deltaViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                InstallDeltaWizardPage.this.handleCheckStateChanged(event.getElement(), event.getChecked());
            }
        });
        this.deltaViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                InstallDeltaWizardPage.this.updateButtons((IStructuredSelection)e.getSelection());
            }
        });
        this.deltaViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object child) {
                if (child instanceof DeltaAdapter) {
                    return !((DeltaAdapter)child).isRemoved();
                }
                return true;
            }
        });
        gd = new GridData(1808);
        this.deltaViewer.getControl().setLayoutData((Object)gd);
        Composite buttonContainer = new Composite(container, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        buttonContainer.setLayout((Layout)layout);
        this.deleteButton = new Button(buttonContainer, 8);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setText(UpdateUI.getString("InstallDeltaWizard.delete"));
        gd = new GridData(770);
        this.deleteButton.setLayoutData((Object)gd);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallDeltaWizardPage.this.handleDelete();
            }
        });
        SWTUtil.setButtonDimensionHint(this.deleteButton);
        this.errorsButton = new Button(buttonContainer, 8);
        this.errorsButton.setEnabled(false);
        this.errorsButton.setText(UpdateUI.getString("InstallDeltaWizard.errors"));
        gd = new GridData(770);
        this.errorsButton.setLayoutData((Object)gd);
        this.errorsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallDeltaWizardPage.this.handleShowErrors();
            }
        });
        SWTUtil.setButtonDimensionHint(this.errorsButton);
        Object[] checked = this.initializeFeatures();
        this.deltaViewer.setInput((Object)this);
        this.deltaViewer.setCheckedElements(checked);
        this.dialogChanged();
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.update.ui.InstallDeltaWizardPage");
        this.setControl((Control)container);
    }

    private void updateButtons(IStructuredSelection selection) {
        Object obj;
        boolean enableDelete;
        boolean enableShowErrors = false;
        boolean bl = enableDelete = selection.size() > 0;
        if (selection.size() == 1 && (obj = selection.getFirstElement()) instanceof DeltaAdapter) {
            boolean bl2 = enableShowErrors = ((DeltaAdapter)obj).getStatus() != null;
        }
        if (enableDelete) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object obj2 = iter.next();
                if (obj2 instanceof DeltaAdapter) continue;
                enableDelete = false;
                break;
            }
        }
        this.deleteButton.setEnabled(enableDelete);
        this.errorsButton.setEnabled(enableShowErrors);
    }

    private void handleDelete() {
        IStructuredSelection selection = (IStructuredSelection)this.deltaViewer.getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof DeltaAdapter)) continue;
            ((DeltaAdapter)obj).setRemoved(true);
        }
        this.deltaViewer.refresh();
        this.dialogChanged();
    }

    private void handleShowErrors() {
        IStructuredSelection sel = (IStructuredSelection)this.deltaViewer.getSelection();
        DeltaAdapter adapter = (DeltaAdapter)sel.getFirstElement();
        IStatus status = adapter.getStatus();
        this.setPageComplete(status == null || status.getCode() == 2);
        ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)status);
    }

    private void handleCheckStateChanged(Object obj, boolean checked) {
        if (obj instanceof DeltaFeatureAdapter) {
            DeltaFeatureAdapter dfeature = (DeltaFeatureAdapter)obj;
            dfeature.setSelected(checked);
            DeltaAdapter adapter = dfeature.getDeltaAdapter();
            this.deltaViewer.setGrayed((Object)adapter, adapter.isMixedSelection());
            this.deltaViewer.setChecked((Object)adapter, adapter.isSelected());
            adapter.resetStatus();
            this.deltaViewer.update((Object)adapter, null);
        } else if (obj instanceof DeltaAdapter) {
            DeltaAdapter adapter = (DeltaAdapter)obj;
            adapter.setSelected(checked);
            this.deltaViewer.setGrayed((Object)adapter, false);
            this.computeCheckedElements();
        }
        this.dialogChanged();
    }

    private void computeCheckedElements() {
        ArrayList<Object> checked = new ArrayList<Object>();
        int i = 0;
        while (i < this.features.size()) {
            DeltaAdapter adapter = (DeltaAdapter)this.features.get(i);
            if (!adapter.isRemoved() && adapter.isSelected()) {
                checked.add(adapter);
                DeltaFeatureAdapter[] df = adapter.getFeatures();
                int j = 0;
                while (j < df.length) {
                    if (df[j].isSelected()) {
                        checked.add(df[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.deltaViewer.setCheckedElements(checked.toArray());
    }

    private void dialogChanged() {
        int nremoved = 0;
        int nselected = 0;
        int errors = 0;
        int warnings = 0;
        String message = null;
        int i = 0;
        while (i < this.features.size()) {
            DeltaAdapter adapter = (DeltaAdapter)this.features.get(i);
            if (adapter.isRemoved()) {
                ++nremoved;
            } else if (adapter.isSelected()) {
                ++nselected;
                IStatus status = adapter.getStatus();
                if (status != null && status.getCode() == 2) {
                    ++warnings;
                    message = status.getMessage();
                } else if (status != null && status.getCode() == 4) {
                    ++errors;
                }
            }
            ++i;
        }
        this.setPageComplete(errors == 0 && (nremoved > 0 || nselected > 0));
        if (errors > 0) {
            this.setErrorMessage(UpdateUI.getString("InstallDeltaWizard.message"));
        } else if (warnings > 0) {
            this.setErrorMessage(null);
            this.setMessage(message, 2);
        } else {
            this.setErrorMessage(null);
        }
    }

    public DeltaAdapter[] getDeltaAdapters() {
        return this.features.toArray(new DeltaAdapter[this.features.size()]);
    }

    class DeltaContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        DeltaContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return parent instanceof DeltaAdapter;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof DeltaAdapter) {
                return ((DeltaAdapter)parent).getFeatures();
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (child instanceof DeltaFeatureAdapter) {
                return ((DeltaFeatureAdapter)child).getDeltaAdapter();
            }
            return null;
        }

        public Object[] getElements(Object input) {
            return InstallDeltaWizardPage.this.features.toArray();
        }
    }

    class DeltaLabelProvider
    extends LabelProvider {
        DeltaLabelProvider() {
        }

        public Image getImage(Object obj) {
            if (obj instanceof DeltaAdapter) {
                int flags = 0;
                DeltaAdapter adapter = (DeltaAdapter)obj;
                if (adapter.getStatus() != null) {
                    flags = 1;
                }
                return UpdateUI.getDefault().getLabelProvider().get(UpdateUIImages.DESC_UPDATES_OBJ, flags);
            }
            if (obj instanceof DeltaFeatureAdapter) {
                return UpdateUI.getDefault().getLabelProvider().get(UpdateUIImages.DESC_FEATURE_OBJ);
            }
            return super.getImage(obj);
        }
    }
}

