/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.configuration.IInstallDeltaHandler;
import org.eclipse.update.configuration.ISessionDelta;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.parts.SWTUtil;
import org.eclipse.update.internal.ui.wizards.DeltaAdapter;
import org.eclipse.update.internal.ui.wizards.InstallDeltaWizardPage;

public class InstallDeltaWizard
extends Wizard
implements IInstallDeltaHandler {
    private ISessionDelta[] deltas;
    private InstallDeltaWizardPage page;
    private int processed = 0;

    public InstallDeltaWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(UpdateUI.getString("InstallDeltaWizard.wtitle"));
        this.setDefaultPageImageDescriptor(UpdateUIImages.DESC_UPDATE_WIZ);
    }

    public void addPages() {
        this.page = new InstallDeltaWizardPage(this.deltas);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final DeltaAdapter[] adapters = this.page.getDeltaAdapters();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        InstallDeltaWizard.this.doFinish(adapters, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InvocationTargetException e) {
            UpdateUI.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public boolean performCancel() {
        if (UpdateUI.getRemindOnCancel()) {
            MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)this.getWindowTitle(), (String)UpdateUI.getString("InstallDeltaWizard.reminder"));
        }
        return super.performCancel();
    }

    private void analyzeAdapters(DeltaAdapter[] adapters, ArrayList selected, ArrayList removed) {
        int i = 0;
        while (i < adapters.length) {
            DeltaAdapter adapter = adapters[i];
            if (adapter.isRemoved()) {
                removed.add(adapter);
            } else if (adapter.isSelected()) {
                selected.add(adapter);
            }
            ++i;
        }
    }

    private void doFinish(DeltaAdapter[] adapters, IProgressMonitor monitor) throws CoreException {
        ISessionDelta delta;
        DeltaAdapter adapter;
        ArrayList selectedDeltas = new ArrayList();
        ArrayList removedDeltas = new ArrayList();
        this.analyzeAdapters(adapters, selectedDeltas, removedDeltas);
        monitor.beginTask(UpdateUI.getString("InstallDeltaWizard.processing"), selectedDeltas.size() + removedDeltas.size());
        this.processed = 0;
        int i = 0;
        while (i < removedDeltas.size()) {
            adapter = (DeltaAdapter)removedDeltas.get(i);
            delta = adapter.getDelta();
            delta.delete();
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            ++i;
        }
        i = 0;
        while (i < selectedDeltas.size()) {
            adapter = (DeltaAdapter)selectedDeltas.get(i);
            delta = adapter.getDelta();
            IFeatureReference[] refs = delta.getFeatureReferences();
            delta.process(refs, monitor);
            monitor.worked(1);
            ++this.processed;
            if (monitor.isCanceled()) {
                return;
            }
            ++i;
        }
    }

    public void init(ISessionDelta[] deltas) {
        this.deltas = deltas;
    }

    public void open() {
        BusyIndicator.showWhile((Display)SWTUtil.getStandardDisplay(), (Runnable)new Runnable(){

            public void run() {
                WizardDialog dialog = new WizardDialog(UpdateUI.getActiveWorkbenchShell(), (IWizard)InstallDeltaWizard.this);
                dialog.create();
                dialog.getShell().setSize(500, 500);
                dialog.open();
                if (InstallDeltaWizard.this.processed > 0) {
                    UpdateUI.requestRestart();
                }
            }
        });
    }
}

