/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import org.eclipse.update.configuration.ISessionDelta;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.wizards.DeltaAdapter;

public class DeltaFeatureAdapter {
    private IFeatureReference ref;
    private IFeature feature;
    private DeltaAdapter deltaAdapter;
    private boolean selected;
    private boolean duplicate;

    public DeltaFeatureAdapter(DeltaAdapter deltaAdapter, IFeatureReference ref, IFeature feature) {
        this.ref = ref;
        this.feature = feature;
        this.deltaAdapter = deltaAdapter;
    }

    public DeltaAdapter getDeltaAdapter() {
        return this.deltaAdapter;
    }

    public ISessionDelta getDelta() {
        return this.deltaAdapter.getDelta();
    }

    public IFeatureReference getFeatureReference() {
        return this.ref;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.deltaAdapter.featureSelected(selected);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public String toString() {
        if (this.duplicate) {
            return UpdateUI.getFormattedMessage("DeltaFeatureAdapter.longName", new String[]{this.feature.getLabel(), this.feature.getVersionedIdentifier().getVersion().toString(), this.feature.getSite().getURL().toString()});
        }
        return UpdateUI.getFormattedMessage("DeltaFeatureAdapter.shortName", new String[]{this.feature.getLabel(), this.feature.getVersionedIdentifier().getVersion().toString()});
    }
}

