/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.configuration.ISessionDelta;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.ui.model.MissingFeature;
import org.eclipse.update.internal.ui.wizards.DeltaFeatureAdapter;

public class DeltaAdapter {
    private ISessionDelta delta;
    private DeltaFeatureAdapter[] dfeatures;
    private boolean removed;
    private IStatus status;
    private boolean statusComputed;
    private String name;
    private boolean selectionBlocked;

    public DeltaAdapter(ISessionDelta delta) {
        this.delta = delta;
        this.name = Utilities.format((Date)delta.getDate());
    }

    public ISessionDelta getDelta() {
        return this.delta;
    }

    public String toString() {
        return this.name;
    }

    public DeltaFeatureAdapter[] getFeatures() {
        if (this.dfeatures == null) {
            this.initializeFeatures();
        }
        return this.dfeatures;
    }

    public void addFeaturesTo(ArrayList list) {
        DeltaFeatureAdapter[] array = this.getFeatures();
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
    }

    public void setSelected(boolean value) {
        DeltaFeatureAdapter[] adapters = this.getFeatures();
        boolean stateChange = false;
        this.selectionBlocked = true;
        int i = 0;
        while (i < adapters.length) {
            DeltaFeatureAdapter adapter = adapters[i];
            if (adapter.isSelected() != value) {
                adapter.setSelected(value);
                stateChange = true;
            }
            ++i;
        }
        this.selectionBlocked = false;
        if (value && stateChange) {
            this.resetStatus();
        }
    }

    void featureSelected(boolean selected) {
        if (this.selectionBlocked) {
            return;
        }
        int count = this.getSelectionCount();
        selected = count > 0;
    }

    public int getSelectionCount() {
        DeltaFeatureAdapter[] adapters = this.getFeatures();
        int count = 0;
        int i = 0;
        while (i < adapters.length) {
            DeltaFeatureAdapter adapter = adapters[i];
            if (adapter.isSelected()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public boolean isMixedSelection() {
        int count = this.getSelectionCount();
        return count > 0 && count < this.getFeatures().length;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
        this.setSelected(false);
    }

    public boolean isSelected() {
        return this.getSelectionCount() > 0;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public IStatus getStatus() {
        if (!this.statusComputed) {
            this.computeStatus();
        }
        return this.status;
    }

    public IFeatureReference[] getSelectedReferences() {
        ArrayList<IFeatureReference> refs = new ArrayList<IFeatureReference>();
        DeltaFeatureAdapter[] adapters = this.getFeatures();
        int i = 0;
        while (i < adapters.length) {
            DeltaFeatureAdapter adapter = adapters[i];
            if (adapter.isSelected()) {
                refs.add(adapter.getFeatureReference());
            }
            ++i;
        }
        return refs.toArray(new IFeatureReference[refs.size()]);
    }

    public void resetStatus() {
        this.statusComputed = false;
    }

    private void computeStatus() {
        IFeatureReference[] refs = this.getSelectedReferences();
        this.status = OperationsManager.getValidator().validateSessionDelta(this.delta, refs);
        this.statusComputed = true;
    }

    public boolean isValid() {
        return this.getStatus() == null || this.status.getCode() == 2;
    }

    private void initializeFeatures() {
        IFeatureReference[] references = this.delta.getFeatureReferences();
        this.dfeatures = new DeltaFeatureAdapter[references.length];
        this.selectionBlocked = true;
        int i = 0;
        while (i < references.length) {
            IFeature feature;
            IFeatureReference reference = references[i];
            DeltaFeatureAdapter dfeature = null;
            DeltaFeatureAdapter duplicate = this.findDuplicate(reference, this.dfeatures);
            try {
                feature = reference.getFeature(null);
                dfeature = new DeltaFeatureAdapter(this, reference, feature);
                dfeature.setSelected(true);
            }
            catch (CoreException coreException) {
                feature = new MissingFeature(reference.getSite(), reference.getURL());
                dfeature = new DeltaFeatureAdapter(this, reference, feature);
            }
            if (duplicate != null) {
                dfeature.setDuplicate(true);
                duplicate.setDuplicate(true);
            }
            this.dfeatures[i] = dfeature;
            ++i;
        }
        this.selectionBlocked = false;
    }

    private DeltaFeatureAdapter findDuplicate(IFeatureReference reference, DeltaFeatureAdapter[] dfeatures) {
        int i = 0;
        while (i < dfeatures.length) {
            DeltaFeatureAdapter prev = dfeatures[i];
            if (prev == null) {
                return null;
            }
            try {
                if (reference.getVersionedIdentifier().equals((Object)prev.getFeatureReference().getVersionedIdentifier())) {
                    return prev;
                }
            }
            catch (CoreException coreException) {
                return null;
            }
            ++i;
        }
        return null;
    }
}

