/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.util.Date;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;

public class ActivitiesTableViewer {
    public static TableViewer createViewer(Composite parent) {
        Table table = new Table(parent, 2048);
        table.setLayoutData((Object)new GridData(1040));
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column = new TableColumn(table, 0);
        column.setText(UpdateUI.getString("ActivitiesTableViewer.date"));
        column = new TableColumn(table, 0);
        column.setText(UpdateUI.getString("ActivitiesTableViewer.target"));
        column = new TableColumn(table, 0);
        column.setText(UpdateUI.getString("ActivitiesTableViewer.action"));
        TableViewer activitiesViewer = new TableViewer(table);
        activitiesViewer.setLabelProvider((IBaseLabelProvider)new ActivitiesLabelProvider());
        activitiesViewer.setContentProvider((IContentProvider)new ActivitiesContentProvider());
        return activitiesViewer;
    }

    static class ActivitiesContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ActivitiesContentProvider() {
        }

        public Object[] getElements(Object element) {
            return ((IInstallConfiguration)element).getActivities();
        }
    }

    static class ActivitiesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ActivitiesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
                switch (((IActivity)element).getStatus()) {
                    case 0: {
                        return provider.get(UpdateUIImages.DESC_OK_ST_OBJ, 0);
                    }
                    case 1: {
                        return provider.get(UpdateUIImages.DESC_ERR_ST_OBJ, 0);
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IActivity activity = (IActivity)element;
            switch (columnIndex) {
                case 1: {
                    return Utilities.format((Date)activity.getDate());
                }
                case 2: {
                    return activity.getLabel();
                }
                case 3: {
                    return this.getActionLabel(activity);
                }
            }
            return "";
        }

        private String getActionLabel(IActivity activity) {
            int action = activity.getAction();
            switch (action) {
                case 6: {
                    return UpdateUI.getString("ActivitiesTableViewer.enabled");
                }
                case 1: {
                    return UpdateUI.getString("ActivitiesTableViewer.featureInstalled");
                }
                case 2: {
                    return UpdateUI.getString("ActivitiesTableViewer.featureRemoved");
                }
                case 3: {
                    return UpdateUI.getString("ActivitiesTableViewer.siteInstalled");
                }
                case 4: {
                    return UpdateUI.getString("ActivitiesTableViewer.siteRemoved");
                }
                case 5: {
                    return UpdateUI.getString("ActivitiesTableViewer.disabled");
                }
                case 7: {
                    return UpdateUI.getString("ActivitiesTableViewer.revert");
                }
                case 8: {
                    return UpdateUI.getString("ActivitiesTableViewer.reconcile");
                }
            }
            return UpdateUI.getString("ActivitiesTableViewer.unknown");
        }
    }
}

