/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.wizards.TargetPage;

public class NewExtensionLocationAction
extends Action {
    public NewExtensionLocationAction(String text, ImageDescriptor desc) {
        super(text, desc);
    }

    public void run() {
        DirectoryDialog dialog = new DirectoryDialog(UpdateUI.getActiveWorkbenchShell());
        dialog.setMessage(UpdateUI.getString("NewExtensionLocationAction.selectExtLocation"));
        String dir = dialog.open();
        while (dir != null) {
            File dirFile = new File(dir);
            boolean valid = NewExtensionLocationAction.isExtensionRoot(dirFile);
            if (valid) {
                this.addExtensionLocation(dirFile);
                return;
            }
            MessageDialog.openInformation((Shell)UpdateUI.getActiveWorkbenchShell(), (String)UpdateUI.getString("NewExtensionLocationAction.extInfoTitle"), (String)UpdateUI.getString("NewExtensionLocationAction.extInfoMessage"));
            dialog.setFilterPath(dir);
            dir = dialog.open();
        }
    }

    static boolean isExtensionRoot(File directory) {
        File marker = new File(directory, ".eclipseextension");
        return marker.exists() && !marker.isDirectory();
    }

    private void addExtensionLocation(File dir) {
        try {
            IInstallConfiguration config = UpdateUtils.createInstallConfiguration();
            if (TargetPage.addConfiguredSite(UpdateUI.getActiveWorkbenchShell(), config, dir, true) != null) {
                UpdateUtils.makeConfigurationCurrent((IInstallConfiguration)config, null);
                UpdateUtils.saveLocalSite();
                UpdateUI.requestRestart();
            }
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
        }
    }
}

