/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.api.search.IUpdateSearchCategory;
import org.eclipse.update.internal.api.search.UpdateSearchRequest;
import org.eclipse.update.internal.api.search.UpdateSearchScope;
import org.eclipse.update.internal.search.OptionalFeatureSearchCategory;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.MissingFeature;
import org.eclipse.update.internal.ui.wizards.InstallWizard;
import org.eclipse.update.internal.ui.wizards.ResizableWizardDialog;

public class InstallOptionalFeatureAction
extends Action {
    private static final String KEY_OPTIONAL_INSTALL_TITLE = "FeaturePage.optionalInstall.title";
    private MissingFeature missingFeature;
    private Shell shell;

    public InstallOptionalFeatureAction(Shell shell, String text) {
        super(text);
        this.shell = shell;
    }

    public void setFeature(MissingFeature feature) {
        this.missingFeature = feature;
    }

    public void run() {
        if (this.missingFeature == null) {
            return;
        }
        if (OperationsManager.getValidator().validateCurrentState() != null && !this.confirm(UpdateUI.getString("Actions.brokenConfigQuestion"))) {
            return;
        }
        VersionedIdentifier vid = this.missingFeature.getVersionedIdentifier();
        URL originatingURL = this.missingFeature.getOriginatingSiteURL();
        UpdateSearchScope scope = new UpdateSearchScope();
        scope.addSearchSite(originatingURL.toString(), originatingURL, null);
        OptionalFeatureSearchCategory category = new OptionalFeatureSearchCategory();
        category.addVersionedIdentifier(vid);
        final UpdateSearchRequest searchRequest = new UpdateSearchRequest((IUpdateSearchCategory)category, scope);
        BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                InstallOptionalFeatureAction.this.openWizard(searchRequest);
            }
        });
    }

    private void openWizard(UpdateSearchRequest searchRequest) {
        InstallWizard wizard = new InstallWizard(searchRequest);
        ResizableWizardDialog dialog = new ResizableWizardDialog(this.shell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setText(UpdateUI.getString(KEY_OPTIONAL_INSTALL_TITLE));
        dialog.getShell().setSize(600, 500);
        dialog.open();
        if (wizard.isSuccessfulInstall()) {
            UpdateUI.requestRestart();
        }
    }

    private boolean confirm(String message) {
        return MessageDialog.openConfirm((Shell)UpdateUI.getActiveWorkbenchShell(), (String)UpdateUI.getString("FeatureStateAction.dialogTitle"), (String)message);
    }
}

