/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.api.search.UpdateSearchRequest;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.wizards.InstallWizard;
import org.eclipse.update.internal.ui.wizards.ResizableWizardDialog;

public class FindUpdatesAction
extends Action {
    private IFeature feature;
    private Shell shell;

    public FindUpdatesAction(Shell shell, String text) {
        super(text);
        this.shell = shell;
    }

    public void setFeature(IFeature feature) {
        this.feature = feature;
    }

    public void run() {
        if (OperationsManager.getValidator().validateCurrentState() != null && !this.confirm(UpdateUI.getString("Actions.brokenConfigQuestion"))) {
            return;
        }
        IFeature[] features = null;
        if (this.feature != null) {
            features = new IFeature[]{this.feature};
        }
        final UpdateSearchRequest searchRequest = UpdateUtils.createNewUpdatesRequest((IFeature[])features);
        BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                InstallWizard wizard = new InstallWizard(searchRequest);
                ResizableWizardDialog dialog = new ResizableWizardDialog(FindUpdatesAction.this.shell, (IWizard)wizard);
                dialog.create();
                dialog.getShell().setText(UpdateUI.getString("FindUpdatesAction.updates"));
                dialog.getShell().setSize(600, 500);
                dialog.open();
                if (wizard.isSuccessfulInstall()) {
                    UpdateUI.requestRestart();
                }
            }
        });
    }

    private boolean confirm(String message) {
        return MessageDialog.openConfirm((Shell)UpdateUI.getActiveWorkbenchShell(), (String)UpdateUI.getString("FeatureStateAction.dialogTitle"), (String)message);
    }
}

