/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.api.operations.IOperation;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.ConfiguredFeatureAdapter;

public class FeatureStateAction
extends Action {
    private ConfiguredFeatureAdapter adapter;

    public void setFeature(ConfiguredFeatureAdapter adapter) {
        this.adapter = adapter;
        if (adapter.isConfigured()) {
            this.setText(UpdateUI.getString("FeatureStateAction.disable"));
        } else {
            this.setText(UpdateUI.getString("FeatureStateAction.enable"));
        }
    }

    public void run() {
        try {
            String message;
            if (this.adapter == null) {
                return;
            }
            boolean isConfigured = this.adapter.isConfigured();
            String string = message = isConfigured ? UpdateUI.getString("FeatureStateAction.disableQuestion") : UpdateUI.getString("FeatureStateAction.EnableQuestion");
            if (!this.confirm(message)) {
                return;
            }
            if (OperationsManager.getValidator().validateCurrentState() != null && !this.confirm(UpdateUI.getString("Actions.brokenConfigQuestion"))) {
                return;
            }
            Object toggleOperation = isConfigured ? (IOperation)OperationsManager.getOperationFactory().createUnconfigOperation(this.adapter.getInstallConfiguration(), this.adapter.getConfiguredSite(), this.adapter.getFeature(null)) : OperationsManager.getOperationFactory().createConfigOperation(this.adapter.getInstallConfiguration(), this.adapter.getConfiguredSite(), this.adapter.getFeature(null));
            boolean restartNeeded = toggleOperation.execute(null, null);
            if (restartNeeded) {
                UpdateUI.requestRestart();
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)UpdateUI.getActiveWorkbenchShell(), null, null, (IStatus)e.getStatus());
        }
        catch (InvocationTargetException e) {
            UpdateUtils.logException((Throwable)e.getTargetException());
        }
    }

    private boolean confirm(String message) {
        return MessageDialog.openConfirm((Shell)UpdateUI.getActiveWorkbenchShell(), (String)UpdateUI.getString("FeatureStateAction.dialogTitle"), (String)message);
    }
}

