/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IConfiguredSiteChangedListener;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.IInstallConfigurationChangedListener;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configuration.ILocalSiteChangedListener;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.api.operations.IUpdateModelChangedListener;
import org.eclipse.update.internal.api.operations.OperationsManager;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.ConfigurationManagerWindow;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.model.ConfiguredFeatureAdapter;
import org.eclipse.update.internal.ui.model.ConfiguredSiteAdapter;
import org.eclipse.update.internal.ui.model.IConfiguredSiteAdapter;
import org.eclipse.update.internal.ui.model.IFeatureAdapter;
import org.eclipse.update.internal.ui.model.MissingFeature;
import org.eclipse.update.internal.ui.model.UpdateModel;
import org.eclipse.update.internal.ui.parts.AboutInfo;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;
import org.eclipse.update.internal.ui.parts.SWTUtil;
import org.eclipse.update.internal.ui.views.ConfigurationPreview;
import org.eclipse.update.internal.ui.views.DetectedChangesAction;
import org.eclipse.update.internal.ui.views.FeatureStateAction;
import org.eclipse.update.internal.ui.views.FindUpdatesAction;
import org.eclipse.update.internal.ui.views.IPreviewTask;
import org.eclipse.update.internal.ui.views.InstallOptionalFeatureAction;
import org.eclipse.update.internal.ui.views.InstallationHistoryAction;
import org.eclipse.update.internal.ui.views.NewExtensionLocationAction;
import org.eclipse.update.internal.ui.views.ReplaceVersionAction;
import org.eclipse.update.internal.ui.views.RevertConfigurationAction;
import org.eclipse.update.internal.ui.views.SiteStateAction;
import org.eclipse.update.internal.ui.views.UninstallFeatureAction;

public class ConfigurationView
implements IInstallConfigurationChangedListener,
IConfiguredSiteChangedListener,
ILocalSiteChangedListener {
    private TreeViewer treeViewer;
    private DrillDownAdapter drillDownAdapter;
    private Action collapseAllAction;
    private static final String STATE_SHOW_UNCONF = "ConfigurationView.showUnconf";
    private static final String STATE_SHOW_SITES = "ConfigurationView.showSites";
    private static final String STATE_SHOW_NESTED_FEATURES = "ConfigurationView.showNestedFeatures";
    private Action showSitesAction;
    private Action showNestedFeaturesAction;
    private ReplaceVersionAction swapVersionAction;
    private FeatureStateAction featureStateAction;
    private UninstallFeatureAction uninstallFeatureAction;
    private InstallOptionalFeatureAction installOptFeatureAction;
    private Action showUnconfFeaturesAction;
    private RevertConfigurationAction revertAction;
    private Action propertiesAction;
    private SiteStateAction siteStateAction;
    private Action installationHistoryAction;
    private Action newExtensionLocationAction;
    private Action detectedChangesAction;
    private FindUpdatesAction findUpdatesAction;
    private SashForm splitter;
    private ConfigurationPreview preview;
    private Hashtable previewTasks;
    private IUpdateModelChangedListener modelListener;
    private boolean refreshLock = false;
    private Image eclipseImage;
    private boolean initialized;
    private ConfigurationManagerWindow configurationWindow;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ConfigurationView(ConfigurationManagerWindow window) {
        UpdateUI.getDefault().getLabelProvider().connect(this);
        this.initializeImages();
        this.configurationWindow = window;
    }

    private void initializeImages() {
        ImageDescriptor edesc = UpdateUIImages.DESC_APP_OBJ;
        AboutInfo info = UpdateUI.getDefault().getAboutInfo();
        if (info.getWindowImage() != null) {
            edesc = info.getWindowImage();
        }
        this.eclipseImage = UpdateUI.getDefault().getLabelProvider().get(edesc);
    }

    public void initProviders() {
        this.treeViewer.setContentProvider((IContentProvider)new LocalSiteProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LocalSiteLabelProvider());
        this.treeViewer.setInput((Object)UpdateUI.getDefault().getUpdateModel());
        this.treeViewer.setSorter((ViewerSorter)new ConfigurationSorter());
        ILocalSite localSite = this.getLocalSite();
        if (localSite != null) {
            localSite.addLocalSiteChangedListener((ILocalSiteChangedListener)this);
        }
        this.modelListener = new IUpdateModelChangedListener(){

            public void objectsAdded(Object parent, Object[] children) {
            }

            public void objectsRemoved(Object parent, Object[] children) {
            }

            public void objectChanged(Object obj, String property) {
                if (ConfigurationView.this.refreshLock) {
                    return;
                }
                Control control = ConfigurationView.this.getControl();
                if (!control.isDisposed()) {
                    control.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ConfigurationView.access$9(1.access$0(this.this$1)).refresh();
                            1.access$0(this.this$1).handleSelectionChanged((IStructuredSelection)ConfigurationView.access$9(1.access$0(this.this$1)).getSelection());
                        }
                    });
                }
            }

            static /* synthetic */ ConfigurationView access$0(1 var0) {
                return var0.ConfigurationView.this;
            }
        };
        OperationsManager.addUpdateModelChangedListener((IUpdateModelChangedListener)this.modelListener);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.update.ui.ConfigurationView");
    }

    private ILocalSite getLocalSite() {
        try {
            return SiteManager.getLocalSite();
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
            return null;
        }
    }

    private Object[] openLocalSite() {
        final Object[][] bag = new Object[1][];
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ILocalSite localSite = ConfigurationView.this.getLocalSite();
                if (localSite == null) {
                    return;
                }
                IInstallConfiguration config = ConfigurationView.this.getLocalSite().getCurrentConfiguration();
                IConfiguredSite[] sites = config.getConfiguredSites();
                Object[] result = new Object[sites.length];
                int i = 0;
                while (i < sites.length) {
                    result[i] = new ConfiguredSiteAdapter(config, sites[i]);
                    ++i;
                }
                if (!ConfigurationView.this.initialized) {
                    config.addInstallConfigurationChangedListener((IInstallConfigurationChangedListener)ConfigurationView.this);
                    ConfigurationView.this.initialized = true;
                }
                bag[0] = result;
            }
        });
        return bag[0];
    }

    public void dispose() {
        UpdateUI.getDefault().getLabelProvider().disconnect(this);
        if (this.initialized) {
            ILocalSite localSite = this.getLocalSite();
            if (localSite != null) {
                localSite.removeLocalSiteChangedListener((ILocalSiteChangedListener)this);
                IInstallConfiguration config = localSite.getCurrentConfiguration();
                config.removeInstallConfigurationChangedListener((IInstallConfigurationChangedListener)this);
            }
            this.initialized = false;
        }
        OperationsManager.removeUpdateModelChangedListener((IUpdateModelChangedListener)this.modelListener);
        if (this.preview != null) {
            this.preview.dispose();
        }
    }

    protected void makeActions() {
        this.collapseAllAction = new Action(){

            public void run() {
                ConfigurationView.this.treeViewer.getControl().setRedraw(false);
                ConfigurationView.this.treeViewer.collapseToLevel(ConfigurationView.this.treeViewer.getInput(), -1);
                ConfigurationView.this.treeViewer.getControl().setRedraw(true);
            }
        };
        this.collapseAllAction.setText(UpdateUI.getString("ConfigurationView.collapseLabel"));
        this.collapseAllAction.setToolTipText(UpdateUI.getString("ConfigurationView.collapseTooltip"));
        this.collapseAllAction.setImageDescriptor(UpdateUIImages.DESC_COLLAPSE_ALL);
        this.drillDownAdapter = new DrillDownAdapter(this.treeViewer);
        this.featureStateAction = new FeatureStateAction();
        this.siteStateAction = new SiteStateAction();
        this.revertAction = new RevertConfigurationAction(UpdateUI.getString("ConfigurationView.revertLabel"));
        WorkbenchHelp.setHelp((IAction)this.revertAction, (String)"org.eclipse.update.ui.CofigurationView_revertAction");
        this.installationHistoryAction = new InstallationHistoryAction(UpdateUI.getString("ConfigurationView.installHistory"), UpdateUIImages.DESC_HISTORY_OBJ);
        this.installationHistoryAction.setToolTipText(this.installationHistoryAction.getText());
        this.newExtensionLocationAction = new NewExtensionLocationAction(UpdateUI.getString("ConfigurationView.extLocation"), UpdateUIImages.DESC_ESITE_OBJ);
        this.detectedChangesAction = new DetectedChangesAction(UpdateUI.getString("ConfigurationView.detectedChanges"));
        this.propertiesAction = new PropertyDialogAction(UpdateUI.getActiveWorkbenchShell(), (ISelectionProvider)this.treeViewer);
        WorkbenchHelp.setHelp((IAction)this.propertiesAction, (String)"org.eclipse.update.ui.CofigurationView_propertiesAction");
        this.uninstallFeatureAction = new UninstallFeatureAction(UpdateUI.getString("ConfigurationView.uninstall"));
        this.installOptFeatureAction = new InstallOptionalFeatureAction(this.getControl().getShell(), UpdateUI.getString("ConfigurationView.install"));
        this.swapVersionAction = new ReplaceVersionAction(UpdateUI.getString("ConfigurationView.anotherVersion"));
        this.findUpdatesAction = new FindUpdatesAction(this.getControl().getShell(), UpdateUI.getString("ConfigurationView.findUpdates"));
        this.makeShowUnconfiguredFeaturesAction();
        this.makeShowSitesAction();
        this.makeShowNestedFeaturesAction();
        this.makePreviewTasks();
        this.configurationWindow.setPropertiesActionHandler((IAction)this.propertiesAction);
    }

    private void makeShowNestedFeaturesAction() {
        final Preferences pref = UpdateUI.getDefault().getPluginPreferences();
        pref.setDefault(STATE_SHOW_NESTED_FEATURES, true);
        this.showNestedFeaturesAction = new Action(){

            public void run() {
                ConfigurationView.this.treeViewer.refresh();
                pref.setValue(ConfigurationView.STATE_SHOW_NESTED_FEATURES, ConfigurationView.this.showNestedFeaturesAction.isChecked());
            }
        };
        this.showNestedFeaturesAction.setText(UpdateUI.getString(STATE_SHOW_NESTED_FEATURES));
        this.showNestedFeaturesAction.setImageDescriptor(UpdateUIImages.DESC_SHOW_HIERARCHY);
        this.showNestedFeaturesAction.setHoverImageDescriptor(UpdateUIImages.DESC_SHOW_HIERARCHY_H);
        this.showNestedFeaturesAction.setDisabledImageDescriptor(UpdateUIImages.DESC_SHOW_HIERARCHY_D);
        this.showNestedFeaturesAction.setChecked(pref.getBoolean(STATE_SHOW_NESTED_FEATURES));
        this.showNestedFeaturesAction.setToolTipText(UpdateUI.getString("ConfigurationView.showNestedTooltip"));
    }

    private void makeShowSitesAction() {
        final Preferences pref = UpdateUI.getDefault().getPluginPreferences();
        pref.setDefault(STATE_SHOW_SITES, true);
        this.showSitesAction = new Action(){

            public void run() {
                ConfigurationView.this.treeViewer.refresh();
                pref.setValue(ConfigurationView.STATE_SHOW_SITES, ConfigurationView.this.showSitesAction.isChecked());
                UpdateUI.getDefault().savePluginPreferences();
            }
        };
        this.showSitesAction.setText(UpdateUI.getString("ConfigurationView.showInstall"));
        this.showSitesAction.setImageDescriptor(UpdateUIImages.DESC_LSITE_OBJ);
        this.showSitesAction.setChecked(pref.getBoolean(STATE_SHOW_SITES));
        this.showSitesAction.setToolTipText(UpdateUI.getString("ConfigurationView.showInstallTooltip"));
    }

    private void makeShowUnconfiguredFeaturesAction() {
        final Preferences pref = UpdateUI.getDefault().getPluginPreferences();
        pref.setDefault(STATE_SHOW_UNCONF, false);
        this.showUnconfFeaturesAction = new Action(){

            public void run() {
                pref.setValue(ConfigurationView.STATE_SHOW_UNCONF, ConfigurationView.this.showUnconfFeaturesAction.isChecked());
                UpdateUI.getDefault().savePluginPreferences();
                ConfigurationView.this.treeViewer.refresh();
            }
        };
        WorkbenchHelp.setHelp((IAction)this.showUnconfFeaturesAction, (String)"org.eclipse.update.ui.CofigurationView_showUnconfFeaturesAction");
        this.showUnconfFeaturesAction.setText(UpdateUI.getString("ConfigurationView.showDisabled"));
        this.showUnconfFeaturesAction.setImageDescriptor(UpdateUIImages.DESC_UNCONF_FEATURE_OBJ);
        this.showUnconfFeaturesAction.setChecked(pref.getBoolean(STATE_SHOW_UNCONF));
        this.showUnconfFeaturesAction.setToolTipText(UpdateUI.getString("ConfigurationView.showDisabledTooltip"));
    }

    protected void fillActionBars(ToolBarManager tbm) {
        tbm.add((IAction)this.showSitesAction);
        tbm.add((IAction)this.showNestedFeaturesAction);
        tbm.add((IAction)this.showUnconfFeaturesAction);
        tbm.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions((IToolBarManager)tbm);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.collapseAllAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.installationHistoryAction);
    }

    protected Object getSelectedObject() {
        IStructuredSelection ssel;
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (ssel = (IStructuredSelection)selection).size() == 1) {
            return ssel.getFirstElement();
        }
        return null;
    }

    protected void fillContextMenu(IMenuManager manager) {
        Object obj = this.getSelectedObject();
        if (obj instanceof ILocalSite) {
            manager.add((IAction)this.revertAction);
            manager.add((IAction)this.findUpdatesAction);
            manager.add((IAction)this.detectedChangesAction);
        } else if (obj instanceof IConfiguredSiteAdapter) {
            manager.add((IAction)this.siteStateAction);
        }
        if (obj instanceof ILocalSite || obj instanceof IConfiguredSiteAdapter) {
            manager.add((IContributionItem)new Separator());
            MenuManager mgr = new MenuManager(UpdateUI.getString("ConfigurationView.new"));
            mgr.add((IAction)this.newExtensionLocationAction);
            manager.add((IContributionItem)mgr);
            manager.add((IContributionItem)new Separator());
        } else if (obj instanceof ConfiguredFeatureAdapter) {
            try {
                MenuManager mgr = new MenuManager(UpdateUI.getString("ConfigurationView.replaceWith"));
                mgr.add((IAction)this.swapVersionAction);
                manager.add((IContributionItem)mgr);
                manager.add((IAction)this.featureStateAction);
                IFeature feature = ((ConfiguredFeatureAdapter)obj).getFeature(null);
                if (feature instanceof MissingFeature) {
                    manager.add((IAction)this.installOptFeatureAction);
                } else {
                    manager.add((IAction)this.uninstallFeatureAction);
                }
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.findUpdatesAction);
                manager.add((IContributionItem)new Separator());
            }
            catch (CoreException coreException) {}
        }
        this.drillDownAdapter.addNavigationActions(manager);
        if (obj instanceof ILocalSite) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.installationHistoryAction);
        }
        if (obj instanceof IFeatureAdapter || obj instanceof ILocalSite || obj instanceof IConfiguredSiteAdapter) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.propertiesAction);
        }
    }

    public void installSiteAdded(IConfiguredSite csite) {
        this.asyncRefresh();
    }

    public void installSiteRemoved(IConfiguredSite site) {
        this.asyncRefresh();
    }

    public void featureInstalled(IFeature feature) {
        this.asyncRefresh();
    }

    public void featureRemoved(IFeature feature) {
        this.asyncRefresh();
    }

    public void featureConfigured(IFeature feature) {
    }

    public void featureUnconfigured(IFeature feature) {
    }

    public void currentInstallConfigurationChanged(IInstallConfiguration configuration) {
        this.asyncRefresh();
    }

    public void installConfigurationRemoved(IInstallConfiguration configuration) {
        this.asyncRefresh();
    }

    private void asyncRefresh() {
        Display display = SWTUtil.getStandardDisplay();
        if (display == null) {
            return;
        }
        if (this.getControl().isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                if (!ConfigurationView.this.getControl().isDisposed()) {
                    ConfigurationView.this.treeViewer.refresh();
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] getFeatures(final IConfiguredSiteAdapter siteAdapter, final boolean configuredOnly) {
        final IConfiguredSite csite = siteAdapter.getConfiguredSite();
        final Object[][] bag = new Object[1][];
        this.refreshLock = true;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                IFeatureReference[] refs;
                ArrayList<ConfiguredFeatureAdapter> result = new ArrayList<ConfiguredFeatureAdapter>();
                if (configuredOnly) {
                    refs = csite.getConfiguredFeatures();
                } else {
                    ISite site = csite.getSite();
                    refs = site.getFeatureReferences();
                }
                monitor.beginTask(UpdateUI.getString("ConfigurationView.loading"), refs.length);
                int i = 0;
                while (i < refs.length) {
                    IFeature feature;
                    IFeatureReference ref = refs[i];
                    try {
                        monitor.subTask(ref.getURL().toString());
                        feature = ref.getFeature(null);
                    }
                    catch (CoreException coreException) {
                        feature = new MissingFeature(ref.getSite(), ref.getURL());
                    }
                    monitor.worked(1);
                    result.add(new ConfiguredFeatureAdapter(siteAdapter, feature, csite.isConfigured(feature), false, false));
                    ++i;
                }
                monitor.done();
                bag[0] = ConfigurationView.this.getRootFeatures(result);
            }
        };
        try {
            block7: {
                try {
                    if (this.configurationWindow.getShell().isVisible()) {
                        this.configurationWindow.run(true, false, op);
                        break block7;
                    }
                    op.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            Object var6_8 = null;
            this.refreshLock = false;
            return bag[0];
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.refreshLock = false;
            throw throwable;
        }
    }

    private Object[] getRootFeatures(ArrayList list) {
        ArrayList children = new ArrayList();
        ArrayList<ConfiguredFeatureAdapter> result = new ArrayList<ConfiguredFeatureAdapter>();
        try {
            IFeature feature;
            ConfiguredFeatureAdapter cf;
            int i = 0;
            while (i < list.size()) {
                cf = (ConfiguredFeatureAdapter)list.get(i);
                feature = cf.getFeature(null);
                if (feature != null) {
                    this.addChildFeatures(feature, cf.getConfiguredSite(), children, cf.isConfigured());
                }
                ++i;
            }
            i = 0;
            while (i < list.size()) {
                cf = (ConfiguredFeatureAdapter)list.get(i);
                feature = cf.getFeature(null);
                if (feature != null && !this.isChildFeature(feature, children)) {
                    result.add(cf);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return list.toArray();
        }
        return result.toArray();
    }

    private void addChildFeatures(IFeature feature, IConfiguredSite csite, ArrayList children, boolean configured) {
        try {
            IIncludedFeatureReference[] included = feature.getIncludedFeatureReferences();
            int i = 0;
            while (i < included.length) {
                MissingFeature childFeature;
                try {
                    childFeature = included[i].getFeature(!configured, csite, null);
                }
                catch (CoreException coreException) {
                    childFeature = new MissingFeature((IFeatureReference)included[i]);
                }
                children.add(childFeature);
                ++i;
            }
        }
        catch (CoreException e) {
            UpdateUI.logException(e);
        }
    }

    private boolean isChildFeature(IFeature feature, ArrayList children) {
        int i = 0;
        while (i < children.size()) {
            IFeature child = (IFeature)children.get(i);
            if (feature.getVersionedIdentifier().equals((Object)child.getVersionedIdentifier())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void handleDoubleClick(DoubleClickEvent e) {
        IStructuredSelection ssel;
        Object obj;
        if (e.getSelection() instanceof IStructuredSelection && (obj = (ssel = (IStructuredSelection)e.getSelection()).getFirstElement()) != null) {
            this.propertiesAction.run();
        }
    }

    public void createPartControl(Composite parent) {
        this.splitter = new SashForm(parent, 256);
        this.splitter.setLayoutData((Object)new GridData(1808));
        Composite leftContainer = this.createLineContainer((Composite)this.splitter);
        Composite rightContainer = this.createLineContainer((Composite)this.splitter);
        this.createTreeViewer(leftContainer);
        this.makeActions();
        this.createVerticalLine(leftContainer);
        this.createVerticalLine(rightContainer);
        this.preview = new ConfigurationPreview(this);
        this.preview.createControl(rightContainer);
        this.preview.getScrollingControl().setLayoutData((Object)new GridData(1808));
        this.splitter.setWeights(new int[]{2, 3});
        this.fillActionBars(this.getConfigurationWindow().getToolBarManager());
        this.treeViewer.expandToLevel(2);
    }

    private void createTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setUseHashlookup(true);
        this.initProviders();
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new GroupMarker("additions"));
                ConfigurationView.this.fillContextMenu(manager);
            }
        });
        this.treeViewer.getControl().setMenu(menuMgr.createContextMenu(this.treeViewer.getControl()));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConfigurationView.this.handleSelectionChanged(event);
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ConfigurationView.this.handleDoubleClick(event);
            }
        });
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private Composite createLineContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        container.setLayout((Layout)layout);
        return container;
    }

    private void createVerticalLine(Composite parent) {
        Label line = new Label(parent, 514);
        GridData gd = new GridData(16);
        gd.widthHint = 1;
        line.setLayoutData((Object)gd);
    }

    public Control getControl() {
        return this.splitter;
    }

    private int getStatusCode(IFeature feature, IStatus status) {
        int code = status.getCode();
        if (code == 2 && status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus child = children[i];
                if (child.isMultiStatus() || child.getCode() != -1) {
                    return code;
                }
                ++i;
            }
            if (UpdateUtils.hasObsoletePatches((IFeature)feature)) {
                return 0;
            }
        }
        return code;
    }

    protected void handleSelectionChanged(IStructuredSelection ssel) {
        Object obj = ssel.getFirstElement();
        if (obj instanceof IFeatureAdapter) {
            try {
                ConfiguredFeatureAdapter adapter = (ConfiguredFeatureAdapter)obj;
                IFeature feature = adapter.getFeature(null);
                boolean enable = adapter.isOptional() || !adapter.isIncluded();
                boolean missing = feature instanceof MissingFeature;
                this.featureStateAction.setFeature(adapter);
                this.featureStateAction.setEnabled(enable && !missing);
                if (enable && !missing && adapter.isConfigured()) {
                    IFeature[] features = UpdateUtils.getInstalledFeatures((IFeature)feature, (boolean)false);
                    this.swapVersionAction.setEnabled(features.length > 1);
                    if (features.length > 1) {
                        this.swapVersionAction.setCurrentFeature(feature);
                        this.swapVersionAction.setFeatures(features);
                    }
                    this.findUpdatesAction.setEnabled(true);
                    this.findUpdatesAction.setFeature(feature);
                } else {
                    this.swapVersionAction.setEnabled(false);
                    this.findUpdatesAction.setEnabled(false);
                }
                if (missing) {
                    MissingFeature mf = (MissingFeature)feature;
                    this.installOptFeatureAction.setEnabled(mf.isOptional() && mf.getOriginatingSiteURL() != null);
                    this.installOptFeatureAction.setFeature(mf);
                    this.uninstallFeatureAction.setEnabled(false);
                } else {
                    this.installOptFeatureAction.setEnabled(false);
                    this.uninstallFeatureAction.setFeature(adapter);
                    this.uninstallFeatureAction.setEnabled(enable && this.uninstallFeatureAction.canUninstall());
                }
            }
            catch (CoreException ex) {
                UpdateUI.logException(ex);
            }
        }
        if (obj instanceof ILocalSite) {
            this.propertiesAction.setEnabled(true);
            this.findUpdatesAction.setEnabled(true);
            this.findUpdatesAction.setFeature(null);
            this.detectedChangesAction.setEnabled(UpdateUtils.getSessionDeltas().length > 0);
            ILocalSite site = this.getLocalSite();
            this.revertAction.setEnabled(site != null && site.getConfigurationHistory().length > 1);
        } else if (obj instanceof IConfiguredSiteAdapter) {
            this.siteStateAction.setSite(((IConfiguredSiteAdapter)obj).getConfiguredSite());
            this.siteStateAction.setEnabled(true);
        }
        this.preview.setSelection(ssel);
    }

    protected void handleSelectionChanged(SelectionChangedEvent e) {
        this.handleSelectionChanged((IStructuredSelection)e.getSelection());
    }

    private void makePreviewTasks() {
        this.previewTasks = new Hashtable();
        ArrayList<PreviewTask> array = new ArrayList<PreviewTask>();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.update.configuration.ILocalSite;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> key = clazz;
        array.add(new PreviewTask(UpdateUI.getString("ConfigurationView.revertPreviousLabel"), UpdateUI.getString("ConfigurationView.revertPreviousDesc"), (IAction)this.revertAction));
        array.add(new PreviewTask(UpdateUI.getString("ConfigurationView.updateLabel"), UpdateUI.getString("ConfigurationView.updateDesc"), (IAction)this.findUpdatesAction));
        array.add(new PreviewTask(UpdateUI.getString("ConfigurationView.detectedLabel"), UpdateUI.getString("ConfigurationView.detectedDesc"), (IAction)this.detectedChangesAction));
        array.add(new PreviewTask(UpdateUI.getString("ConfigurationView.linkLabel"), UpdateUI.getString("ConfigurationView.linkDesc"), (IAction)this.newExtensionLocationAction));
        array.add(new PreviewTask(UpdateUI.getString("ConfigurationView.installHistLabel"), UpdateUI.getString("ConfigurationView.installHistDesc"), (IAction)this.installationHistoryAction));
        array.add(new PreviewTask(UpdateUI.getString("ConfigurationView.activitiesLabel"), UpdateUI.getString("ConfigurationView.activitiesDesc"), (IAction)this.propertiesAction));
        this.previewTasks.put(key, array.toArray(new IPreviewTask[array.size()]));
        array.clear();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.update.internal.ui.model.IConfiguredSiteAdapter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        key = clazz2;
        array.add(new PreviewTask(null, UpdateUI.getString("ConfigurationView.enableLocDesc"), (IAction)this.siteStateAction));
        array.add(new PreviewTask(UpdateUI.getString("ConfigurationView.extLocLabel"), UpdateUI.getString("ConfigurationView.extLocDesc"), (IAction)this.newExtensionLocationAction));
        array.add(new PreviewTask(UpdateUI.getString("ConfigurationView.propertiesLabel"), UpdateUI.getString("ConfigurationView.installPropDesc"), (IAction)this.propertiesAction));
        this.previewTasks.put(key, array.toArray(new IPreviewTask[array.size()]));
        array.clear();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Lorg.eclipse.update.internal.ui.model.IFeatureAdapter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        key = clazz3;
        array.add(new PreviewTask(UpdateUI.getString("ConfigurationView.replaceVersionLabel"), UpdateUI.getString("ConfigurationView.replaceVersionDesc"), (IAction)this.swapVersionAction));
        array.add(new PreviewTask(null, UpdateUI.getString("ConfigurationView.enableFeatureDesc"), (IAction)this.featureStateAction));
        array.add(new PreviewTask(UpdateUI.getString("ConfigurationView.installOptionalLabel"), UpdateUI.getString("ConfigurationView.installOptionalDesc"), (IAction)this.installOptFeatureAction));
        array.add(new PreviewTask(UpdateUI.getString("ConfigurationView.uninstallLabel"), UpdateUI.getString("ConfigurationView.uninstallDesc"), (IAction)this.uninstallFeatureAction));
        array.add(new PreviewTask(UpdateUI.getString("ConfigurationView.scanLabel"), UpdateUI.getString("ConfigurationView.scanDesc"), (IAction)this.findUpdatesAction));
        array.add(new PreviewTask(UpdateUI.getString("ConfigurationView.featurePropLabel"), UpdateUI.getString("ConfigurationView.featurePropDesc"), (IAction)this.propertiesAction));
        this.previewTasks.put(key, array.toArray(new IPreviewTask[array.size()]));
    }

    public IPreviewTask[] getPreviewTasks(Object object) {
        IPreviewTask[] tasks = null;
        if (object instanceof IFeatureAdapter) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("[Lorg.eclipse.update.internal.ui.model.IFeatureAdapter;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            tasks = (IPreviewTask[])this.previewTasks.get(clazz);
        }
        if (object instanceof ILocalSite) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.update.configuration.ILocalSite;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            tasks = (IPreviewTask[])this.previewTasks.get(clazz);
        }
        if (object instanceof IConfiguredSiteAdapter) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.update.internal.ui.model.IConfiguredSiteAdapter;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            tasks = (IPreviewTask[])this.previewTasks.get(clazz);
        }
        return tasks != null ? tasks : new IPreviewTask[]{};
    }

    ConfigurationManagerWindow getConfigurationWindow() {
        return this.configurationWindow;
    }

    class ConfigurationSorter
    extends ViewerSorter {
        ConfigurationSorter() {
        }

        public int category(Object obj) {
            if (obj instanceof IConfiguredSiteAdapter) {
                IConfiguredSite csite = ((IConfiguredSiteAdapter)obj).getConfiguredSite();
                if (csite.isProductSite()) {
                    return 1;
                }
                if (csite.isExtensionSite()) {
                    return 2;
                }
                return 3;
            }
            return super.category(obj);
        }
    }

    class LocalSiteProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        LocalSiteProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                return;
            }
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof UpdateModel) {
                Object[] objectArray;
                ILocalSite localSite = ConfigurationView.this.getLocalSite();
                if (localSite != null) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = localSite;
                } else {
                    objectArray = new Object[]{};
                }
                return objectArray;
            }
            if (parent instanceof ILocalSite) {
                Object[] csites = ConfigurationView.this.openLocalSite();
                if (ConfigurationView.this.showSitesAction.isChecked()) {
                    return csites;
                }
                ArrayList<Object> result = new ArrayList<Object>();
                boolean showUnconf = ConfigurationView.this.showUnconfFeaturesAction.isChecked();
                int i = 0;
                while (i < csites.length) {
                    IConfiguredSiteAdapter adapter = (IConfiguredSiteAdapter)csites[i];
                    Object[] roots = ConfigurationView.this.getFeatures(adapter, !showUnconf);
                    int j = 0;
                    while (j < roots.length) {
                        result.add(roots[j]);
                        ++j;
                    }
                    ++i;
                }
                return result.toArray();
            }
            if (parent instanceof IConfiguredSiteAdapter) {
                return ConfigurationView.this.getFeatures((IConfiguredSiteAdapter)parent, !ConfigurationView.this.showUnconfFeaturesAction.isChecked());
            }
            if (parent instanceof ConfiguredFeatureAdapter && ConfigurationView.this.showNestedFeaturesAction.isChecked()) {
                Object[] nested = ((ConfiguredFeatureAdapter)parent).getIncludedFeatures(null);
                if (ConfigurationView.this.showUnconfFeaturesAction.isChecked()) {
                    return nested;
                }
                ArrayList<Object> result = new ArrayList<Object>();
                int i = 0;
                while (i < nested.length) {
                    if (((ConfiguredFeatureAdapter)nested[i]).isConfigured()) {
                        result.add(nested[i]);
                    }
                    ++i;
                }
                return result.toArray(new IFeatureAdapter[result.size()]);
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            return null;
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof ConfiguredFeatureAdapter) {
                if (!ConfigurationView.this.showNestedFeaturesAction.isChecked()) {
                    return false;
                }
                IFeatureAdapter[] features = ((ConfiguredFeatureAdapter)parent).getIncludedFeatures(null);
                if (ConfigurationView.this.showUnconfFeaturesAction.isChecked()) {
                    return features.length > 0;
                }
                int i = 0;
                while (i < features.length) {
                    if (((ConfiguredFeatureAdapter)features[i]).isConfigured()) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            if (parent instanceof ConfiguredSiteAdapter) {
                IConfiguredSite site = ((ConfiguredSiteAdapter)parent).getConfiguredSite();
                if (site.isEnabled()) {
                    if (!ConfigurationView.this.showUnconfFeaturesAction.isChecked()) {
                        return site.getConfiguredFeatures().length > 0;
                    }
                    return site.getFeatureReferences().length > 0;
                }
                return ConfigurationView.this.showUnconfFeaturesAction.isChecked();
            }
            return true;
        }

        public Object[] getElements(Object input) {
            return this.getChildren(input);
        }
    }

    class LocalSiteLabelProvider
    extends LabelProvider {
        LocalSiteLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof ILocalSite) {
                AboutInfo info = UpdateUI.getDefault().getAboutInfo();
                String productName = info.getProductName();
                if (productName != null) {
                    return productName;
                }
                return UpdateUI.getString("ConfigurationView.current");
            }
            if (obj instanceof IConfiguredSiteAdapter) {
                IConfiguredSite csite = ((IConfiguredSiteAdapter)obj).getConfiguredSite();
                ISite site = csite.getSite();
                return site.getURL().toString();
            }
            if (obj instanceof IFeatureAdapter) {
                try {
                    IFeature feature = ((IFeatureAdapter)obj).getFeature(null);
                    if (feature instanceof MissingFeature) {
                        return UpdateUI.getFormattedMessage("ConfigurationView.missingFeature", feature.getLabel());
                    }
                    String version = feature.getVersionedIdentifier().getVersion().toString();
                    String pending = "";
                    if (OperationsManager.findPendingOperation((IFeature)feature) != null) {
                        pending = UpdateUI.getString("ConfigurationView.pending");
                    }
                    return String.valueOf(feature.getLabel()) + " " + version + pending;
                }
                catch (CoreException coreException) {
                    return UpdateUI.getString("ConfigurationView.error");
                }
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
            if (obj instanceof ILocalSite) {
                return ConfigurationView.this.eclipseImage;
            }
            if (obj instanceof ConfiguredFeatureAdapter) {
                return this.getFeatureImage(provider, (ConfiguredFeatureAdapter)obj);
            }
            if (obj instanceof IConfiguredSiteAdapter) {
                int flags;
                IConfiguredSite csite = ((IConfiguredSiteAdapter)obj).getConfiguredSite();
                int n = flags = csite.isUpdatable() ? 0 : 16;
                if (!csite.isEnabled()) {
                    flags |= 0x80;
                }
                return provider.get(provider.getLocalSiteDescriptor(csite), flags);
            }
            return null;
        }

        private Image getFeatureImage(UpdateLabelProvider provider, ConfiguredFeatureAdapter adapter) {
            try {
                ILocalSite localSite;
                IFeature feature = adapter.getFeature(null);
                if (feature instanceof MissingFeature) {
                    if (((MissingFeature)feature).isOptional()) {
                        return provider.get(UpdateUIImages.DESC_NOTINST_FEATURE_OBJ);
                    }
                    return provider.get(UpdateUIImages.DESC_FEATURE_OBJ, 1);
                }
                boolean efix = feature.isPatch();
                ImageDescriptor baseDesc = efix ? UpdateUIImages.DESC_EFIX_OBJ : (adapter.isConfigured() ? UpdateUIImages.DESC_FEATURE_OBJ : UpdateUIImages.DESC_UNCONF_FEATURE_OBJ);
                int flags = 0;
                if (efix && !adapter.isConfigured()) {
                    flags |= 0x80;
                }
                if (OperationsManager.findPendingOperation((IFeature)feature) == null && (localSite = ConfigurationView.this.getLocalSite()) != null) {
                    int code = ConfigurationView.this.getStatusCode(feature, localSite.getFeatureStatus(feature));
                    switch (code) {
                        case 2: {
                            flags |= 1;
                            break;
                        }
                        case 1: {
                            flags |= 2;
                            break;
                        }
                        default: {
                            if (!adapter.isConfigured() || !adapter.isUpdated()) break;
                            flags |= 0x40;
                        }
                    }
                }
                return provider.get(baseDesc, flags);
            }
            catch (CoreException coreException) {
                return provider.get(UpdateUIImages.DESC_FEATURE_OBJ, 1);
            }
        }
    }

    class PreviewTask
    implements IPreviewTask {
        private String name;
        private String desc;
        private IAction action;

        public PreviewTask(String name, String desc, IAction action) {
            this.name = name;
            this.desc = desc;
            this.action = action;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            return this.action.getText();
        }

        public String getDescription() {
            return this.desc;
        }

        public void run() {
            this.action.run();
        }

        public boolean isEnabled() {
            return this.action.isEnabled();
        }
    }
}

