/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.model.IConfiguredSiteAdapter;
import org.eclipse.update.internal.ui.model.IFeatureAdapter;
import org.eclipse.update.internal.ui.model.IUpdateModelChangedListener;
import org.eclipse.update.internal.ui.model.UpdateModel;
import org.eclipse.update.internal.ui.views.ConfigurationView;
import org.eclipse.update.internal.ui.views.IPreviewTask;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.HTMLTableLayout;
import org.eclipse.update.ui.forms.internal.HyperlinkSettings;
import org.eclipse.update.ui.forms.internal.TableData;
import org.eclipse.update.ui.forms.internal.WebForm;
import org.eclipse.update.ui.forms.internal.engine.FormEngine;
import org.eclipse.update.ui.forms.internal.engine.HTTPAction;
import org.eclipse.update.ui.forms.internal.engine.IHyperlinkSegment;

public class ConfigurationPreviewForm
extends WebForm
implements IUpdateModelChangedListener {
    private Control focusControl;
    private ConfigurationView view;
    private FormEngine desc;
    private FormEngine taskList;
    private IPreviewTask[] tasks;

    public ConfigurationPreviewForm(ConfigurationView view) {
        this.view = view;
        UpdateModel model = UpdateUI.getDefault().getUpdateModel();
        model.addUpdateModelChangedListener(this);
    }

    public void dispose() {
        UpdateModel model = UpdateUI.getDefault().getUpdateModel();
        model.removeUpdateModelChangedListener(this);
        super.dispose();
    }

    public Control getScrollingControl() {
        return this.scrollComposite;
    }

    public void objectsAdded(Object parent, Object[] children) {
    }

    public void objectsRemoved(Object parent, Object[] children) {
    }

    public void objectChanged(Object object, String property) {
    }

    public void initialize(Object model) {
        super.initialize(model);
        if (this.isWhiteBackground()) {
            this.setHeadingImage(UpdateUIImages.get(UpdateUIImages.IMG_FORM_BANNER_SHORT));
        }
        this.refreshSize();
    }

    private boolean isWhiteBackground() {
        Color color = this.getFactory().getBackgroundColor();
        return color.getRed() == 255 && color.getGreen() == 255 && color.getBlue() == 255;
    }

    protected void refreshSize() {
        ((Composite)this.getControl()).layout();
        this.updateSize();
    }

    protected void setFocusControl(Control control) {
        this.focusControl = control;
    }

    public void setFocus() {
        if (this.focusControl != null) {
            this.focusControl.setFocus();
        }
    }

    protected void createContents(Composite parent) {
        HTMLTableLayout layout = new HTMLTableLayout();
        parent.setLayout((Layout)layout);
        layout.leftMargin = 10;
        layout.rightMargin = 5;
        layout.topMargin = 10;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 20;
        layout.numColumns = 1;
        FormWidgetFactory factory = this.getFactory();
        HTTPAction action = new HTTPAction(){

            public void linkActivated(IHyperlinkSegment link) {
                String url = link.getArg();
                if (url != null) {
                    UpdateUI.showURL(url);
                }
            }
        };
        action.setStatusLineManager((IStatusLineManager)this.view.getConfigurationWindow().getStatusLineManager());
        HTTPAction taskAction = new HTTPAction(){

            public void linkActivated(IHyperlinkSegment link) {
                String indexArg = link.getArg();
                try {
                    int index = Integer.parseInt(indexArg);
                    if (ConfigurationPreviewForm.this.tasks != null) {
                        ConfigurationPreviewForm.this.tasks[index].run();
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        };
        taskAction.setStatusLineManager((IStatusLineManager)this.view.getConfigurationWindow().getStatusLineManager());
        this.desc = factory.createFormEngine(parent);
        this.desc.setHyperlinkSettings((HyperlinkSettings)factory.getHyperlinkHandler());
        this.desc.registerTextObject("urlHandler", (Object)action);
        this.desc.load("", false, false);
        this.setFocusControl((Control)this.desc);
        TableData td = new TableData();
        td.align = 7;
        td.grabHorizontal = true;
        this.desc.setLayoutData((Object)td);
        this.taskList = factory.createFormEngine(parent);
        this.taskList.setHyperlinkSettings((HyperlinkSettings)factory.getHyperlinkHandler());
        this.taskList.registerTextObject("task", (Object)taskAction);
        this.taskList.load("", false, false);
        td = new TableData();
        td.align = 7;
        td.grabHorizontal = true;
        this.taskList.setLayoutData((Object)td);
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.update.ui.SiteForm");
    }

    public void expandTo(Object object) {
        this.tasks = this.view.getPreviewTasks(object);
        String title = this.getObjectLabel(object);
        this.setHeadingText(title);
        String description = this.getObjectDescription(object);
        boolean tags = description.startsWith("<form>");
        this.desc.load(description, tags, !tags);
        String taskText = this.getTasksText();
        this.taskList.load(taskText, true, false);
        this.taskList.getParent().layout();
        ((Composite)this.getControl()).layout();
        this.updateSize();
        this.getControl().redraw();
    }

    private String getObjectLabel(Object object) {
        if (object == null) {
            return "";
        }
        TreeViewer viewer = this.view.getTreeViewer();
        LabelProvider provider = (LabelProvider)viewer.getLabelProvider();
        return provider.getText(object);
    }

    private String getObjectDescription(Object object) {
        if (object instanceof IFeatureAdapter) {
            return this.getFeatureDescription((IFeatureAdapter)object);
        }
        if (object instanceof IConfiguredSiteAdapter) {
            return UpdateUI.getString("ConfigurationPreviewForm.install");
        }
        if (object instanceof ILocalSite) {
            return UpdateUI.getString("ConfigurationPreviewForm.configDescription");
        }
        return "";
    }

    private String getFeatureDescription(IFeatureAdapter adapter) {
        try {
            String text;
            IFeature feature = adapter.getFeature(null);
            IURLEntry entry = feature.getDescription();
            if (entry != null && (text = entry.getAnnotation()) != null) {
                URL url = entry.getURL();
                if (url == null) {
                    return text;
                }
                String link = " <a href=\"urlHandler\" arg=\"" + url + "\">More info...</a>";
                String fullText = "<form><p>" + text + link + "</p></form>";
                return fullText;
            }
        }
        catch (CoreException coreException) {}
        return "";
    }

    private String getTasksText() {
        if (this.tasks == null || this.tasks.length == 0) {
            return "<form/>";
        }
        boolean hasEnabledTasks = false;
        int i = 0;
        while (i < this.tasks.length) {
            if (this.tasks[i].isEnabled()) {
                hasEnabledTasks = true;
                break;
            }
            ++i;
        }
        if (!hasEnabledTasks) {
            return "<form/>";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<form><p><b>Available Tasks</b></p>");
        int i2 = 0;
        while (i2 < this.tasks.length) {
            IPreviewTask task = this.tasks[i2];
            if (task.isEnabled()) {
                buf.append("<li style=\"text\" indent=\"0\"><a href=\"task\" arg=\"" + i2 + "\">" + task.getName() + "</a></li>");
                buf.append("<li style=\"text\" indent=\"10\" addVerticalSpace=\"false\">" + task.getDescription() + "</li>");
            }
            ++i2;
        }
        buf.append("</form>");
        return buf.toString();
    }
}

